/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.vfs.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.util.Pair;
import ksp.com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import ksp.com.intellij.openapi.util.io.FileAttributes;
import ksp.com.intellij.openapi.util.io.FileUtil;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.openapi.vfs.impl.AddonlyKeylessHash;
import ksp.com.intellij.reference.SoftReference;
import ksp.com.intellij.util.ArrayUtil;
import ksp.com.intellij.util.SmartList;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public abstract class ArchiveHandler {
    public static final long DEFAULT_LENGTH = 0L;
    public static final long DEFAULT_TIMESTAMP = -1L;
    public static final FileAttributes DIRECTORY_ATTRIBUTES = new FileAttributes(true, false, false, false, 0L, -1L, false, FileAttributes.CaseSensitivity.SENSITIVE);
    private volatile File myPath;
    private final Object myLock;
    private volatile Reference<Map<String, EntryInfo>> myEntries;
    private volatile Reference<AddonlyKeylessHash<EntryInfo, Object>> myChildrenEntries;
    private boolean myCorrupted;
    private static final AddonlyKeylessHash.KeyValueMapper<EntryInfo, Object> ourKeyValueMapper = new AddonlyKeylessHash.KeyValueMapper<EntryInfo, Object>(){

        @Override
        public int hash(EntryInfo info) {
            return System.identityHashCode(info);
        }

        @Override
        public EntryInfo key(Object o2) {
            if (o2 instanceof EntryInfo) {
                return ((EntryInfo)o2).parent;
            }
            return ((EntryInfo[])o2)[0].parent;
        }
    };

    protected ArchiveHandler(@NotNull String path) {
        if (path == null) {
            ArchiveHandler.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myEntries = new java.lang.ref.SoftReference<Object>(null);
        this.myChildrenEntries = new java.lang.ref.SoftReference<Object>(null);
        this.myPath = new File(path);
    }

    @NotNull
    public File getFile() {
        File file2 = this.myPath;
        if (file2 == null) {
            ArchiveHandler.$$$reportNull$$$0(1);
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFile(@NotNull File path) {
        if (path == null) {
            ArchiveHandler.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            assert (this.myEntries.get() == null && this.myChildrenEntries.get() == null && !this.myCorrupted) : "Archive already opened";
            this.myPath = path;
        }
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull String relativePath) {
        if (relativePath == null) {
            ArchiveHandler.$$$reportNull$$$0(3);
        }
        if (!relativePath.isEmpty()) {
            EntryInfo e2 = this.getEntryInfo(relativePath);
            if (e2 != null) {
                return new FileAttributes(e2.isDirectory, false, false, false, e2.length, e2.timestamp, false, FileAttributes.CaseSensitivity.SENSITIVE);
            }
        } else if (Files.exists(this.myPath.toPath(), new LinkOption[0])) {
            return DIRECTORY_ATTRIBUTES;
        }
        return null;
    }

    public String @NotNull [] list(@NotNull String relativePath) {
        EntryInfo entry;
        if (relativePath == null) {
            ArchiveHandler.$$$reportNull$$$0(4);
        }
        if ((entry = this.getEntryInfo(relativePath)) == null || !entry.isDirectory) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                ArchiveHandler.$$$reportNull$$$0(5);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        AddonlyKeylessHash<EntryInfo, Object> result2 = this.getParentChildrenMap();
        Object o2 = result2.get(entry);
        if (o2 == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                ArchiveHandler.$$$reportNull$$$0(6);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (o2 instanceof EntryInfo) {
            String[] stringArray = new String[]{((EntryInfo)o2).shortName.toString()};
            if (stringArray == null) {
                ArchiveHandler.$$$reportNull$$$0(7);
            }
            return stringArray;
        }
        EntryInfo[] infos = (EntryInfo[])o2;
        String[] names = new String[infos.length];
        for (int i2 = 0; i2 < infos.length; ++i2) {
            names[i2] = infos[i2].shortName.toString();
        }
        if (names == null) {
            ArchiveHandler.$$$reportNull$$$0(8);
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddonlyKeylessHash<EntryInfo, Object> getParentChildrenMap() {
        AddonlyKeylessHash<EntryInfo, Object> map = SoftReference.dereference(this.myChildrenEntries);
        if (map == null) {
            Object object = this.myLock;
            synchronized (object) {
                map = SoftReference.dereference(this.myChildrenEntries);
                if (map == null) {
                    if (this.myCorrupted) {
                        map = new AddonlyKeylessHash<EntryInfo, Object>(ourKeyValueMapper);
                    } else {
                        try {
                            map = this.createParentChildrenMap();
                        }
                        catch (Exception e2) {
                            this.myCorrupted = true;
                            Logger.getInstance(this.getClass()).warn(e2.getMessage() + ": " + this.myPath, e2);
                            map = new AddonlyKeylessHash<EntryInfo, Object>(ourKeyValueMapper);
                        }
                    }
                    this.myChildrenEntries = new java.lang.ref.SoftReference<AddonlyKeylessHash<EntryInfo, Object>>(map);
                }
            }
        }
        return map;
    }

    private AddonlyKeylessHash<EntryInfo, Object> createParentChildrenMap() {
        HashMap map = new HashMap();
        for (EntryInfo info : this.getEntriesMap().values()) {
            if (info.isDirectory && !map.containsKey(info)) {
                map.put(info, new SmartList());
            }
            if (info.parent == null) continue;
            SmartList<EntryInfo> parentChildren = (SmartList<EntryInfo>)map.get(info.parent);
            if (parentChildren == null) {
                parentChildren = new SmartList<EntryInfo>();
                map.put(info.parent, parentChildren);
            }
            parentChildren.add(info);
        }
        AddonlyKeylessHash<EntryInfo, Object> result2 = new AddonlyKeylessHash<EntryInfo, Object>(map.size(), ourKeyValueMapper);
        for (List children2 : map.values()) {
            int numberOfChildren = children2.size();
            if (numberOfChildren == 1) {
                result2.add(children2.get(0));
                continue;
            }
            if (numberOfChildren <= 1) continue;
            result2.add(children2.toArray(new EntryInfo[numberOfChildren]));
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.OverrideOnly
    public void clearCaches() {
        Object object = this.myLock;
        synchronized (object) {
            this.myEntries.clear();
            this.myChildrenEntries.clear();
            this.myCorrupted = false;
        }
    }

    @Nullable
    protected EntryInfo getEntryInfo(@NotNull String relativePath) {
        if (relativePath == null) {
            ArchiveHandler.$$$reportNull$$$0(9);
        }
        return this.getEntriesMap().get(relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, EntryInfo> getEntriesMap() {
        Map<String, EntryInfo> map = SoftReference.dereference(this.myEntries);
        if (map == null) {
            Object object = this.myLock;
            synchronized (object) {
                map = SoftReference.dereference(this.myEntries);
                if (map == null) {
                    if (this.myCorrupted) {
                        map = Collections.emptyMap();
                    } else {
                        try {
                            map = this.createEntriesMap();
                        }
                        catch (Exception e2) {
                            this.myCorrupted = true;
                            Logger.getInstance(this.getClass()).warn(e2.getMessage() + ": " + this.myPath, e2);
                            map = Collections.emptyMap();
                        }
                    }
                    this.myEntries = new java.lang.ref.SoftReference<Map<String, EntryInfo>>(map);
                    this.myChildrenEntries = new java.lang.ref.SoftReference<Object>(null);
                }
            }
        }
        Map<String, EntryInfo> map2 = map;
        if (map2 == null) {
            ArchiveHandler.$$$reportNull$$$0(10);
        }
        return map2;
    }

    @NotNull
    protected abstract Map<String, EntryInfo> createEntriesMap() throws IOException;

    @NotNull
    protected EntryInfo createRootEntry() {
        return new EntryInfo("", true, 0L, -1L, null);
    }

    protected final void processEntry(@NotNull Map<String, EntryInfo> map, @NotNull String entryName, @Nullable BiFunction<@NotNull EntryInfo, @NotNull String, ? extends @NotNull EntryInfo> entryFun) {
        if (map == null) {
            ArchiveHandler.$$$reportNull$$$0(11);
        }
        if (entryName == null) {
            ArchiveHandler.$$$reportNull$$$0(12);
        }
        this.processEntry(map, null, entryName, entryFun);
    }

    protected final void processEntry(@NotNull Map<String, EntryInfo> map, @Nullable Logger logger2, @NotNull String entryName, @Nullable BiFunction<@NotNull EntryInfo, @NotNull String, ? extends @NotNull EntryInfo> entryFun) {
        String normalizedName;
        if (map == null) {
            ArchiveHandler.$$$reportNull$$$0(13);
        }
        if (entryName == null) {
            ArchiveHandler.$$$reportNull$$$0(14);
        }
        if ((normalizedName = this.normalizeName(entryName)).isEmpty() || normalizedName.contains("..") && ArrayUtil.contains("..", normalizedName.split("/"))) {
            if (logger2 != null) {
                logger2.trace("invalid entry: " + this.getFile() + "!/" + entryName);
            }
            return;
        }
        if (entryFun == null) {
            this.directoryEntry(map, logger2, normalizedName);
            return;
        }
        EntryInfo existing = map.get(normalizedName);
        if (existing != null) {
            if (logger2 != null) {
                logger2.trace("duplicate entry: " + this.getFile() + "!/" + normalizedName);
            }
            return;
        }
        Pair<String, String> path = ArchiveHandler.split(normalizedName);
        EntryInfo parent2 = this.directoryEntry(map, logger2, (String)path.first);
        map.put(normalizedName, entryFun.apply(parent2, (String)path.second));
    }

    @NotNull
    protected String normalizeName(@NotNull String entryName) {
        if (entryName == null) {
            ArchiveHandler.$$$reportNull$$$0(15);
        }
        String string2 = StringUtil.trimTrailing(StringUtil.trimLeading(FileUtil.normalize(entryName), '/'), '/');
        if (string2 == null) {
            ArchiveHandler.$$$reportNull$$$0(16);
        }
        return string2;
    }

    private EntryInfo directoryEntry(Map<String, EntryInfo> map, @Nullable Logger logger2, String normalizedName) {
        EntryInfo entry = map.get(normalizedName);
        if (entry == null || !entry.isDirectory) {
            if (logger2 != null && entry != null) {
                logger2.trace("duplicate entry: " + this.getFile() + "!/" + normalizedName);
            }
            if (normalizedName.isEmpty()) {
                entry = this.createRootEntry();
            } else {
                Pair<String, String> path = ArchiveHandler.split(normalizedName);
                EntryInfo parent2 = this.directoryEntry(map, logger2, (String)path.first);
                entry = new EntryInfo((CharSequence)path.second, true, 0L, -1L, parent2);
            }
            map.put(normalizedName, entry);
        }
        return entry;
    }

    private static Pair<String, String> split(String normalizedName) {
        int p = normalizedName.lastIndexOf(47);
        String parentPath = p > 0 ? normalizedName.substring(0, p) : "";
        String shortName2 = p > 0 ? normalizedName.substring(p + 1) : normalizedName;
        return new Pair<String, String>(parentPath, shortName2);
    }

    public abstract byte @NotNull [] contentsToByteArray(@NotNull String var1) throws IOException;

    @NotNull
    public InputStream getInputStream(@NotNull String relativePath) throws IOException {
        if (relativePath == null) {
            ArchiveHandler.$$$reportNull$$$0(17);
        }
        return new BufferExposingByteArrayInputStream(this.contentsToByteArray(relativePath));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/vfs/impl/ArchiveHandler";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/vfs/impl/ArchiveHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntriesMap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEntryInfo";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processEntry";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "normalizeName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class EntryInfo {
        public final EntryInfo parent;
        public final CharSequence shortName;
        public final boolean isDirectory;
        public final long length;
        public final long timestamp;

        /*
         * WARNING - void declaration
         */
        public EntryInfo(@NotNull CharSequence shortName2, boolean isDirectory, long length, long timestamp, @Nullable EntryInfo entryInfo) {
            void parent2;
            if (shortName2 == null) {
                EntryInfo.$$$reportNull$$$0(0);
            }
            this.parent = parent2;
            this.shortName = shortName2;
            this.isDirectory = isDirectory;
            this.length = length;
            this.timestamp = timestamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "ksp/com/intellij/openapi/vfs/impl/ArchiveHandler$EntryInfo", "<init>"));
        }
    }
}

