/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.lang.java.parser;

import java.util.Set;
import ksp.com.intellij.lang.PsiBuilder;
import ksp.com.intellij.lang.WhitespacesBinders;
import ksp.com.intellij.lang.java.parser.BasicJavaParser;
import ksp.com.intellij.lang.java.parser.BasicJavaParserUtil;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.JavaDocTokenType;
import ksp.com.intellij.psi.TokenType;
import ksp.com.intellij.psi.impl.source.AbstractBasicJavaDocElementTypeFactory;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class BasicJavaDocParser {
    private static final TokenSet TAG_VALUES_SET = TokenSet.create(JavaDocTokenType.DOC_TAG_VALUE_TOKEN, JavaDocTokenType.DOC_TAG_VALUE_COMMA, JavaDocTokenType.DOC_TAG_VALUE_DOT, JavaDocTokenType.DOC_TAG_VALUE_LPAREN, JavaDocTokenType.DOC_TAG_VALUE_RPAREN, JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN, JavaDocTokenType.DOC_TAG_VALUE_LT, JavaDocTokenType.DOC_TAG_VALUE_GT, JavaDocTokenType.DOC_TAG_VALUE_COLON, JavaDocTokenType.DOC_TAG_VALUE_QUOTE);
    private static final TokenSet INLINE_TAG_BORDERS_SET = TokenSet.create(JavaDocTokenType.DOC_INLINE_TAG_START, JavaDocTokenType.DOC_INLINE_TAG_END);
    private static final TokenSet SKIP_TOKENS = TokenSet.create(JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS);
    private static final String SEE_TAG = "@see";
    private static final String LINK_TAG = "@link";
    private static final String LINK_PLAIN_TAG = "@linkplain";
    private static final String PARAM_TAG = "@param";
    private static final String VALUE_TAG = "@value";
    private static final String SNIPPET_TAG = "@snippet";
    private static final Set<String> REFERENCE_TAGS = ContainerUtil.immutableSet("@throws", "@exception", "@provides", "@uses");
    private static final Key<Integer> BRACE_SCOPE_KEY = Key.create("Javadoc.Parser.Brace.Scope");

    private BasicJavaDocParser() {
    }

    public static void parseJavadocReference(@NotNull PsiBuilder builder2, @NotNull BasicJavaParser parser) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(0);
        }
        if (parser == null) {
            BasicJavaDocParser.$$$reportNull$$$0(1);
        }
        parser.getReferenceParser().parseJavaCodeReference(builder2, true, true, false, false);
        BasicJavaDocParser.swallowTokens(builder2);
    }

    public static void parseJavadocType(@NotNull PsiBuilder builder2, @NotNull BasicJavaParser parser) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(2);
        }
        if (parser == null) {
            BasicJavaDocParser.$$$reportNull$$$0(3);
        }
        parser.getReferenceParser().parseType(builder2, 7);
        BasicJavaDocParser.swallowTokens(builder2);
    }

    private static void swallowTokens(PsiBuilder builder2) {
        while (!builder2.eof()) {
            builder2.advanceLexer();
        }
    }

    public static void parseDocCommentText(@NotNull PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(4);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(5);
        }
        builder2.enforceCommentTokens(SKIP_TOKENS);
        while (!builder2.eof()) {
            IElementType tokenType = BasicJavaDocParser.getTokenType(builder2);
            if (tokenType == JavaDocTokenType.DOC_TAG_NAME) {
                BasicJavaDocParser.parseTag(builder2, javaDocElementTypeContainer);
                continue;
            }
            BasicJavaDocParser.parseDataItem(builder2, null, false, javaDocElementTypeContainer);
        }
    }

    private static void parseTag(PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType tokenType;
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(6);
        }
        String tagName = builder2.getTokenText();
        PsiBuilder.Marker tag = builder2.mark();
        builder2.advanceLexer();
        while ((tokenType = BasicJavaDocParser.getTokenType(builder2)) != null && tokenType != JavaDocTokenType.DOC_TAG_NAME && tokenType != JavaDocTokenType.DOC_COMMENT_END) {
            BasicJavaDocParser.parseDataItem(builder2, tagName, false, javaDocElementTypeContainer);
        }
        tag.done(javaDocElementTypeContainer.DOC_TAG);
    }

    private static void parseDataItem(PsiBuilder builder2, @Nullable String tagName, boolean isInline, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType tokenType;
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(7);
        }
        if ((tokenType = BasicJavaDocParser.getTokenType(builder2)) == JavaDocTokenType.DOC_INLINE_TAG_START) {
            int braceScope = BasicJavaDocParser.getBraceScope(builder2);
            if (braceScope > 0) {
                BasicJavaDocParser.setBraceScope(builder2, braceScope + 1);
                builder2.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
                builder2.advanceLexer();
                return;
            }
            PsiBuilder.Marker tag = builder2.mark();
            builder2.advanceLexer();
            tokenType = BasicJavaDocParser.getTokenType(builder2);
            if (tokenType != JavaDocTokenType.DOC_TAG_NAME && tokenType != JavaDocTokenType.DOC_COMMENT_BAD_CHARACTER) {
                tag.rollbackTo();
                builder2.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
                builder2.advanceLexer();
                return;
            }
            BasicJavaDocParser.setBraceScope(builder2, braceScope + 1);
            String inlineTagName = "";
            while (true) {
                if ((tokenType = BasicJavaDocParser.getTokenType(builder2)) == JavaDocTokenType.DOC_TAG_NAME) {
                    inlineTagName = builder2.getTokenText();
                } else if (tokenType == null || tokenType == JavaDocTokenType.DOC_COMMENT_END) break;
                BasicJavaDocParser.parseDataItem(builder2, inlineTagName, true, javaDocElementTypeContainer);
                if (tokenType != JavaDocTokenType.DOC_INLINE_TAG_END) continue;
                braceScope = BasicJavaDocParser.getBraceScope(builder2);
                if (braceScope > 0) {
                    BasicJavaDocParser.setBraceScope(builder2, --braceScope);
                }
                if (braceScope == 0) break;
            }
            if (SNIPPET_TAG.equals(inlineTagName)) {
                tag.done(javaDocElementTypeContainer.DOC_SNIPPET_TAG);
            } else {
                tag.done(javaDocElementTypeContainer.DOC_INLINE_TAG);
            }
        } else if (TAG_VALUES_SET.contains(tokenType)) {
            if (SEE_TAG.equals(tagName) && !isInline || LINK_TAG.equals(tagName) && isInline || BasicJavaParserUtil.getLanguageLevel(builder2).isAtLeast(LanguageLevel.JDK_1_4) && LINK_PLAIN_TAG.equals(tagName) && isInline) {
                BasicJavaDocParser.parseSeeTagValue(builder2, false, javaDocElementTypeContainer);
            } else if (!isInline && tagName != null && REFERENCE_TAGS.contains(tagName)) {
                PsiBuilder.Marker tagValue = builder2.mark();
                builder2.remapCurrentToken(javaDocElementTypeContainer.DOC_REFERENCE_HOLDER);
                builder2.advanceLexer();
                tagValue.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
            } else if (!isInline && PARAM_TAG.equals(tagName)) {
                BasicJavaDocParser.parseParameterRef(builder2, javaDocElementTypeContainer);
            } else if (BasicJavaParserUtil.getLanguageLevel(builder2).isAtLeast(LanguageLevel.JDK_1_5) && VALUE_TAG.equals(tagName) && isInline) {
                BasicJavaDocParser.parseSeeTagValue(builder2, true, javaDocElementTypeContainer);
            } else if (SNIPPET_TAG.equals(tagName) && isInline) {
                BasicJavaDocParser.parseSnippetTagValue(builder2, javaDocElementTypeContainer);
            } else {
                BasicJavaDocParser.parseSimpleTagValue(builder2, javaDocElementTypeContainer);
            }
        } else {
            BasicJavaDocParser.remapAndAdvance(builder2);
        }
    }

    private static void parseSnippetTagValue(@NotNull PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType token;
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(8);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(9);
        }
        PsiBuilder.Marker snippetValue = builder2.mark();
        snippetValue.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        while ((token = BasicJavaDocParser.getTokenType(builder2)) == JavaDocTokenType.DOC_TAG_VALUE_QUOTE) {
            builder2.advanceLexer();
        }
        IElementType tokenType = BasicJavaDocParser.getTokenType(builder2);
        if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_COLON) {
            BasicJavaParserUtil.emptyElement(builder2, javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_LIST);
            BasicJavaDocParser.parseSnippetTagBody(builder2, javaDocElementTypeContainer);
        } else if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            BasicJavaDocParser.parseSnippetAttributeList(builder2, javaDocElementTypeContainer);
            if (builder2.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_COLON) {
                BasicJavaDocParser.parseSnippetTagBody(builder2, javaDocElementTypeContainer);
            }
        } else {
            BasicJavaParserUtil.emptyElement(builder2, javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_LIST);
            IElementType current = BasicJavaDocParser.getTokenType(builder2);
            while (current != null && current != JavaDocTokenType.DOC_INLINE_TAG_END) {
                builder2.advanceLexer();
                current = BasicJavaDocParser.getTokenType(builder2);
            }
        }
        snippetValue.done(javaDocElementTypeContainer.DOC_SNIPPET_TAG_VALUE);
    }

    private static void parseSnippetTagBody(@NotNull PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType tokenType;
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(10);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(11);
        }
        PsiBuilder.Marker body2 = builder2.mark();
        body2.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        assert (BasicJavaDocParser.getTokenType(builder2) == JavaDocTokenType.DOC_TAG_VALUE_COLON);
        builder2.advanceLexer();
        while ((tokenType = BasicJavaDocParser.getTokenType(builder2)) != null && tokenType != JavaDocTokenType.DOC_INLINE_TAG_END) {
            builder2.advanceLexer();
        }
        body2.done(javaDocElementTypeContainer.DOC_SNIPPET_BODY);
    }

    private static void parseSnippetAttributeList(@NotNull PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(12);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(13);
        }
        PsiBuilder.Marker attributeList = builder2.mark();
        block0: while (true) {
            IElementType type2 = BasicJavaDocParser.getTokenType(builder2);
            while (type2 != JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                if (type2 != JavaDocTokenType.DOC_TAG_VALUE_QUOTE) break block0;
                builder2.advanceLexer();
                type2 = BasicJavaDocParser.getTokenType(builder2);
            }
            BasicJavaDocParser.parseSnippetAttribute(builder2, javaDocElementTypeContainer);
        }
        attributeList.done(javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_LIST);
    }

    private static void parseSnippetAttribute(@NotNull PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(14);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(15);
        }
        PsiBuilder.Marker attribute = builder2.mark();
        assert (builder2.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
        builder2.remapCurrentToken(JavaDocTokenType.DOC_TAG_ATTRIBUTE_NAME);
        builder2.advanceLexer();
        BasicJavaDocParser.getTokenType(builder2);
        if ("=".equals(builder2.getTokenText())) {
            builder2.advanceLexer();
            IElementType afterEqToken = BasicJavaDocParser.getTokenType(builder2);
            if (afterEqToken == JavaDocTokenType.DOC_TAG_VALUE_QUOTE) {
                PsiBuilder.Marker quotedValue = builder2.mark();
                builder2.advanceLexer();
                if (BasicJavaDocParser.getTokenType(builder2) == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                    builder2.advanceLexer();
                }
                if (BasicJavaDocParser.getTokenType(builder2) == JavaDocTokenType.DOC_TAG_VALUE_QUOTE) {
                    builder2.advanceLexer();
                }
                quotedValue.collapse(javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_VALUE);
            } else if (afterEqToken == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                builder2.remapCurrentToken(javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_VALUE);
                builder2.advanceLexer();
            }
        }
        attribute.done(javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE);
    }

    private static void parseSeeTagValue(@NotNull PsiBuilder builder2, boolean allowBareFieldReference, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType tokenType;
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(16);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(17);
        }
        if ((tokenType = BasicJavaDocParser.getTokenType(builder2)) == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            BasicJavaDocParser.parseMethodRef(builder2, builder2.mark(), javaDocElementTypeContainer);
        } else if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            PsiBuilder.Marker refStart = builder2.mark();
            builder2.remapCurrentToken(javaDocElementTypeContainer.DOC_REFERENCE_HOLDER);
            builder2.advanceLexer();
            if (BasicJavaDocParser.getTokenType(builder2) == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
                BasicJavaDocParser.parseMethodRef(builder2, refStart, javaDocElementTypeContainer);
            } else if (allowBareFieldReference) {
                refStart.rollbackTo();
                builder2.remapCurrentToken(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
                BasicJavaDocParser.parseMethodRef(builder2, builder2.mark(), javaDocElementTypeContainer);
            } else {
                refStart.drop();
            }
        } else {
            PsiBuilder.Marker tagValue = builder2.mark();
            builder2.advanceLexer();
            tagValue.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
        }
    }

    private static void parseMethodRef(@NotNull PsiBuilder builder2, @NotNull PsiBuilder.Marker refStart, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(18);
        }
        if (refStart == null) {
            BasicJavaDocParser.$$$reportNull$$$0(19);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(20);
        }
        if (BasicJavaDocParser.getTokenType(builder2) == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            builder2.advanceLexer();
        }
        if (BasicJavaDocParser.getTokenType(builder2) != JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            refStart.done(javaDocElementTypeContainer.DOC_METHOD_OR_FIELD_REF);
            return;
        }
        builder2.advanceLexer();
        if (BasicJavaDocParser.getTokenType(builder2) == JavaDocTokenType.DOC_TAG_VALUE_LPAREN) {
            IElementType tokenType;
            builder2.advanceLexer();
            PsiBuilder.Marker subValue = builder2.mark();
            while (TAG_VALUES_SET.contains(tokenType = BasicJavaDocParser.getTokenType(builder2))) {
                if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                    builder2.remapCurrentToken(javaDocElementTypeContainer.DOC_TYPE_HOLDER);
                    builder2.advanceLexer();
                    while (TAG_VALUES_SET.contains(tokenType = BasicJavaDocParser.getTokenType(builder2)) && tokenType != JavaDocTokenType.DOC_TAG_VALUE_COMMA && tokenType != JavaDocTokenType.DOC_TAG_VALUE_RPAREN) {
                        builder2.advanceLexer();
                    }
                    continue;
                }
                if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_RPAREN) {
                    subValue.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
                    builder2.advanceLexer();
                    refStart.done(javaDocElementTypeContainer.DOC_METHOD_OR_FIELD_REF);
                    return;
                }
                builder2.advanceLexer();
            }
            subValue.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
        }
        refStart.done(javaDocElementTypeContainer.DOC_METHOD_OR_FIELD_REF);
    }

    private static void parseParameterRef(@NotNull PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(21);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(22);
        }
        PsiBuilder.Marker tagValue = builder2.mark();
        while (TAG_VALUES_SET.contains(BasicJavaDocParser.getTokenType(builder2))) {
            builder2.advanceLexer();
        }
        tagValue.done(javaDocElementTypeContainer.DOC_PARAMETER_REF);
    }

    private static void parseSimpleTagValue(@NotNull PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(23);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(24);
        }
        PsiBuilder.Marker tagData = builder2.mark();
        while (true) {
            IElementType tokenType;
            if ((tokenType = BasicJavaDocParser.getTokenType(builder2)) == JavaDocTokenType.DOC_COMMENT_BAD_CHARACTER) {
                builder2.remapCurrentToken(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
            } else if (!TAG_VALUES_SET.contains(tokenType)) break;
            builder2.advanceLexer();
        }
        tagData.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
    }

    @Nullable
    private static IElementType getTokenType(PsiBuilder builder2) {
        IElementType tokenType;
        while ((tokenType = builder2.getTokenType()) == JavaDocTokenType.DOC_SPACE) {
            builder2.remapCurrentToken(TokenType.WHITE_SPACE);
            builder2.advanceLexer();
        }
        return tokenType;
    }

    private static int getBraceScope(PsiBuilder builder2) {
        Integer braceScope = builder2.getUserData(BRACE_SCOPE_KEY);
        return braceScope != null ? braceScope : 0;
    }

    private static void setBraceScope(PsiBuilder builder2, int braceScope) {
        builder2.putUserData(BRACE_SCOPE_KEY, braceScope);
    }

    private static void remapAndAdvance(PsiBuilder builder2) {
        if (INLINE_TAG_BORDERS_SET.contains(builder2.getTokenType()) && BasicJavaDocParser.getBraceScope(builder2) != 1) {
            builder2.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
        }
        builder2.advanceLexer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaDocElementTypeContainer";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refStart";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/lang/java/parser/BasicJavaDocParser";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseJavadocReference";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseJavadocType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDocCommentText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "parseTag";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDataItem";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSnippetTagValue";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSnippetTagBody";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSnippetAttributeList";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSnippetAttribute";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSeeTagValue";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "parseMethodRef";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "parseParameterRef";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSimpleTagValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

