/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.github.benmanes.caffeine.cache;

import java.lang.reflect.Field;
import java.util.Iterator;
import ksp.com.github.benmanes.caffeine.cache.BaseMpscLinkedArrayQueueColdProducerFields;
import ksp.com.github.benmanes.caffeine.cache.BaseMpscLinkedArrayQueueConsumerFields;
import ksp.com.github.benmanes.caffeine.cache.BaseMpscLinkedArrayQueueProducerFields;
import ksp.com.github.benmanes.caffeine.cache.Caffeine;
import ksp.com.github.benmanes.caffeine.cache.UnsafeAccess;
import ksp.com.github.benmanes.caffeine.cache.UnsafeRefArrayAccess;

abstract class BaseMpscLinkedArrayQueue<E>
extends BaseMpscLinkedArrayQueueColdProducerFields<E> {
    private static final long P_INDEX_OFFSET;
    private static final long C_INDEX_OFFSET;
    private static final long P_LIMIT_OFFSET;
    private static final Object JUMP;

    BaseMpscLinkedArrayQueue(int initialCapacity) {
        if (initialCapacity < 2) {
            throw new IllegalArgumentException("Initial capacity must be 2 or more");
        }
        int p2capacity = Caffeine.ceilingPowerOfTwo(initialCapacity);
        long mask = (long)p2capacity - 1L << 1;
        E[] buffer = BaseMpscLinkedArrayQueue.allocate(p2capacity + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.soProducerLimit(mask);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    @Override
    public boolean offer(E e2) {
        Object[] buffer;
        long mask;
        long pIndex;
        if (null == e2) {
            throw new NullPointerException();
        }
        block6: while (true) {
            long producerLimit = this.lvProducerLimit();
            pIndex = this.lvProducerIndex();
            if ((pIndex & 1L) == 1L) continue;
            mask = this.producerMask;
            buffer = this.producerBuffer;
            if (producerLimit <= pIndex) {
                int result2 = this.offerSlowPath(mask, pIndex, producerLimit);
                switch (result2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(mask, buffer, pIndex, e2);
                        return true;
                    }
                }
            }
            if (this.casProducerIndex(pIndex, pIndex + 2L)) break;
        }
        long offset = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(pIndex, mask);
        UnsafeRefArrayAccess.soElement(buffer, offset, e2);
        return true;
    }

    private int offerSlowPath(long mask, long pIndex, long producerLimit) {
        long cIndex = this.lvConsumerIndex();
        long bufferCapacity = this.getCurrentBufferCapacity(mask);
        int result2 = 0;
        if (cIndex + bufferCapacity > pIndex) {
            if (!this.casProducerLimit(producerLimit, cIndex + bufferCapacity)) {
                result2 = 1;
            }
        } else {
            result2 = this.availableInQueue(pIndex, cIndex) <= 0L ? 2 : (this.casProducerIndex(pIndex, pIndex + 1L) ? 3 : 1);
        }
        return result2;
    }

    protected abstract long availableInQueue(long var1, long var3);

    private static long modifiedCalcElementOffset(long index2, long mask) {
        return UnsafeRefArrayAccess.REF_ARRAY_BASE + ((index2 & mask) << UnsafeRefArrayAccess.REF_ELEMENT_SHIFT - 1);
    }

    @Override
    public E poll() {
        Object[] buffer = this.consumerBuffer;
        long index2 = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(index2, mask);
        Object e2 = UnsafeRefArrayAccess.lvElement(buffer, offset);
        if (e2 == null) {
            if (index2 != this.lvProducerIndex()) {
                while ((e2 = UnsafeRefArrayAccess.lvElement(buffer, offset)) == null) {
                }
            } else {
                return null;
            }
        }
        if (e2 == JUMP) {
            Object[] nextBuffer = this.getNextBuffer(buffer, mask);
            return (E)this.newBufferPoll(nextBuffer, index2);
        }
        UnsafeRefArrayAccess.soElement(buffer, offset, null);
        this.soConsumerIndex(index2 + 2L);
        return (E)e2;
    }

    @Override
    public E peek() {
        Object[] buffer = this.consumerBuffer;
        long index2 = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(index2, mask);
        Object e2 = UnsafeRefArrayAccess.lvElement(buffer, offset);
        if (e2 == null && index2 != this.lvProducerIndex()) {
            while ((e2 = UnsafeRefArrayAccess.lvElement(buffer, offset)) == null) {
            }
        }
        if (e2 == JUMP) {
            return (E)this.newBufferPeek(this.getNextBuffer(buffer, mask), index2);
        }
        return (E)e2;
    }

    private E[] getNextBuffer(E[] buffer, long mask) {
        long nextArrayOffset = BaseMpscLinkedArrayQueue.nextArrayOffset(mask);
        Object[] nextBuffer = (Object[])UnsafeRefArrayAccess.lvElement(buffer, nextArrayOffset);
        UnsafeRefArrayAccess.soElement(buffer, nextArrayOffset, null);
        return nextBuffer;
    }

    private static long nextArrayOffset(long mask) {
        return BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(mask + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(E[] nextBuffer, long index2) {
        long offsetInNew = this.newBufferAndOffset(nextBuffer, index2);
        E n2 = UnsafeRefArrayAccess.lvElement(nextBuffer, offsetInNew);
        if (n2 == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        UnsafeRefArrayAccess.soElement(nextBuffer, offsetInNew, null);
        this.soConsumerIndex(index2 + 2L);
        return n2;
    }

    private E newBufferPeek(E[] nextBuffer, long index2) {
        long offsetInNew = this.newBufferAndOffset(nextBuffer, index2);
        E n2 = UnsafeRefArrayAccess.lvElement(nextBuffer, offsetInNew);
        if (null == n2) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return n2;
    }

    private long newBufferAndOffset(E[] nextBuffer, long index2) {
        this.consumerBuffer = nextBuffer;
        this.consumerMask = (long)nextBuffer.length - 2L << 1;
        long offsetInNew = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(index2, this.consumerMask);
        return offsetInNew;
    }

    @Override
    public final int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        long size = currentProducerIndex - after >> 1;
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public final boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }

    private long lvProducerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, P_INDEX_OFFSET);
    }

    private long lvConsumerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, C_INDEX_OFFSET);
    }

    private void soProducerIndex(long v2) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_INDEX_OFFSET, v2);
    }

    private boolean casProducerIndex(long expect, long newValue) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this, P_INDEX_OFFSET, expect, newValue);
    }

    private void soConsumerIndex(long v2) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, C_INDEX_OFFSET, v2);
    }

    private long lvProducerLimit() {
        return this.producerLimit;
    }

    private boolean casProducerLimit(long expect, long newValue) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this, P_LIMIT_OFFSET, expect, newValue);
    }

    private void soProducerLimit(long v2) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_LIMIT_OFFSET, v2);
    }

    public long currentProducerIndex() {
        return this.lvProducerIndex() / 2L;
    }

    public long currentConsumerIndex() {
        return this.lvConsumerIndex() / 2L;
    }

    public abstract int capacity();

    public boolean relaxedOffer(E e2) {
        return this.offer(e2);
    }

    public E relaxedPoll() {
        Object[] buffer = this.consumerBuffer;
        long index2 = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(index2, mask);
        Object e2 = UnsafeRefArrayAccess.lvElement(buffer, offset);
        if (e2 == null) {
            return null;
        }
        if (e2 == JUMP) {
            Object[] nextBuffer = this.getNextBuffer(buffer, mask);
            return (E)this.newBufferPoll(nextBuffer, index2);
        }
        UnsafeRefArrayAccess.soElement(buffer, offset, null);
        this.soConsumerIndex(index2 + 2L);
        return (E)e2;
    }

    public E relaxedPeek() {
        Object[] buffer = this.consumerBuffer;
        long index2 = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(index2, mask);
        Object e2 = UnsafeRefArrayAccess.lvElement(buffer, offset);
        if (e2 == JUMP) {
            return (E)this.newBufferPeek(this.getNextBuffer(buffer, mask), index2);
        }
        return (E)e2;
    }

    private void resize(long oldMask, E[] oldBuffer, long pIndex, E e2) {
        int newBufferLength = this.getNextBufferSize(oldBuffer);
        E[] newBuffer = BaseMpscLinkedArrayQueue.allocate(newBufferLength);
        this.producerBuffer = newBuffer;
        int newMask = newBufferLength - 2 << 1;
        this.producerMask = newMask;
        long offsetInOld = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(pIndex, oldMask);
        long offsetInNew = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(pIndex, newMask);
        UnsafeRefArrayAccess.soElement(newBuffer, offsetInNew, e2);
        UnsafeRefArrayAccess.soElement(oldBuffer, BaseMpscLinkedArrayQueue.nextArrayOffset(oldMask), newBuffer);
        long cIndex = this.lvConsumerIndex();
        long availableInQueue = this.availableInQueue(pIndex, cIndex);
        if (availableInQueue <= 0L) {
            throw new IllegalStateException();
        }
        this.soProducerLimit(pIndex + Math.min((long)newMask, availableInQueue));
        this.soProducerIndex(pIndex + 2L);
        UnsafeRefArrayAccess.soElement(oldBuffer, offsetInOld, JUMP);
    }

    public static <E> E[] allocate(int capacity) {
        return new Object[capacity];
    }

    protected abstract int getNextBufferSize(E[] var1);

    protected abstract long getCurrentBufferCapacity(long var1);

    static {
        Field iField;
        try {
            iField = BaseMpscLinkedArrayQueueProducerFields.class.getDeclaredField("producerIndex");
            P_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(iField);
        }
        catch (NoSuchFieldException e2) {
            throw new RuntimeException(e2);
        }
        try {
            iField = BaseMpscLinkedArrayQueueConsumerFields.class.getDeclaredField("consumerIndex");
            C_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(iField);
        }
        catch (NoSuchFieldException e3) {
            throw new RuntimeException(e3);
        }
        try {
            iField = BaseMpscLinkedArrayQueueColdProducerFields.class.getDeclaredField("producerLimit");
            P_LIMIT_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(iField);
        }
        catch (NoSuchFieldException e4) {
            throw new RuntimeException(e4);
        }
        JUMP = new Object();
    }
}

