/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.text;

import ksp.com.intellij.openapi.util.text.CharFilter;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypes;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class LiteralFormatUtil {
    private static final CharFilter UNDERSCORES_FILTER = ch -> ch != '_';

    private LiteralFormatUtil() {
    }

    @NotNull
    public static String removeUnderscores(@NotNull String text) {
        if (text == null) {
            LiteralFormatUtil.$$$reportNull$$$0(0);
        }
        String string2 = StringUtil.strip(text, UNDERSCORES_FILTER);
        if (string2 == null) {
            LiteralFormatUtil.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public static String format(@NotNull String original, @Nullable PsiType type2) {
        if (original == null) {
            LiteralFormatUtil.$$$reportNull$$$0(2);
        }
        boolean isFP = PsiTypes.floatType().equals(type2) || PsiTypes.doubleType().equals(type2);
        String text = original;
        String prefix = "";
        String suffix = "";
        int groupSize = 3;
        if (text.startsWith("0x") || text.startsWith("0X") || text.startsWith("0b") || text.startsWith("0B")) {
            prefix = text.substring(0, 2);
            text = text.substring(2);
            groupSize = 4;
        }
        if (text.length() == 0) {
            String string2 = original;
            if (string2 == null) {
                LiteralFormatUtil.$$$reportNull$$$0(3);
            }
            return string2;
        }
        char last = text.charAt(text.length() - 1);
        if (StringUtil.containsChar("Ll", last) || isFP && StringUtil.containsChar("FfDd", last)) {
            int pos = text.length() - 1;
            suffix = text.substring(pos);
            text = text.substring(0, pos);
        }
        if (text.length() == 0) {
            String string3 = original;
            if (string3 == null) {
                LiteralFormatUtil.$$$reportNull$$$0(4);
            }
            return string3;
        }
        boolean hasPoint = false;
        String fractional = "";
        String exponentMark = "";
        String exponent = "";
        if (isFP) {
            int pos = StringUtil.indexOfAny(text, "0x".equals(prefix) || "0X".equals(prefix) ? "Pp" : "Ee");
            if (pos >= 0) {
                int pos2 = Math.max(StringUtil.indexOfAny(text, "+-", pos, text.length()), pos) + 1;
                exponentMark = text.substring(pos, pos2);
                exponent = text.substring(pos2);
                text = text.substring(0, pos);
            }
            if ((pos = text.indexOf(46)) >= 0) {
                hasPoint = true;
                fractional = text.substring(pos + 1);
                text = text.substring(0, pos);
            }
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(prefix);
        LiteralFormatUtil.appendFromEnd(buffer, text, groupSize);
        if (isFP) {
            if (hasPoint) {
                buffer.append('.');
            }
            LiteralFormatUtil.appendFromStart(buffer, fractional, groupSize);
            buffer.append(exponentMark);
            LiteralFormatUtil.appendFromEnd(buffer, exponent, 3);
        }
        buffer.append(suffix);
        String string4 = buffer.toString();
        if (string4 == null) {
            LiteralFormatUtil.$$$reportNull$$$0(5);
        }
        return string4;
    }

    private static void appendFromEnd(StringBuilder buffer, String original, int groupSize) {
        int pointer;
        int position = buffer.length();
        for (pointer = original.length(); pointer > groupSize; pointer -= groupSize) {
            buffer.insert(position, original.substring(pointer - groupSize, pointer));
            buffer.insert(position, '_');
        }
        if (pointer > 0) {
            buffer.insert(position, original.substring(0, pointer));
        }
    }

    private static void appendFromStart(StringBuilder buffer, String original, int groupSize) {
        int pointer = 0;
        while (pointer + groupSize < original.length()) {
            buffer.append(original, pointer, pointer + groupSize);
            buffer.append('_');
            pointer += groupSize;
        }
        if (pointer < original.length()) {
            buffer.append(original.substring(pointer));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/text/LiteralFormatUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/text/LiteralFormatUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "removeUnderscores";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeUnderscores";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

