/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.util;

import java.util.function.Supplier;
import ksp.com.intellij.openapi.util.AtomicNotNullLazyValue;
import ksp.com.intellij.openapi.util.NotNullFactory;
import ksp.com.intellij.openapi.util.RecursionGuard;
import ksp.com.intellij.openapi.util.RecursionManager;
import ksp.com.intellij.reference.SoftReference;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public abstract class NotNullLazyValue<T>
implements Supplier<T> {
    private T myValue;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    protected NotNullLazyValue() {
    }

    @NotNull
    protected abstract T compute();

    @Override
    public final T get() {
        return this.getValue();
    }

    @NotNull
    public T getValue() {
        T result2 = this.myValue;
        if (result2 == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            result2 = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = result2;
            }
        }
        T t2 = result2;
        if (t2 == null) {
            NotNullLazyValue.$$$reportNull$$$0(0);
        }
        return t2;
    }

    public boolean isComputed() {
        return this.myValue != null;
    }

    @NotNull
    public static <T> NotNullLazyValue<T> createConstantValue(@NotNull T value2) {
        if (value2 == null) {
            NotNullLazyValue.$$$reportNull$$$0(1);
        }
        return NotNullLazyValue.lazy(() -> value2);
    }

    @NotNull
    public static <T> NotNullLazyValue<T> createValue(@NotNull NotNullFactory<? extends T> value2) {
        if (value2 == null) {
            NotNullLazyValue.$$$reportNull$$$0(2);
        }
        return NotNullLazyValue.lazy(value2::create);
    }

    @NotNull
    public static <T> NotNullLazyValue<T> lazy(final @NotNull Supplier<? extends T> value2) {
        if (value2 == null) {
            NotNullLazyValue.$$$reportNull$$$0(3);
        }
        return new NotNullLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                Object t2 = value2.get();
                if (t2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return t2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ksp/com/intellij/openapi/util/NotNullLazyValue$1", "compute"));
            }
        };
    }

    @NotNull
    public static <T> NotNullLazyValue<T> atomicLazy(final @NotNull @NotNull Supplier<? extends @NotNull T> value2) {
        if (value2 == null) {
            NotNullLazyValue.$$$reportNull$$$0(4);
        }
        return new AtomicNotNullLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                Object t2 = value2.get();
                if (t2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return t2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ksp/com/intellij/openapi/util/NotNullLazyValue$2", "compute"));
            }
        };
    }

    public static <T> Supplier<T> softLazy(final Supplier<? extends T> supplier) {
        return new Supplier<T>(){
            private java.lang.ref.SoftReference<T> ref;

            @Override
            public T get() {
                Object value2 = SoftReference.dereference(this.ref);
                if (value2 == null) {
                    value2 = supplier.get();
                    this.ref = new java.lang.ref.SoftReference(value2);
                }
                return value2;
            }
        };
    }

    @NotNull
    public static <T> NotNullLazyValue<T> volatileLazy(final @NotNull @NotNull Supplier<? extends @NotNull T> supplier) {
        if (supplier == null) {
            NotNullLazyValue.$$$reportNull$$$0(5);
        }
        return new NotNullLazyValue<T>(){
            private volatile T value;

            @Override
            @NotNull
            public T getValue() {
                Object value2 = this.value;
                if (value2 == null) {
                    RecursionGuard.StackStamp stamp = RecursionManager.markStack();
                    value2 = this.compute();
                    if (stamp.mayCacheNow()) {
                        this.value = value2;
                    }
                }
                Object t2 = value2;
                if (t2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                return t2;
            }

            @Override
            public boolean isComputed() {
                return this.value != null;
            }

            @Override
            @NotNull
            protected T compute() {
                Object t2 = supplier.get();
                if (t2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                return t2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "ksp/com/intellij/openapi/util/NotNullLazyValue$4";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "compute";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/util/NotNullLazyValue";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/util/NotNullLazyValue";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createConstantValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lazy";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "atomicLazy";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "volatileLazy";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

