/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.java.stubs.impl;

import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiImportStatementBase;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.PsiJavaParserFacade;
import ksp.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import ksp.com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import ksp.com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import ksp.com.intellij.psi.stubs.StubBase;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.reference.SoftReference;
import ksp.com.intellij.util.BitUtil;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.org.jetbrains.annotations.Nullable;

public class PsiImportStatementStubImpl
extends StubBase<PsiImportStatementBase>
implements PsiImportStatementStub {
    private final byte myFlags;
    private final String myText;
    private java.lang.ref.SoftReference<PsiJavaCodeReferenceElement> myReference;
    private static final int ON_DEMAND = 1;
    private static final int STATIC = 2;

    public PsiImportStatementStubImpl(StubElement parent2, String text, byte flags) {
        super(parent2, PsiImportStatementStubImpl.isStatic(flags) ? JavaStubElementTypes.IMPORT_STATIC_STATEMENT : JavaStubElementTypes.IMPORT_STATEMENT);
        this.myText = text;
        this.myFlags = flags;
    }

    @Override
    public boolean isStatic() {
        return PsiImportStatementStubImpl.isStatic(this.myFlags);
    }

    private static boolean isStatic(byte flags) {
        return BitUtil.isSet((int)flags, 2);
    }

    @Override
    public boolean isOnDemand() {
        return BitUtil.isSet((int)this.myFlags, 1);
    }

    public byte getFlags() {
        return this.myFlags;
    }

    @Override
    public String getImportReferenceText() {
        return this.myText;
    }

    @Override
    @Nullable
    public PsiJavaCodeReferenceElement getReference() {
        PsiJavaCodeReferenceElement ref = SoftReference.dereference(this.myReference);
        if (ref == null) {
            ref = this.isStatic() ? this.getStaticReference() : this.getRegularReference();
            this.myReference = new java.lang.ref.SoftReference<PsiJavaCodeReferenceElement>(ref);
        }
        return ref;
    }

    public static byte packFlags(boolean isOnDemand, boolean isStatic) {
        byte flags = 0;
        if (isOnDemand) {
            flags = (byte)(flags | 1);
        }
        if (isStatic) {
            flags = (byte)(flags | 2);
        }
        return flags;
    }

    @Nullable
    private PsiJavaCodeReferenceElement getStaticReference() {
        PsiJavaCodeReferenceElement refElement = this.createReference();
        if (refElement == null) {
            return null;
        }
        if (this.isOnDemand() && refElement instanceof PsiJavaCodeReferenceElementImpl) {
            ((PsiJavaCodeReferenceElementImpl)refElement).setKindWhenDummy(PsiJavaCodeReferenceElementImpl.Kind.CLASS_FQ_NAME_KIND);
        }
        return refElement;
    }

    @Nullable
    private PsiJavaCodeReferenceElement getRegularReference() {
        PsiJavaCodeReferenceElement refElement = this.createReference();
        if (refElement == null) {
            return null;
        }
        ((PsiJavaCodeReferenceElementImpl)refElement).setKindWhenDummy(this.isOnDemand() ? PsiJavaCodeReferenceElementImpl.Kind.CLASS_FQ_OR_PACKAGE_NAME_KIND : PsiJavaCodeReferenceElementImpl.Kind.CLASS_FQ_NAME_KIND);
        return refElement;
    }

    @Nullable
    private PsiJavaCodeReferenceElement createReference() {
        String refText = this.getImportReferenceText();
        if (refText == null) {
            return null;
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
        try {
            return parserFacade.createReferenceFromText(refText, (PsiElement)this.getPsi());
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("PsiImportStatementStub[");
        if (this.isStatic()) {
            builder2.append("static ");
        }
        builder2.append(this.getImportReferenceText());
        if (this.isOnDemand()) {
            builder2.append(".*");
        }
        builder2.append("]");
        return builder2.toString();
    }
}

