/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.ref;

import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.function.Predicate;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.openapi.util.UserDataHolderEx;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.util.PairProcessor;
import ksp.com.intellij.util.ReflectionUtil;
import ksp.com.intellij.util.containers.CollectionFactory;
import ksp.com.intellij.util.containers.FList;
import ksp.com.intellij.util.containers.HashingStrategy;
import ksp.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class DebugReflectionUtil {
    private static final Map<Class<?>, Field[]> allFields;
    private static final Field[] EMPTY_FIELD_ARRAY;
    private static final Method Unsafe_shouldBeInitialized;
    private static final Key<Boolean> REPORTED_LEAKED;

    private static Field @NotNull [] getAllFields(@NotNull Class<?> aClass) {
        Field[] cached;
        if (aClass == null) {
            DebugReflectionUtil.$$$reportNull$$$0(0);
        }
        if ((cached = allFields.get(aClass)) == null) {
            try {
                Field[] declaredFields = aClass.getDeclaredFields();
                ArrayList<Field> fields = new ArrayList<Field>(declaredFields.length + 5);
                for (Field declaredField : declaredFields) {
                    declaredField.setAccessible(true);
                    Class<?> type2 = declaredField.getType();
                    if (DebugReflectionUtil.isTrivial(type2)) continue;
                    fields.add(declaredField);
                }
                Class<?> superclass = aClass.getSuperclass();
                if (superclass != null) {
                    for (Field sup : DebugReflectionUtil.getAllFields(superclass)) {
                        if (fields.contains(sup)) continue;
                        fields.add(sup);
                    }
                }
                cached = fields.isEmpty() ? EMPTY_FIELD_ARRAY : fields.toArray(new Field[0]);
            }
            catch (IncompatibleClassChangeError | NoClassDefFoundError | SecurityException e2) {
                cached = EMPTY_FIELD_ARRAY;
            }
            catch (RuntimeException e3) {
                if (e3.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
                    cached = EMPTY_FIELD_ARRAY;
                }
                throw e3;
            }
            allFields.put(aClass, cached);
        }
        if (cached == null) {
            DebugReflectionUtil.$$$reportNull$$$0(1);
        }
        return cached;
    }

    private static boolean isTrivial(@NotNull Class<?> type2) {
        if (type2 == null) {
            DebugReflectionUtil.$$$reportNull$$$0(2);
        }
        return type2.isPrimitive() || type2 == String.class || type2 == Class.class || type2.isArray() && DebugReflectionUtil.isTrivial(type2.getComponentType());
    }

    private static boolean isInitialized(@NotNull Class<?> root) {
        if (root == null) {
            DebugReflectionUtil.$$$reportNull$$$0(3);
        }
        if (Unsafe_shouldBeInitialized == null) {
            return false;
        }
        boolean isInitialized = false;
        try {
            isInitialized = (Boolean)Unsafe_shouldBeInitialized.invoke(ReflectionUtil.getUnsafe(), root) == false;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return isInitialized;
    }

    public static <V> boolean walkObjects(int maxDepth, @NotNull Map<Object, String> startRoots, @NotNull Class<V> lookFor, @NotNull Predicate<Object> shouldExamineValue, @NotNull PairProcessor<? super V, ? super BackLink<?>> leakProcessor) {
        if (startRoots == null) {
            DebugReflectionUtil.$$$reportNull$$$0(4);
        }
        if (lookFor == null) {
            DebugReflectionUtil.$$$reportNull$$$0(5);
        }
        if (shouldExamineValue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(6);
        }
        if (leakProcessor == null) {
            DebugReflectionUtil.$$$reportNull$$$0(7);
        }
        IntOpenHashSet visited2 = new IntOpenHashSet(100);
        ArrayDeque<2> toVisit = new ArrayDeque<2>(100);
        for (Map.Entry<Object, String> entry : startRoots.entrySet()) {
            Object startRoot = entry.getKey();
            final String description = entry.getValue();
            toVisit.addLast(new BackLink<Object>(startRoot, null, "(root)", null){

                @Override
                void print(@NotNull StringBuilder result2) {
                    if (result2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    super.print(result2);
                    result2.append(" (from ").append(description).append(")");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "ksp/com/intellij/util/ref/DebugReflectionUtil$2", "print"));
                }
            });
        }
        BackLink backLink;
        while ((backLink = (BackLink)toVisit.pollFirst()) != null) {
            if (backLink.depth > maxDepth) continue;
            Object value2 = backLink.value;
            if (lookFor.isAssignableFrom(value2.getClass()) && DebugReflectionUtil.markLeaked(value2) && !leakProcessor.process(value2, backLink)) {
                return false;
            }
            if (!visited2.add(System.identityHashCode(value2))) continue;
            DebugReflectionUtil.queueStronglyReferencedValues(toVisit, value2, backLink, shouldExamineValue);
        }
        return true;
    }

    private static void queueStronglyReferencedValues(@NotNull Deque<? super BackLink<?>> queue, @NotNull Object root, @NotNull BackLink<?> backLink, @NotNull Predicate<Object> shouldExamineValue) {
        if (queue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(8);
        }
        if (root == null) {
            DebugReflectionUtil.$$$reportNull$$$0(9);
        }
        if (backLink == null) {
            DebugReflectionUtil.$$$reportNull$$$0(10);
        }
        if (shouldExamineValue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(11);
        }
        Class<?> rootClass = root.getClass();
        for (Field field : DebugReflectionUtil.getAllFields(rootClass)) {
            Object value2;
            String fieldName = field.getName();
            if (root instanceof Reference && ("referent".equals(fieldName) || "discovered".equals(fieldName))) continue;
            try {
                value2 = field.get(root);
            }
            catch (IllegalAccessException | IllegalArgumentException e2) {
                throw new RuntimeException(e2);
            }
            DebugReflectionUtil.queue(value2, field, null, backLink, queue, shouldExamineValue);
        }
        if (rootClass.isArray()) {
            try {
                Object[] objects = (Object[])root;
                for (int i2 = 0; i2 < objects.length; ++i2) {
                    Object value3 = objects[i2];
                    DebugReflectionUtil.queue(value3, null, "[" + i2 + "]", backLink, queue, shouldExamineValue);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (root instanceof Class && DebugReflectionUtil.isInitialized((Class)root)) {
            for (Field field : DebugReflectionUtil.getAllFields((Class)root)) {
                if ((field.getModifiers() & 8) == 0) continue;
                try {
                    Object value4 = field.get(null);
                    DebugReflectionUtil.queue(value4, field, null, backLink, queue, shouldExamineValue);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    private static void queue(@Nullable Object value2, @Nullable Field field, @Nullable String fieldName, @NotNull BackLink<?> backLink, @NotNull Deque<? super BackLink<?>> queue, @NotNull Predicate<Object> shouldExamineValue) {
        if (backLink == null) {
            DebugReflectionUtil.$$$reportNull$$$0(12);
        }
        if (queue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(13);
        }
        if (shouldExamineValue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(14);
        }
        if (value2 == null || DebugReflectionUtil.isTrivial(value2.getClass())) {
            return;
        }
        if (shouldExamineValue.test(value2)) {
            queue.addLast(new BackLink<Object>(value2, field, fieldName, backLink));
        }
    }

    private static boolean markLeaked(Object leaked) {
        return !(leaked instanceof UserDataHolderEx) || ((UserDataHolderEx)leaked).replace(REPORTED_LEAKED, null, Boolean.TRUE);
    }

    static {
        Method shouldBeInitialized;
        allFields = Collections.synchronizedMap(CollectionFactory.createCustomHashingStrategyMap(new HashingStrategy<Class<?>>(){

            @Override
            public int hashCode(@Nullable Class<?> aClass) {
                return aClass == null ? 0 : aClass.getName().hashCode();
            }

            @Override
            public boolean equals(@Nullable Class<?> o1, @Nullable Class<?> o2) {
                return o1 == o2;
            }
        }));
        EMPTY_FIELD_ARRAY = new Field[0];
        try {
            shouldBeInitialized = ReflectionUtil.getDeclaredMethod(Class.forName("sun.misc.Unsafe"), "shouldBeInitialized", Class.class);
        }
        catch (ClassNotFoundException ignored) {
            shouldBeInitialized = null;
        }
        Unsafe_shouldBeInitialized = shouldBeInitialized;
        REPORTED_LEAKED = Key.create("REPORTED_LEAKED");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/ref/DebugReflectionUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRoots";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookFor";
                break;
            }
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldExamineValue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leakProcessor";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backLink";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/ref/DebugReflectionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllFields";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTrivial";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInitialized";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "walkObjects";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "queueStronglyReferencedValues";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "queue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class BackLink<V> {
        @NotNull
        private final V value;
        private final Field field;
        private final String fieldName;
        private final BackLink<?> backLink;
        private final int depth;

        BackLink(@NotNull V value2, @Nullable Field field, @Nullable String fieldName, @Nullable BackLink<?> backLink) {
            if (value2 == null) {
                BackLink.$$$reportNull$$$0(0);
            }
            this.value = value2;
            this.field = field;
            this.fieldName = fieldName;
            assert (field != null ^ fieldName != null) : "One of field/fieldName must be null and the other not-null, but got: " + field + "/" + fieldName;
            this.backLink = backLink;
            this.depth = backLink == null ? 0 : backLink.depth + 1;
        }

        public String toString() {
            StringBuilder result2 = new StringBuilder();
            BackLink<?> backLink = this;
            while (backLink != null) {
                backLink.print(result2);
                backLink = backLink.backLink;
            }
            return result2.toString();
        }

        void print(@NotNull StringBuilder result2) {
            String valueStr;
            if (result2 == null) {
                BackLink.$$$reportNull$$$0(1);
            }
            V value2 = this.value;
            try {
                valueStr = value2 instanceof FList ? "FList (size=" + ((FList)value2).size() + ")" : (value2 instanceof Collection ? "Collection (size=" + ((Collection)value2).size() + ")" : (value2 instanceof Object[] ? Arrays.toString((Object[])value2) : String.valueOf(value2)));
                valueStr = StringUtil.first(StringUtil.convertLineSeparators(valueStr, "\\n"), 200, true);
            }
            catch (Throwable e2) {
                valueStr = "(" + e2.getMessage() + " while computing .toString())";
            }
            Field field = this.field;
            String fieldName = this.fieldName != null ? this.fieldName : field.getDeclaringClass().getName() + "." + field.getName();
            result2.append("via '").append(fieldName).append("'; Value: '").append(valueStr).append("' of ").append(value2.getClass()).append("\n");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "ksp/com/intellij/util/ref/DebugReflectionUtil$BackLink";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

