/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class PosixFilePermissionsUtil {
    private static final int S_IRUSR = 256;
    private static final int S_IWUSR = 128;
    private static final int S_IXUSR = 64;
    private static final int S_IRGRP = 32;
    private static final int S_IWGRP = 16;
    private static final int S_IXGRP = 8;
    private static final int S_IROTH = 4;
    private static final int S_IWOTH = 2;
    private static final int S_IXOTH = 1;

    private PosixFilePermissionsUtil() {
    }

    @NotNull
    public static Set<PosixFilePermission> fromUnixMode(int mode) {
        EnumSet<PosixFilePermission> permissions = EnumSet.noneOf(PosixFilePermission.class);
        if ((mode & 0x100) != 0) {
            permissions.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) != 0) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) != 0) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) != 0) {
            permissions.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) != 0) {
            permissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) != 0) {
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) != 0) {
            permissions.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) != 0) {
            permissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) != 0) {
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        EnumSet<PosixFilePermission> enumSet = permissions;
        if (enumSet == null) {
            PosixFilePermissionsUtil.$$$reportNull$$$0(0);
        }
        return enumSet;
    }

    public static int toUnixMode(@NotNull Set<PosixFilePermission> permissions) {
        if (permissions == null) {
            PosixFilePermissionsUtil.$$$reportNull$$$0(1);
        }
        int mode = 0;
        if (permissions.contains((Object)PosixFilePermission.OWNER_READ)) {
            mode |= 0x100;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            mode |= 0x80;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            mode |= 0x40;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_READ)) {
            mode |= 0x20;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            mode |= 0x10;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            mode |= 8;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_READ)) {
            mode |= 4;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            mode |= 2;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            mode |= 1;
        }
        return mode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/io/PosixFilePermissionsUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permissions";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fromUnixMode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/io/PosixFilePermissionsUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toUnixMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

