/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util;

import java.util.List;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.progress.ProcessCanceledException;
import ksp.com.intellij.openapi.progress.ProgressManager;
import ksp.com.intellij.openapi.project.IndexNotReadyException;
import ksp.com.intellij.util.AbstractQuery;
import ksp.com.intellij.util.Processor;
import ksp.com.intellij.util.Query;
import ksp.com.intellij.util.QueryExecutor;
import ksp.com.intellij.util.QueryWrapper;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;

public final class ExecutorsQuery<Result, Parameter>
extends AbstractQuery<Result> {
    private static final Logger LOG = Logger.getInstance(ExecutorsQuery.class);
    private final List<? extends QueryExecutor<Result, Parameter>> myExecutors;
    private final Parameter myParameters;

    public ExecutorsQuery(@NotNull Parameter params, @NotNull List<? extends QueryExecutor<Result, Parameter>> executors) {
        if (params == null) {
            ExecutorsQuery.$$$reportNull$$$0(0);
        }
        if (executors == null) {
            ExecutorsQuery.$$$reportNull$$$0(1);
        }
        this.myParameters = params;
        this.myExecutors = executors;
    }

    @Override
    protected boolean processResults(@NotNull Processor<? super Result> consumer2) {
        if (consumer2 == null) {
            ExecutorsQuery.$$$reportNull$$$0(2);
        }
        for (QueryExecutor<? super Result, Parameter> queryExecutor : this.myExecutors) {
            try {
                ProgressManager.checkCanceled();
                if (queryExecutor.execute(this.myParameters, consumer2)) continue;
                return false;
            }
            catch (ProcessCanceledException | IndexNotReadyException e2) {
                throw e2;
            }
            catch (Exception e3) {
                LOG.error(e3);
            }
        }
        return true;
    }

    @Override
    @ApiStatus.Experimental
    @NotNull
    public Query<Result> wrap(@NotNull QueryWrapper<Result> wrapper) {
        if (wrapper == null) {
            ExecutorsQuery.$$$reportNull$$$0(3);
        }
        return new ExecutorsQuery<Result, Parameter>(this.myParameters, ContainerUtil.map(this.myExecutors, e2 -> e2.wrap(wrapper)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/util/ExecutorsQuery";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processResults";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "wrap";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

