/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.Call;
import ksp.org.jetbrains.kotlin.psi.KtCodeFragment;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.inline.InlineUtil;
import ksp.org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import ksp.org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CoroutineSuspendCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
@SourceDebugExtension(value={"SMAP\ncoroutineCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 coroutineCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/CoroutineSuspendCallChecker\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,199:1\n196#2:200\n1255#3,2:201\n*S KotlinDebug\n*F\n+ 1 coroutineCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/CoroutineSuspendCallChecker\n*L\n76#1:200\n85#1:201,2\n*E\n"})
public final class CoroutineSuspendCallChecker
implements CallChecker {
    @NotNull
    public static final CoroutineSuspendCallChecker INSTANCE = new CoroutineSuspendCallChecker();

    private CoroutineSuspendCallChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Object descriptor2;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object obj = resolvedCall2.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"getCandidateDescriptor(...)");
        Object obj2 = descriptor2 = obj;
        if (obj2 instanceof FunctionDescriptor) {
            if (!((FunctionDescriptor)descriptor2).isSuspend()) {
                return;
            }
        } else if (obj2 instanceof PropertyDescriptor) {
            if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)descriptor2), (Object)CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_FQ_NAME())) {
                return;
            }
        } else {
            return;
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNull((Object)ktElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        KtExpression callElement = (KtExpression)ktElement;
        FunctionDescriptor enclosingSuspendFunction = CoroutineCallCheckerKt.findEnclosingSuspendFunction(context2);
        if (enclosingSuspendFunction != null) {
            if (!InlineUtil.checkNonLocalReturnUsage(enclosingSuspendFunction, callElement, context2.getResolutionContext())) {
                boolean shouldReport = true;
                PsiFile containingFile2 = callElement.getContainingFile();
                if (containingFile2 instanceof KtCodeFragment) {
                    KtExpression c2;
                    KtExpression ktExpression;
                    PsiElement psiElement = ((KtCodeFragment)containingFile2).getContext();
                    if (psiElement != null) {
                        void $this$getParentOfType$iv;
                        PsiElement psiElement2 = psiElement;
                        boolean strict$iv = false;
                        boolean $i$f$getParentOfType = false;
                        ktExpression = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtExpression.class, strict$iv);
                    } else {
                        ktExpression = c2 = null;
                    }
                    if (c2 != null && InlineUtil.checkNonLocalReturnUsage(enclosingSuspendFunction, c2, context2.getResolutionContext())) {
                        shouldReport = false;
                    }
                }
                if (shouldReport) {
                    context2.getTrace().report(Errors.NON_LOCAL_SUSPENSION_POINT.on(reportOn));
                }
            } else {
                boolean bl2;
                block21: {
                    Sequence<HierarchicalScope> $this$any$iv = ScopeUtilsKt.getParentsWithSelf(context2.getScope());
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        HierarchicalScope it = (HierarchicalScope)element$iv;
                        boolean bl3 = false;
                        if (!CoroutineCallCheckerKt.access$isScopeForDefaultParameterValuesOf(it, enclosingSuspendFunction)) continue;
                        bl2 = true;
                        break block21;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    context2.getTrace().report(Errors.UNSUPPORTED.on(reportOn, "suspend function calls in a context of default parameter value"));
                }
            }
            CoroutineCallCheckerKt.access$checkRestrictsSuspension(enclosingSuspendFunction, resolvedCall2, reportOn, context2);
        } else {
            Call call2 = resolvedCall2.getCall();
            Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"getCall(...)");
            if (!CallUtilKt.isCallableReference(call2)) {
                CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)descriptor2;
                if (callableMemberDescriptor instanceof FunctionDescriptor) {
                    context2.getTrace().report(Errors.ILLEGAL_SUSPEND_FUNCTION_CALL.on(reportOn, (CallableDescriptor)resolvedCall2.getCandidateDescriptor()));
                } else if (callableMemberDescriptor instanceof PropertyDescriptor) {
                    context2.getTrace().report(Errors.ILLEGAL_SUSPEND_PROPERTY_ACCESS.on(reportOn, (CallableDescriptor)resolvedCall2.getCandidateDescriptor()));
                }
            }
        }
    }
}

