/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import ksp.org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOptInMarkedDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirOptInMarkedDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirOptInMarkedDeclarationChecker INSTANCE = new FirOptInMarkedDeclarationChecker();

    private FirOptInMarkedDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirAnnotation annotation : declaration2.getAnnotations()) {
            FirRegularClassSymbol annotationClass;
            if (FirAnnotationHelpersKt.getAnnotationClassForOptInMarker(annotation, context2.getSession()) == null) continue;
            AnnotationUseSiteTarget useSiteTarget2 = annotation.getUseSiteTarget();
            if (declaration2 instanceof FirPropertyAccessor && ((FirPropertyAccessor)declaration2).isGetter() || useSiteTarget2 == AnnotationUseSiteTarget.PROPERTY_GETTER) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getOPT_IN_MARKER_ON_WRONG_TARGET(), (Object)"getter", (DiagnosticContext)context2, null, 16, null);
            }
            if (useSiteTarget2 == AnnotationUseSiteTarget.SETTER_PARAMETER || useSiteTarget2 != AnnotationUseSiteTarget.PROPERTY && useSiteTarget2 != AnnotationUseSiteTarget.PROPERTY_SETTER && declaration2 instanceof FirValueParameter && FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotationClass, context2.getSession()).contains((Object)KotlinTarget.VALUE_PARAMETER)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getOPT_IN_MARKER_ON_WRONG_TARGET(), (Object)"parameter", (DiagnosticContext)context2, null, 16, null);
            }
            if (declaration2 instanceof FirProperty && ((FirProperty)declaration2).isLocal()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getOPT_IN_MARKER_ON_WRONG_TARGET(), (Object)"variable", (DiagnosticContext)context2, null, 16, null);
            }
            if (useSiteTarget2 != AnnotationUseSiteTarget.FIELD && useSiteTarget2 != AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getOPT_IN_MARKER_ON_WRONG_TARGET(), (Object)"field", (DiagnosticContext)context2, null, 16, null);
        }
        if (!(declaration2 instanceof FirCallableDeclaration)) {
            return;
        }
        FirReceiverParameter firReceiverParameter = ((FirCallableDeclaration)declaration2).getReceiverParameter();
        if (firReceiverParameter == null) {
            return;
        }
        FirReceiverParameter receiver = firReceiverParameter;
        for (FirAnnotation annotation : receiver.getAnnotations()) {
            if (FirAnnotationHelpersKt.getAnnotationClassForOptInMarker(annotation, context2.getSession()) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getOPT_IN_MARKER_ON_WRONG_TARGET(), (Object)"parameter", (DiagnosticContext)context2, null, 16, null);
        }
    }
}

