/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.diagnostics;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.config.AnalysisFlags;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.config.WarningLevel;
import ksp.org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticRenderer;
import ksp.org.jetbrains.kotlin.diagnostics.Severity;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B-\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\b\u0010\u001b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u0082\u0001\u0005\u001c\u001d\u001e\u001f \u00a8\u0006!"}, d2={"Lksp/org/jetbrains/kotlin/diagnostics/AbstractKtDiagnosticFactory;", "", "name", "", "severity", "Lksp/org/jetbrains/kotlin/diagnostics/Severity;", "defaultPositioningStrategy", "Lksp/org/jetbrains/kotlin/diagnostics/AbstractSourceElementPositioningStrategy;", "psiType", "Lkotlin/reflect/KClass;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;Lorg/jetbrains/kotlin/diagnostics/AbstractSourceElementPositioningStrategy;Lkotlin/reflect/KClass;)V", "getName", "()Ljava/lang/String;", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "getDefaultPositioningStrategy", "()Lorg/jetbrains/kotlin/diagnostics/AbstractSourceElementPositioningStrategy;", "getPsiType", "()Lkotlin/reflect/KClass;", "ktRenderer", "Lksp/org/jetbrains/kotlin/diagnostics/KtDiagnosticRenderer;", "getKtRenderer", "()Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticRenderer;", "getEffectiveSeverity", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "toString", "Lksp/org/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "Lksp/org/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;", "Lksp/org/jetbrains/kotlin/diagnostics/KtDiagnosticFactory2;", "Lksp/org/jetbrains/kotlin/diagnostics/KtDiagnosticFactory3;", "Lksp/org/jetbrains/kotlin/diagnostics/KtDiagnosticFactory4;", "frontend.common"})
public abstract class AbstractKtDiagnosticFactory {
    @NotNull
    private final String name;
    @NotNull
    private final Severity severity;
    @NotNull
    private final AbstractSourceElementPositioningStrategy defaultPositioningStrategy;
    @NotNull
    private final KClass<?> psiType;

    private AbstractKtDiagnosticFactory(String name2, Severity severity, AbstractSourceElementPositioningStrategy defaultPositioningStrategy, KClass<?> psiType) {
        this.name = name2;
        this.severity = severity;
        this.defaultPositioningStrategy = defaultPositioningStrategy;
        this.psiType = psiType;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Severity getSeverity() {
        return this.severity;
    }

    @NotNull
    public final AbstractSourceElementPositioningStrategy getDefaultPositioningStrategy() {
        return this.defaultPositioningStrategy;
    }

    @NotNull
    public final KClass<?> getPsiType() {
        return this.psiType;
    }

    @NotNull
    public abstract KtDiagnosticRenderer getKtRenderer();

    @Nullable
    protected final Severity getEffectiveSeverity(@NotNull LanguageVersionSettings languageVersionSettings) {
        Severity severity;
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        WarningLevel warningLevel = languageVersionSettings.getFlag(AnalysisFlags.INSTANCE.getWarningLevels()).get(this.name);
        switch (warningLevel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[warningLevel.ordinal()]) {
            case 1: {
                severity = Severity.ERROR;
                break;
            }
            case 2: {
                severity = Severity.FIXED_WARNING;
                break;
            }
            case 3: {
                severity = null;
                break;
            }
            case -1: {
                severity = this.severity;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return severity;
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    public /* synthetic */ AbstractKtDiagnosticFactory(String name2, Severity severity, AbstractSourceElementPositioningStrategy defaultPositioningStrategy, KClass psiType, DefaultConstructorMarker $constructor_marker) {
        this(name2, severity, defaultPositioningStrategy, psiType);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WarningLevel.values().length];
            try {
                nArray[WarningLevel.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WarningLevel.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WarningLevel.Disabled.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

