/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.wasm.resolve.diagnostics;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.MemberDescriptor;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.wasm.resolve.diagnostics.ErrorsWasm;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/wasm/resolve/diagnostics/WasmExternalInheritanceChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "wasm.frontend"})
public final class WasmExternalInheritanceChecker
implements DeclarationChecker {
    @NotNull
    public static final WasmExternalInheritanceChecker INSTANCE = new WasmExternalInheritanceChecker();

    private WasmExternalInheritanceChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (descriptor2 instanceof ClassDescriptor && !DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2)) {
            List superClasses = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)descriptor2)), (Iterable)DescriptorUtilsKt.getSuperInterfaces((ClassDescriptor)descriptor2));
            for (ClassDescriptor superClass : superClasses) {
                if (!DescriptorUtilsKt.isEffectivelyExternal(superClass)) continue;
                context2.getTrace().report(ErrorsWasm.NON_EXTERNAL_TYPE_EXTENDS_EXTERNAL_TYPE.on((KtElement)((PsiElement)((KtClassOrObject)declaration2)), superClass.getDefaultType()));
            }
        }
    }
}

