/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.resolve.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import ksp.org.jetbrains.kotlin.js.resolve.BindingContextSlicesJsKt;
import ksp.org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import ksp.org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import ksp.org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"checkJsModuleUsage", "", "bindingContext", "Lksp/org/jetbrains/kotlin/resolve/BindingContext;", "diagnosticSink", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticSink;", "container", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "callee", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "normalizeDescriptor", "descriptor", "findRoot", "js.frontend"})
public final class JsModuleCheckUtilKt {
    public static final void checkJsModuleUsage(@NotNull BindingContext bindingContext, @NotNull DiagnosticSink diagnosticSink, @NotNull DeclarationDescriptor container, @NotNull DeclarationDescriptor callee, @NotNull PsiElement reportOn) {
        boolean callToNonModule;
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)diagnosticSink, (String)"diagnosticSink");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule(container);
        Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor, (String)"getContainingModule(...)");
        ModuleDescriptor module2 = moduleDescriptor;
        ModuleKind moduleKind = (ModuleKind)((Object)bindingContext.get(BindingContextSlicesJsKt.MODULE_KIND, module2));
        if (moduleKind == null) {
            return;
        }
        ModuleKind moduleKind2 = moduleKind;
        DeclarationDescriptor calleeRootContainer = JsModuleCheckUtilKt.findRoot(callee);
        boolean callToModule = AnnotationsUtils.getModuleName(calleeRootContainer) != null || AnnotationsUtils.getFileModuleName(bindingContext, calleeRootContainer) != null;
        boolean bl2 = callToNonModule = AnnotationsUtils.isNonModule(calleeRootContainer) || AnnotationsUtils.isFromNonModuleFile(bindingContext, calleeRootContainer);
        if (moduleKind2 == ModuleKind.UMD) {
            if (!callToNonModule && callToModule || callToNonModule && !callToModule) {
                diagnosticSink.report(ErrorsJs.CALL_FROM_UMD_MUST_BE_JS_MODULE_AND_JS_NON_MODULE.on(reportOn));
            }
        } else if (moduleKind2 == ModuleKind.PLAIN) {
            if (!callToNonModule && callToModule) {
                diagnosticSink.report(ErrorsJs.CALL_TO_JS_MODULE_WITHOUT_MODULE_SYSTEM.on(reportOn, JsModuleCheckUtilKt.normalizeDescriptor(callee)));
            }
        } else if (!callToModule && callToNonModule) {
            diagnosticSink.report(ErrorsJs.CALL_TO_JS_NON_MODULE_WITH_MODULE_SYSTEM.on(reportOn, JsModuleCheckUtilKt.normalizeDescriptor(callee)));
        }
    }

    private static final DeclarationDescriptor normalizeDescriptor(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof FakeCallableDescriptorForObject) {
            return ((FakeCallableDescriptorForObject)descriptor2).getClassDescriptor();
        }
        return descriptor2;
    }

    private static final DeclarationDescriptor findRoot(DeclarationDescriptor callee) {
        return (DeclarationDescriptor)SequencesKt.last((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)callee, JsModuleCheckUtilKt::findRoot$lambda$0), JsModuleCheckUtilKt::findRoot$lambda$1));
    }

    private static final DeclarationDescriptor findRoot$lambda$0(DeclarationDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getContainingDeclaration();
    }

    private static final boolean findRoot$lambda$1(DeclarationDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof PackageFragmentDescriptor);
    }
}

