/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElementKt;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactoryForDeprecation;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirVisibilityChecker;
import ksp.org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirArrayOfNothingQualifierCheckerKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeCapturedType;
import ksp.org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import ksp.org.jetbrains.kotlin.fir.types.ConeDynamicType;
import ksp.org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypesKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\u000e*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002JR\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u001c\u001a\u00020\u0011H\u0002J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002\u00a8\u0006\u001e"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirReifiedChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isReifiedTypeParameterOrFromKotlinArray", "", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "cannotBeReified", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "checkArgumentAndReport", "typeArgument", "typeParameter", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "isExplicit", "isArray", "isPlaceHolder", "fullyExpandedType", "isTypeArgumentVisibilityBroken", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirReifiedChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReifiedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReifiedChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,149:1\n669#2,11:150\n13472#3,2:161\n*S KotlinDebug\n*F\n+ 1 FirReifiedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReifiedChecker\n*L\n38#1:150,11\n99#1:161,2\n*E\n"})
public final class FirReifiedChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirReifiedChecker INSTANCE = new FirReifiedChecker();

    private FirReifiedChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirCallableSymbol varargParameter;
        Object object;
        ConeKotlinType varargElementType;
        FirCallableSymbol firCallableSymbol;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirReference calleeReference = expression2.getCalleeReference();
        List<FirTypeProjection> typeArguments2 = expression2.getTypeArguments();
        FirCallableSymbol callableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(calleeReference, false, 1, null);
        Object object2 = callableSymbol;
        if (object2 == null || (object2 = ((FirCallableSymbol)object2).getTypeParameterSymbols()) == null) {
            return;
        }
        Object typeParameters2 = object2;
        int count = Math.min(typeArguments2.size(), typeParameters2.size());
        Object object3 = callableSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)callableSymbol : null;
        if (object3 != null && (object3 = ((FirFunctionSymbol)object3).getValueParameterSymbols()) != null) {
            Object v2;
            block7: {
                Iterable $this$singleOrNull$iv = (Iterable)object3;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                    boolean bl2 = false;
                    if (!it.isVararg()) continue;
                    if (found$iv) {
                        v2 = null;
                        break block7;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v2 = !found$iv ? null : single$iv;
            }
            firCallableSymbol = v2;
        } else {
            firCallableSymbol = null;
        }
        ConeKotlinType coneKotlinType = varargElementType = (object = (varargParameter = firCallableSymbol)) != null && (object = ((FirCallableSymbol)object).getResolvedReturnType()) != null ? FirTypeUtilsKt.arrayElementType$default((ConeKotlinType)object, false, 1, null) : null;
        ConeSimpleKotlinType $i$f$singleOrNull = coneKotlinType != null ? ConeTypesKt.unwrapToSimpleTypeUsingLowerBound(coneKotlinType) : null;
        Object object4 = $i$f$singleOrNull instanceof ConeTypeParameterType ? (ConeTypeParameterType)$i$f$singleOrNull : null;
        FirTypeParameterSymbol varargTypeParameter = object4 != null && (object4 = ((ConeTypeParameterType)object4).getLookupTag()) != null ? ((ConeTypeParameterLookupTag)object4).getTypeParameterSymbol() : null;
        for (int index2 = 0; index2 < count; ++index2) {
            boolean isPlaceHolder;
            FirTypeProjection typeArgumentProjection = typeArguments2.get(index2);
            KtSourceElement ktSourceElement = typeArgumentProjection.getSource();
            if (ktSourceElement == null && (ktSourceElement = calleeReference.getSource()) == null) continue;
            KtSourceElement source = ktSourceElement;
            ConeKotlinType coneKotlinType2 = ConeTypeProjectionKt.getType(FirTypeUtilsKt.toConeTypeProjection(typeArgumentProjection));
            if (coneKotlinType2 == null || (coneKotlinType2 = TypeExpansionUtilsKt.fullyExpandedType$default(coneKotlinType2, context2.getSession(), null, 2, null)) == null) continue;
            ConeKotlinType typeArgument = coneKotlinType2;
            FirTypeParameterSymbol typeParameter = (FirTypeParameterSymbol)typeParameters2.get(index2);
            KtSourceElement ktSourceElement2 = typeArgumentProjection.getSource();
            boolean isExplicit = Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE);
            boolean bl3 = isPlaceHolder = isExplicit && Intrinsics.areEqual((Object)KtSourceElementKt.getText(typeArgumentProjection.getSource()), (Object)"_");
            if (this.isReifiedTypeParameterOrFromKotlinArray(typeParameter)) {
                this.checkArgumentAndReport(typeArgument, typeParameter, source, isExplicit, false, isPlaceHolder, context2, reporter, typeArgument);
                continue;
            }
            if (!Intrinsics.areEqual((Object)varargTypeParameter, (Object)typeParameter) || !this.isTypeArgumentVisibilityBroken(context2, typeArgument) || isExplicit && !isPlaceHolder) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINFERRED_INVISIBLE_VARARG_TYPE_ARGUMENT(), (Object)typeParameter, (Object)typeArgument, (Object)varargParameter, (DiagnosticContext)context2, null, 64, null);
        }
    }

    private final boolean isReifiedTypeParameterOrFromKotlinArray(FirTypeParameterSymbol $this$isReifiedTypeParameterOrFromKotlinArray) {
        FirBasedSymbol<?> containingDeclaration = $this$isReifiedTypeParameterOrFromKotlinArray.getContainingDeclarationSymbol();
        return $this$isReifiedTypeParameterOrFromKotlinArray.isReified() || containingDeclaration instanceof FirRegularClassSymbol && Intrinsics.areEqual((Object)((FirRegularClassSymbol)containingDeclaration).getClassId(), (Object)StandardClassIds.INSTANCE.getArray());
    }

    private final boolean cannotBeReified(ConeKotlinType $this$cannotBeReified, LanguageVersionSettings languageVersionSettings) {
        ConeKotlinType coneKotlinType = $this$cannotBeReified;
        return coneKotlinType instanceof ConeCapturedType ? true : (coneKotlinType instanceof ConeDynamicType ? true : FirArrayOfNothingQualifierCheckerKt.unsupportedKindOfNothingAsReifiedOrInArray($this$cannotBeReified, languageVersionSettings) != null);
    }

    private final void checkArgumentAndReport(ConeKotlinType typeArgument, FirTypeParameterSymbol typeParameter, KtSourceElement source, boolean isExplicit, boolean isArray, boolean isPlaceHolder, CheckerContext context2, DiagnosticReporter reporter, ConeKotlinType fullyExpandedType2) {
        if (Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(fullyExpandedType2), (Object)StandardClassIds.INSTANCE.getArray())) {
            ConeTypeProjection[] $this$forEach$iv = fullyExpandedType2.getTypeArguments();
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ConeTypeProjection element$iv;
                ConeTypeProjection it = element$iv = $this$forEach$iv[i2];
                boolean bl2 = false;
                if (!(it instanceof ConeKotlinType)) continue;
                FirReifiedChecker.checkArgumentAndReport$default(INSTANCE, (ConeKotlinType)it, typeParameter, source, isExplicit, true, isPlaceHolder, context2, reporter, null, 256, null);
            }
            return;
        }
        if (this.isTypeArgumentVisibilityBroken(context2, fullyExpandedType2) && (!isExplicit || isPlaceHolder)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINFERRED_INVISIBLE_REIFIED_TYPE_ARGUMENT(), (Object)typeParameter, (Object)fullyExpandedType2, (DiagnosticContext)context2, null, 32, null);
        }
        if (typeArgument instanceof ConeTypeParameterType) {
            FirTypeParameterSymbol symbol = ((ConeTypeParameterType)typeArgument).getLookupTag().getTypeParameterSymbol();
            if (!symbol.isReified()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, isArray ? (KtDiagnosticFactory1)KtDiagnosticReportHelpersKt.chooseFactory((KtDiagnosticFactoryForDeprecation)FirErrors.INSTANCE.getTYPE_PARAMETER_AS_REIFIED_ARRAY(), context2) : FirErrors.INSTANCE.getTYPE_PARAMETER_AS_REIFIED(), (Object)symbol, (DiagnosticContext)context2, null, 16, null);
            }
        } else if (typeArgument instanceof ConeDefinitelyNotNullType && isExplicit) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEFINITELY_NON_NULLABLE_AS_REIFIED(), (DiagnosticContext)context2, null, 8, null);
        } else if (this.cannotBeReified(typeArgument, context2.getLanguageVersionSettings())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getREIFIED_TYPE_FORBIDDEN_SUBSTITUTION(), (Object)typeArgument, (DiagnosticContext)context2, null, 16, null);
        } else if (typeArgument instanceof ConeIntersectionType) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getTYPE_INTERSECTION_AS_REIFIED(), (Object)typeParameter, ((ConeIntersectionType)typeArgument).getIntersectedTypes(), (DiagnosticContext)context2, null, 32, null);
        }
    }

    static /* synthetic */ void checkArgumentAndReport$default(FirReifiedChecker firReifiedChecker, ConeKotlinType coneKotlinType, FirTypeParameterSymbol firTypeParameterSymbol, KtSourceElement ktSourceElement, boolean bl2, boolean bl3, boolean bl4, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, ConeKotlinType coneKotlinType2, int n2, Object object) {
        if ((n2 & 0x100) != 0) {
            coneKotlinType2 = TypeExpansionUtilsKt.fullyExpandedType$default(coneKotlinType, checkerContext.getSession(), null, 2, null);
        }
        firReifiedChecker.checkArgumentAndReport(coneKotlinType, firTypeParameterSymbol, ktSourceElement, bl2, bl3, bl4, checkerContext, diagnosticReporter, coneKotlinType2);
    }

    private final boolean isTypeArgumentVisibilityBroken(CheckerContext context2, ConeKotlinType fullyExpandedType2) {
        FirVisibilityChecker visibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker(context2.getSession());
        FirClassSymbol<?> classSymbol = ToSymbolUtilsKt.toClassSymbol(fullyExpandedType2, context2.getSession());
        FirFile containingFile2 = context2.getContainingFile();
        if (classSymbol == null || containingFile2 == null) {
            return false;
        }
        return !visibilityChecker.isClassLikeVisible((FirClassLikeDeclaration)classSymbol.getFir(), context2.getSession(), containingFile2, context2.getContainingDeclarations());
    }
}

