/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.CallableId;
import ksp.org.jetbrains.kotlin.name.CallableIdKt;
import ksp.org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B?\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\f\"\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/AbstractAtomicReferenceToPrimitiveCallChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "appropriateCandidatesForArgument", "", "Lksp/org/jetbrains/kotlin/name/ClassId;", "mppKind", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "firstProblematicCallableId", "Lksp/org/jetbrains/kotlin/name/CallableId;", "remainingProblematicCallableIds", "", "<init>", "(Ljava/util/Map;Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;Lorg/jetbrains/kotlin/name/CallableId;[Lorg/jetbrains/kotlin/name/CallableId;)V", "getAppropriateCandidatesForArgument", "()Ljava/util/Map;", "problematicCallableIds", "", "getProblematicCallableIds", "()Ljava/util/Set;", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public abstract class AbstractAtomicReferenceToPrimitiveCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    private final Map<ClassId, ClassId> appropriateCandidatesForArgument;
    @NotNull
    private final Set<CallableId> problematicCallableIds;

    public AbstractAtomicReferenceToPrimitiveCallChecker(@NotNull Map<ClassId, ClassId> appropriateCandidatesForArgument, @NotNull MppCheckerKind mppKind, @NotNull CallableId firstProblematicCallableId, CallableId ... remainingProblematicCallableIds) {
        Intrinsics.checkNotNullParameter(appropriateCandidatesForArgument, (String)"appropriateCandidatesForArgument");
        Intrinsics.checkNotNullParameter((Object)((Object)mppKind), (String)"mppKind");
        Intrinsics.checkNotNullParameter((Object)firstProblematicCallableId, (String)"firstProblematicCallableId");
        Intrinsics.checkNotNullParameter((Object)remainingProblematicCallableIds, (String)"remainingProblematicCallableIds");
        super(mppKind);
        this.appropriateCandidatesForArgument = appropriateCandidatesForArgument;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)firstProblematicCallableId);
        spreadBuilder.addSpread((Object)remainingProblematicCallableIds);
        this.problematicCallableIds = SetsKt.setOf((Object[])spreadBuilder.toArray((Object[])new CallableId[spreadBuilder.size()]));
    }

    @NotNull
    public final Map<ClassId, ClassId> getAppropriateCandidatesForArgument() {
        return this.appropriateCandidatesForArgument;
    }

    @NotNull
    public final Set<CallableId> getProblematicCallableIds() {
        return this.problematicCallableIds;
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved(expression2.getCalleeReference());
        FirBasedSymbol<?> firBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
        FirFunctionSymbol firFunctionSymbol = firBasedSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)firBasedSymbol : null;
        if (firFunctionSymbol == null) {
            return;
        }
        FirFunctionSymbol callable = firFunctionSymbol;
        Object object = expression2.getDispatchReceiver();
        if (object == null || (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) == null || (object = TypeExpansionUtilsKt.fullyExpandedType$default((ConeKotlinType)object, context2.getSession(), null, 2, null)) == null) {
            return;
        }
        Object receiverType = object;
        ClassId classId = ConeTypeUtilsKt.getClassId((ConeKotlinType)receiverType);
        if (classId == null) {
            return;
        }
        ClassId atomicReferenceClassId = classId;
        CallableId fullyExpandedCallableId = CallableIdKt.withClassId(callable.getCallableId(), atomicReferenceClassId);
        if (this.problematicCallableIds.contains(fullyExpandedCallableId)) {
            FirHelpersKt.reportAtomicToPrimitiveProblematicAccess((ConeKotlinType)receiverType, expression2.getSource(), atomicReferenceClassId, this.appropriateCandidatesForArgument, context2, reporter);
        }
    }
}

