/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.config.FirContextParametersLanguageVersionSettingsChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameterKindKt;
import ksp.org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextReceiversDeprecatedDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "onlyLegacyContextReceivers", "", "", "Lksp/org/jetbrains/kotlin/fir/declarations/FirValueParameter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContextReceiversDeprecatedDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContextReceiversDeprecatedDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextReceiversDeprecatedDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1740#2,3:51\n*S KotlinDebug\n*F\n+ 1 FirContextReceiversDeprecatedDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextReceiversDeprecatedDeclarationChecker\n*L\n47#1:51,3\n*E\n"})
public final class FirContextReceiversDeprecatedDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirContextReceiversDeprecatedDeclarationChecker INSTANCE = new FirContextReceiversDeprecatedDeclarationChecker();

    private FirContextReceiversDeprecatedDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ContextParameters)) {
            return;
        }
        if (declaration2 instanceof FirCallableDeclaration && !(declaration2 instanceof FirAnonymousFunction) && this.onlyLegacyContextReceivers(((FirCallableDeclaration)declaration2).getContextParameters())) {
            if (declaration2 instanceof FirConstructor && !(declaration2 instanceof FirPrimaryConstructor)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirConstructor)declaration2).getSource(), FirErrors.INSTANCE.getCONTEXT_CLASS_OR_CONSTRUCTOR(), (DiagnosticContext)context2, null, 8, null);
            } else {
                String message = FirContextParametersLanguageVersionSettingsChecker.INSTANCE.getMessage(context2.getLanguageVersionSettings());
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirCallableDeclaration)declaration2).getSource(), FirErrors.INSTANCE.getCONTEXT_RECEIVERS_DEPRECATED(), (Object)message, (DiagnosticContext)context2, null, 16, null);
            }
        }
        if (declaration2 instanceof FirRegularClass && this.onlyLegacyContextReceivers(((FirRegularClass)declaration2).getContextParameters())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirRegularClass)declaration2).getSource(), FirErrors.INSTANCE.getCONTEXT_CLASS_OR_CONSTRUCTOR(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean onlyLegacyContextReceivers(List<? extends FirValueParameter> $this$onlyLegacyContextReceivers) {
        FirValueParameter it;
        if (((Collection)$this$onlyLegacyContextReceivers).isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Iterable $this$all$iv = $this$onlyLegacyContextReceivers;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (FirValueParameter)element$iv;
            boolean bl3 = false;
        } while (FirValueParameterKindKt.isLegacyContextReceiver(it));
        return false;
    }
}

