/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.diagnostics;

import java.util.List;
import kotlin.DeprecationLevel;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.diagnostics.Diagnostic;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import ksp.org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import ksp.org.jetbrains.kotlin.diagnostics.PositioningStrategy;
import ksp.org.jetbrains.kotlin.diagnostics.Severity;

public abstract class DiagnosticFactoryWithPsiElement<E extends PsiElement, D extends Diagnostic>
extends DiagnosticFactory<D> {
    protected final PositioningStrategy<? super E> positioningStrategy;

    public DiagnosticFactoryWithPsiElement(Severity severity, PositioningStrategy<? super E> positioningStrategy) {
        super(severity);
        this.positioningStrategy = positioningStrategy;
    }

    protected List<TextRange> getTextRanges(ParametrizedDiagnostic<E> diagnostic) {
        return this.positioningStrategy.markDiagnostic(diagnostic);
    }

    protected boolean isValid(ParametrizedDiagnostic<E> diagnostic) {
        return this.positioningStrategy.isValid(diagnostic.getPsiElement());
    }

    public PositioningStrategy<? super E> getPositioningStrategy() {
        return this.positioningStrategy;
    }

    @Deprecated
    @kotlin.Deprecated(message="Use `cast` from the superclass.", level=DeprecationLevel.HIDDEN)
    public D cast(Diagnostic d2) {
        return (D)((Diagnostic)super.cast(d2));
    }
}

