/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.container;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.container.ComponentContainer;
import ksp.org.jetbrains.kotlin.container.ComponentDescriptor;
import ksp.org.jetbrains.kotlin.container.ComponentState;
import ksp.org.jetbrains.kotlin.container.ContainerConsistencyException;
import ksp.org.jetbrains.kotlin.container.ValueResolveContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0017\u001a\u00020\nH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0004J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH$J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u001e\u001a\u00020\u0019H\u0002J\b\u0010\u001f\u001a\u00020\u0019H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006\u0003"}, d2={"Lksp/org/jetbrains/kotlin/container/SingletonDescriptor;", "Lksp/org/jetbrains/kotlin/container/ComponentDescriptor;", "Ljava/io/Closeable;", "container", "Lksp/org/jetbrains/kotlin/container/ComponentContainer;", "<init>", "(Lorg/jetbrains/kotlin/container/ComponentContainer;)V", "getContainer", "()Lorg/jetbrains/kotlin/container/ComponentContainer;", "instance", "", "state", "Lksp/org/jetbrains/kotlin/container/ComponentState;", "getState", "()Lorg/jetbrains/kotlin/container/ComponentState;", "setState", "(Lorg/jetbrains/kotlin/container/ComponentState;)V", "disposableObjects", "Ljava/util/ArrayList;", "getDisposableObjects", "()Ljava/util/ArrayList;", "disposableObjects$delegate", "Lkotlin/Lazy;", "getValue", "registerDisposableObject", "", "ownedObject", "createInstance", "context", "Lksp/org/jetbrains/kotlin/container/ValueResolveContext;", "disposeImpl", "close", "shouldInjectProperties", "", "getShouldInjectProperties", "()Z"})
public abstract class SingletonDescriptor
implements ComponentDescriptor,
Closeable {
    @NotNull
    private final ComponentContainer container;
    @Nullable
    private Object instance;
    @NotNull
    private ComponentState state;
    @NotNull
    private final Lazy disposableObjects$delegate;

    public SingletonDescriptor(@NotNull ComponentContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.container = container;
        this.state = ComponentState.Null;
        this.disposableObjects$delegate = LazyKt.lazy(SingletonDescriptor::disposableObjects_delegate$lambda$0);
    }

    @NotNull
    public final ComponentContainer getContainer() {
        return this.container;
    }

    @NotNull
    protected final ComponentState getState() {
        return this.state;
    }

    protected final void setState(@NotNull ComponentState componentState) {
        Intrinsics.checkNotNullParameter((Object)((Object)componentState), (String)"<set-?>");
        this.state = componentState;
    }

    private final ArrayList<Closeable> getDisposableObjects() {
        Lazy lazy = this.disposableObjects$delegate;
        return (ArrayList)lazy.getValue();
    }

    @Override
    @NotNull
    public Object getValue() {
        if (this.state == ComponentState.Corrupted) {
            throw new ContainerConsistencyException("Component descriptor " + this + " is corrupted and cannot be accessed");
        }
        if (this.state == ComponentState.Disposed) {
            throw new ContainerConsistencyException("Component descriptor " + this + " is disposed and cannot be accessed");
        }
        if (this.instance == null) {
            this.createInstance(this.container);
        }
        Object object = this.instance;
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    protected final void registerDisposableObject(@NotNull Closeable ownedObject) {
        Intrinsics.checkNotNullParameter((Object)ownedObject, (String)"ownedObject");
        this.getDisposableObjects().add(ownedObject);
    }

    @NotNull
    protected abstract Object createInstance(@NotNull ValueResolveContext var1);

    private final void createInstance(ComponentContainer container) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                try {
                    this.instance = this.createInstance(container.createResolveContext(this));
                    return;
                }
                catch (Throwable ex) {
                    this.state = ComponentState.Corrupted;
                    Iterator<Closeable> iterator2 = this.getDisposableObjects().iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
                    Iterator<Closeable> iterator3 = iterator2;
                    while (iterator3.hasNext()) {
                        Closeable disposable;
                        Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                        disposable.close();
                    }
                    throw ex;
                }
            }
            case 2: {
                throw new ContainerConsistencyException("Could not create the component " + this + " because it is being initialized. Do we have undetected circular dependency?");
            }
            case 3: {
                throw new ContainerConsistencyException("Could not get the component " + this + ". Instance is null in Initialized state");
            }
            case 4: {
                throw new ContainerConsistencyException("Could not get the component " + this + " because it is corrupted");
            }
            case 5: {
                throw new ContainerConsistencyException("Could not get the component " + this + " because it is being disposed");
            }
            case 6: {
                throw new ContainerConsistencyException("Could not get the component " + this + " because it is already disposed");
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final void disposeImpl() {
        Object wereInstance = this.instance;
        this.state = ComponentState.Disposing;
        this.instance = null;
        try {
            if (wereInstance instanceof Closeable) {
                ((Closeable)wereInstance).close();
            }
            Iterator<Closeable> iterator2 = this.getDisposableObjects().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<Closeable> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Closeable disposable;
                Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                disposable.close();
            }
        }
        catch (Throwable ex) {
            this.state = ComponentState.Corrupted;
            throw ex;
        }
        this.state = ComponentState.Disposed;
    }

    @Override
    public void close() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 3: {
                this.disposeImpl();
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                throw new ContainerConsistencyException("The component is being initialized and cannot be disposed.");
            }
            case 5: {
                throw new ContainerConsistencyException("The component is already in disposing state.");
            }
            case 6: {
                throw new ContainerConsistencyException("The component has already been destroyed.");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public boolean getShouldInjectProperties() {
        return true;
    }

    private static final ArrayList disposableObjects_delegate$lambda$0() {
        return new ArrayList();
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ComponentState.values().length];
            try {
                nArray[ComponentState.Null.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentState.Initializing.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentState.Initialized.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentState.Corrupted.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentState.Disposing.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentState.Disposed.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

