/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.compiled.ClsStubBuilder;
import ksp.com.intellij.psi.stubs.PsiFileStub;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.util.indexing.FileContent;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.CallableClsStubBuilderKt;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.ClassClsStubBuilderKt;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderComponents;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContext;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file.AnnotationLoaderForStubBuilderImpl;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.metadata.ProtoBuf;
import ksp.org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import ksp.org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import ksp.org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import ksp.org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import ksp.org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import ksp.org.jetbrains.kotlin.serialization.deserialization.ClassDeserializer;
import ksp.org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import ksp.org.jetbrains.kotlin.serialization.deserialization.ProtoBasedClassDataFinder;
import ksp.org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001bBA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u001a\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder;", "Lksp/com/intellij/psi/compiled/ClsStubBuilder;", "version", "", "fileType", "Lksp/com/intellij/openapi/fileTypes/FileType;", "serializerProtocol", "Lkotlin/Function0;", "Lksp/org/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "readFile", "Lkotlin/Function2;", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "", "Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "<init>", "(ILcom/intellij/openapi/fileTypes/FileType;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function2;)V", "getStubVersion", "buildFileStub", "Lksp/com/intellij/psi/stubs/PsiFileStub;", "content", "Lksp/com/intellij/util/indexing/FileContent;", "createCallableSource", "Lksp/org/jetbrains/kotlin/descriptors/SourceElement;", "file", "Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible;", "filename", "", "FileWithMetadata", "decompiler-to-file-stubs"})
@SourceDebugExtension(value={"SMAP\nKotlinMetadataStubBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMetadataStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public class KotlinMetadataStubBuilder
extends ClsStubBuilder {
    private final int version;
    @NotNull
    private final FileType fileType;
    @NotNull
    private final Function0<SerializerExtensionProtocol> serializerProtocol;
    @NotNull
    private final Function2<VirtualFile, byte[], FileWithMetadata> readFile;

    public KotlinMetadataStubBuilder(int version, @NotNull FileType fileType, @NotNull Function0<? extends SerializerExtensionProtocol> serializerProtocol, @NotNull Function2<? super VirtualFile, ? super byte[], ? extends FileWithMetadata> readFile) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter(serializerProtocol, (String)"serializerProtocol");
        Intrinsics.checkNotNullParameter(readFile, (String)"readFile");
        this.version = version;
        this.fileType = fileType;
        this.serializerProtocol = serializerProtocol;
        this.readFile = readFile;
    }

    @Override
    public int getStubVersion() {
        return 27 + this.version;
    }

    @Override
    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        VirtualFile virtualFile = content.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile virtualFile2 = virtualFile;
        boolean bl3 = bl2 = Intrinsics.areEqual((Object)virtualFile2.getExtension(), (Object)this.fileType.getDefaultExtension()) || Intrinsics.areEqual((Object)virtualFile2.getFileType(), (Object)this.fileType);
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string2 = "Unexpected file type " + virtualFile2.getFileType().getName();
            throw new AssertionError((Object)string2);
        }
        byte[] byArray = content.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getContent(...)");
        FileWithMetadata fileWithMetadata = (FileWithMetadata)this.readFile.invoke((Object)virtualFile2, (Object)byArray);
        if (fileWithMetadata == null) {
            return null;
        }
        FileWithMetadata file2 = fileWithMetadata;
        FileWithMetadata fileWithMetadata2 = file2;
        if (fileWithMetadata2 instanceof FileWithMetadata.Incompatible) {
            return ClsStubBuildingKt.createIncompatibleAbiVersionFileStub();
        }
        if (fileWithMetadata2 instanceof FileWithMetadata.Compatible) {
            ProtoBuf.Package packageProto = ((FileWithMetadata.Compatible)file2).getProto().getPackage();
            FqName packageFqName = ((FileWithMetadata.Compatible)file2).getPackageFqName();
            NameResolverImpl nameResolver = ((FileWithMetadata.Compatible)file2).getNameResolver();
            SerializerExtensionProtocol protocol = (SerializerExtensionProtocol)this.serializerProtocol.invoke();
            ClsStubBuilderComponents components = new ClsStubBuilderComponents(new ProtoBasedClassDataFinder(((FileWithMetadata.Compatible)file2).getProto(), nameResolver, ((FileWithMetadata.Compatible)file2).getVersion(), null, 8, null), new AnnotationLoaderForStubBuilderImpl(protocol), virtualFile2, protocol, null, null, 48, null);
            NameResolver nameResolver2 = nameResolver;
            ProtoBuf.TypeTable typeTable = packageProto.getTypeTable();
            Intrinsics.checkNotNullExpressionValue((Object)typeTable, (String)"getTypeTable(...)");
            ClsStubBuilderContext context2 = components.createContext(nameResolver2, packageFqName, new TypeTable(typeTable));
            KotlinFileStubImpl fileStub = ClsStubBuildingKt.createFileStub(packageFqName, false);
            StubElement stubElement = fileStub;
            NameResolver nameResolver3 = context2.getNameResolver();
            TypeTable typeTable2 = context2.getTypeTable();
            FileWithMetadata.Compatible compatible = (FileWithMetadata.Compatible)file2;
            String string3 = content.getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFileName(...)");
            ProtoContainer.Package package_ = new ProtoContainer.Package(packageFqName, nameResolver3, typeTable2, this.createCallableSource(compatible, string3));
            Intrinsics.checkNotNull((Object)packageProto);
            CallableClsStubBuilderKt.createPackageDeclarationsStubs(stubElement, context2, package_, packageProto);
            for (ProtoBuf.Class classProto : ((FileWithMetadata.Compatible)file2).getClassesToDecompile()) {
                ClassClsStubBuilderKt.createClassStub(fileStub, classProto, nameResolver, NameResolverUtilKt.getClassId(nameResolver, classProto.getFqName()), null, context2);
            }
            return fileStub;
        }
        throw new NoWhenBranchMatchedException();
    }

    @Nullable
    protected SourceElement createCallableSource(@NotNull FileWithMetadata.Compatible file2, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "", "<init>", "()V", "Incompatible", "Compatible", "Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible;", "Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Incompatible;", "decompiler-to-file-stubs"})
    public static abstract class FileWithMetadata {
        private FileWithMetadata() {
        }

        public /* synthetic */ FileWithMetadata(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible;", "Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "proto", "Lksp/org/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "version", "Lksp/org/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "serializerProtocol", "Lksp/org/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "<init>", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)V", "getProto", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "getVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "nameResolver", "Lksp/org/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "getNameResolver", "()Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "packageFqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "classesToDecompile", "", "Lksp/org/jetbrains/kotlin/metadata/ProtoBuf$Class;", "getClassesToDecompile", "()Ljava/util/List;", "decompiler-to-file-stubs"})
        @SourceDebugExtension(value={"SMAP\nKotlinMetadataStubBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMetadataStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n774#2:106\n865#2,2:107\n*S KotlinDebug\n*F\n+ 1 KotlinMetadataStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible\n*L\n97#1:106\n97#1:107,2\n*E\n"})
        public static class Compatible
        extends FileWithMetadata {
            @NotNull
            private final ProtoBuf.PackageFragment proto;
            @NotNull
            private final BinaryVersion version;
            @NotNull
            private final NameResolverImpl nameResolver;
            @NotNull
            private final FqName packageFqName;
            @NotNull
            private final List<ProtoBuf.Class> classesToDecompile;

            /*
             * WARNING - void declaration
             */
            public Compatible(@NotNull ProtoBuf.PackageFragment proto, @NotNull BinaryVersion version, @NotNull SerializerExtensionProtocol serializerProtocol) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                Intrinsics.checkNotNullParameter((Object)serializerProtocol, (String)"serializerProtocol");
                super(null);
                this.proto = proto;
                this.version = version;
                ProtoBuf.StringTable stringTable2 = this.proto.getStrings();
                Intrinsics.checkNotNullExpressionValue((Object)stringTable2, (String)"getStrings(...)");
                ProtoBuf.QualifiedNameTable qualifiedNameTable = this.proto.getQualifiedNames();
                Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"getQualifiedNames(...)");
                this.nameResolver = new NameResolverImpl(stringTable2, qualifiedNameTable);
                Integer n2 = this.proto.getPackage().getExtension(serializerProtocol.getPackageFqName());
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"getExtension(...)");
                this.packageFqName = new FqName(this.nameResolver.getPackageFqName(((Number)n2).intValue()));
                List<ProtoBuf.Class> list = this.proto.getClass_List();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getClass_List(...)");
                Iterable iterable = list;
                Compatible compatible = this;
                boolean $i$f$filter = false;
                void var6_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ProtoBuf.Class proto2 = (ProtoBuf.Class)element$iv$iv;
                    boolean bl2 = false;
                    ClassId classId = NameResolverUtilKt.getClassId(this.nameResolver, proto2.getFqName());
                    if (!(!classId.isNestedClass() && !ClassDeserializer.Companion.getBLACK_LIST().contains(classId))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                compatible.classesToDecompile = (List)destination$iv$iv;
            }

            @NotNull
            public final ProtoBuf.PackageFragment getProto() {
                return this.proto;
            }

            @NotNull
            public final BinaryVersion getVersion() {
                return this.version;
            }

            @NotNull
            public final NameResolverImpl getNameResolver() {
                return this.nameResolver;
            }

            @NotNull
            public final FqName getPackageFqName() {
                return this.packageFqName;
            }

            @NotNull
            public List<ProtoBuf.Class> getClassesToDecompile() {
                return this.classesToDecompile;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Incompatible;", "Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "version", "Lksp/org/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "<init>", "(Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;)V", "getVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "decompiler-to-file-stubs"})
        public static final class Incompatible
        extends FileWithMetadata {
            @NotNull
            private final BinaryVersion version;

            public Incompatible(@NotNull BinaryVersion version) {
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                super(null);
                this.version = version;
            }

            @NotNull
            public final BinaryVersion getVersion() {
                return this.version;
            }
        }
    }
}

