/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.resolve;

import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceArray;
import ksp.com.intellij.model.Symbol;
import ksp.com.intellij.model.psi.PsiSymbolReference;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.progress.ProgressIndicatorProvider;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Computable;
import ksp.com.intellij.openapi.util.LowMemoryWatcher;
import ksp.com.intellij.openapi.util.Pair;
import ksp.com.intellij.openapi.util.RecursionGuard;
import ksp.com.intellij.openapi.util.RecursionManager;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiPolyVariantReference;
import ksp.com.intellij.psi.PsiReference;
import ksp.com.intellij.psi.ResolveResult;
import ksp.com.intellij.psi.impl.AnyPsiChangeListener;
import ksp.com.intellij.psi.impl.PsiManagerImpl;
import ksp.com.intellij.psi.util.PsiUtilCore;
import ksp.com.intellij.util.IdempotenceChecker;
import ksp.com.intellij.util.ObjectUtils;
import ksp.com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import ksp.com.intellij.util.messages.MessageBus;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class ResolveCache
implements Disposable {
    private final AtomicReferenceArray<Map<?, ?>> myPhysicalMaps;
    private final AtomicReferenceArray<Map<?, ?>> myNonPhysicalMaps;
    private static final Object NULL_RESULT = ObjectUtils.sentinel("ResolveCache.NULL_RESULT");
    private static final StrongValueReference<?, ?> NULL_VALUE_REFERENCE = new StrongValueReference(NULL_RESULT);
    private static final StrongValueReference<?, ?> EMPTY_RESOLVE_RESULT = new StrongValueReference(ResolveResult.EMPTY_ARRAY);

    public static ResolveCache getInstance(@NotNull Project project) {
        if (project == null) {
            ResolveCache.$$$reportNull$$$0(0);
        }
        ProgressIndicatorProvider.checkCanceled();
        return project.getService(ResolveCache.class);
    }

    public ResolveCache(@NotNull Project project) {
        if (project == null) {
            ResolveCache.$$$reportNull$$$0(1);
        }
        this.myPhysicalMaps = new AtomicReferenceArray(4);
        this.myNonPhysicalMaps = new AtomicReferenceArray(4);
        this.clearCacheOnPsiChange(project.getMessageBus());
        LowMemoryWatcher.register(() -> this.onLowMemory(), this);
    }

    private void clearCacheOnPsiChange(@NotNull MessageBus bus) {
        if (bus == null) {
            ResolveCache.$$$reportNull$$$0(2);
        }
        bus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                ResolveCache.this.clearCache(isPhysical);
            }
        });
    }

    private void onLowMemory() {
        ResolveCache.clearArray(this.myPhysicalMaps);
        ResolveCache.clearArray(this.myNonPhysicalMaps);
    }

    @Override
    public void dispose() {
    }

    @NotNull
    private static <K, V> Map<K, V> createWeakMap() {
        return new ConcurrentWeakKeySoftValueHashMap<K, V>(100, 0.75f, Runtime.getRuntime().availableProcessors()){

            @Override
            @NotNull
            protected ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> createValueReference(@NotNull V value2, @NotNull ReferenceQueue<? super V> queue) {
                if (value2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (queue == null) {
                    2.$$$reportNull$$$0(1);
                }
                ConcurrentWeakKeySoftValueHashMap.ValueReference result2 = value2 == NULL_RESULT || value2 instanceof Object[] && ((Object[])value2).length == 0 ? ResolveCache.createStrongReference(value2) : super.createValueReference(value2, queue);
                StrongValueReference strongValueReference = result2;
                if (strongValueReference == null) {
                    2.$$$reportNull$$$0(2);
                }
                return strongValueReference;
            }

            @Override
            public V get(@NotNull Object key) {
                Object v2;
                if (key == null) {
                    2.$$$reportNull$$$0(3);
                }
                return (v2 = super.get(key)) == NULL_RESULT ? null : (Object)v2;
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }

            @Override
            public int hashCode() {
                return System.identityHashCode(this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string2;
                switch (n2) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 2: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "queue";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ksp/com/intellij/psi/impl/source/resolve/ResolveCache$2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "ksp/com/intellij/psi/impl/source/resolve/ResolveCache$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createValueReference";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createValueReference";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "get";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public void clearCache(boolean isPhysical) {
        if (isPhysical) {
            ResolveCache.clearArray(this.myPhysicalMaps);
        }
        ResolveCache.clearArray(this.myNonPhysicalMaps);
    }

    private static void clearArray(@NotNull AtomicReferenceArray<?> array) {
        if (array == null) {
            ResolveCache.$$$reportNull$$$0(3);
        }
        for (int i2 = 0; i2 < array.length(); ++i2) {
            array.set(i2, null);
        }
    }

    public <T extends PsiPolyVariantReference> ResolveResult @NotNull [] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(4);
        }
        if (resolver == null) {
            ResolveCache.$$$reportNull$$$0(5);
        }
        ResolveResult[] resolveResultArray = this.resolveWithCaching(ref, resolver, needToPreventRecursion, incompleteCode, ref.getElement().getContainingFile());
        if (resolveResultArray == null) {
            ResolveCache.$$$reportNull$$$0(6);
        }
        return resolveResultArray;
    }

    public <T extends PsiPolyVariantReference> ResolveResult @NotNull [] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile2) {
        int index2;
        ResolveResult[] result2;
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(7);
        }
        if (resolver == null) {
            ResolveCache.$$$reportNull$$$0(8);
        }
        if (containingFile2 == null) {
            ResolveCache.$$$reportNull$$$0(9);
        }
        boolean isPhysical = containingFile2.isPhysical();
        ProgressIndicatorProvider.checkCanceled();
        if (isPhysical) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        ResolveResult[] resolveResultArray = (result2 = ResolveCache.resolve(ref, this.getMap(isPhysical, index2 = ResolveCache.getIndex(incompleteCode, true)), needToPreventRecursion, () -> (ResolveResult[])resolver.resolve(ref, incompleteCode))) == null ? ResolveResult.EMPTY_ARRAY : result2;
        if (resolveResultArray == null) {
            ResolveCache.$$$reportNull$$$0(10);
        }
        return resolveResultArray;
    }

    public <T extends PsiPolyVariantReference> ResolveResult @NotNull [] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantContextResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile2) {
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(11);
        }
        if (resolver == null) {
            ResolveCache.$$$reportNull$$$0(12);
        }
        if (containingFile2 == null) {
            ResolveCache.$$$reportNull$$$0(13);
        }
        ProgressIndicatorProvider.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean physical = containingFile2.isPhysical();
        int index2 = ResolveCache.getIndex(incompleteCode, true);
        Map map = this.getMap(physical, index2);
        ResolveResult[] results = ResolveCache.resolve(ref, map, needToPreventRecursion, () -> resolver.resolve(ref, containingFile2, incompleteCode));
        ResolveResult[] resolveResultArray = results == null ? ResolveResult.EMPTY_ARRAY : results;
        if (resolveResultArray == null) {
            ResolveCache.$$$reportNull$$$0(14);
        }
        return resolveResultArray;
    }

    @ApiStatus.Experimental
    @NotNull
    public <R extends PsiSymbolReference> @NotNull Collection<? extends @NotNull Symbol> resolveWithCaching(@NotNull R ref, @NotNull PsiSymbolReferenceResolver<? super R> resolver) {
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(15);
        }
        if (resolver == null) {
            ResolveCache.$$$reportNull$$$0(16);
        }
        Collection<Symbol> collection = this.resolveWithCaching(ref, true, resolver);
        if (collection == null) {
            ResolveCache.$$$reportNull$$$0(17);
        }
        return collection;
    }

    @ApiStatus.Experimental
    @NotNull
    public <R extends PsiSymbolReference> @NotNull Collection<? extends @NotNull Symbol> resolveWithCaching(@NotNull R ref, boolean preventRecursion, @NotNull PsiSymbolReferenceResolver<? super R> resolver) {
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(18);
        }
        if (resolver == null) {
            ResolveCache.$$$reportNull$$$0(19);
        }
        ProgressIndicatorProvider.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean physical = ref.getElement().isPhysical();
        int index2 = ResolveCache.getIndex(false, true);
        Collection results = ResolveCache.resolve(ref, this.getMap(physical, index2), preventRecursion, () -> resolver.resolve((Object)ref));
        Collection<Object> collection = results == null ? Collections.emptyList() : results;
        if (collection == null) {
            ResolveCache.$$$reportNull$$$0(20);
        }
        return collection;
    }

    @Nullable
    private static <TRef, TResult> TResult resolve(@NotNull TRef ref, @NotNull Map<TRef, TResult> cache2, boolean preventRecursion, @NotNull Computable<? extends TResult> resolver) {
        TResult result2;
        TResult cachedResult;
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(21);
        }
        if (cache2 == null) {
            ResolveCache.$$$reportNull$$$0(22);
        }
        if (resolver == null) {
            ResolveCache.$$$reportNull$$$0(23);
        }
        if ((cachedResult = cache2.get(ref)) != null) {
            if (IdempotenceChecker.areRandomChecksEnabled()) {
                IdempotenceChecker.applyForRandomCheck(cachedResult, ref, ResolveCache.loggingResolver(ref, resolver));
            }
            return cachedResult;
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        Computable<TResult> loggingResolver = ResolveCache.loggingResolver(ref, resolver);
        TResult TResult = result2 = preventRecursion ? RecursionManager.doPreventingRecursion(Pair.create(ref, cache2), true, loggingResolver) : loggingResolver.get();
        if (result2 instanceof ResolveResult) {
            ResolveCache.ensureValidPsi((ResolveResult)result2);
        } else if (result2 instanceof ResolveResult[]) {
            ResolveCache.ensureValidResults((ResolveResult[])result2);
        } else if (result2 instanceof PsiElement) {
            PsiUtilCore.ensureValid((PsiElement)result2);
        }
        if (stamp.mayCacheNow()) {
            ResolveCache.cache(ref, cache2, result2, loggingResolver);
        }
        return result2;
    }

    @NotNull
    private static <R> Computable<R> loggingResolver(@NotNull Object ref, @NotNull Computable<? extends R> resolver) {
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(24);
        }
        if (resolver == null) {
            ResolveCache.$$$reportNull$$$0(25);
        }
        Computable<Object> computable = () -> {
            if (IdempotenceChecker.isLoggingEnabled()) {
                IdempotenceChecker.logTrace("Resolving " + ref + " of " + ref.getClass());
            }
            return resolver.get();
        };
        if (computable == null) {
            ResolveCache.$$$reportNull$$$0(26);
        }
        return computable;
    }

    private static void ensureValidResults(@NotNull @NotNull ResolveResult @NotNull [] result2) {
        if (result2 == null) {
            ResolveCache.$$$reportNull$$$0(27);
        }
        for (ResolveResult resolveResult : result2) {
            ResolveCache.ensureValidPsi(resolveResult);
        }
    }

    private static void ensureValidPsi(@NotNull ResolveResult resolveResult) {
        PsiElement element2;
        if (resolveResult == null) {
            ResolveCache.$$$reportNull$$$0(28);
        }
        if ((element2 = resolveResult.getElement()) != null) {
            PsiUtilCore.ensureValid(element2);
        }
    }

    public <T extends PsiPolyVariantReference> ResolveResult @Nullable [] getCachedResults(@NotNull T ref, boolean physical, boolean incompleteCode, boolean isPoly) {
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(29);
        }
        Map map = this.getMap(physical, ResolveCache.getIndex(incompleteCode, isPoly));
        return (ResolveResult[])map.get(ref);
    }

    @Nullable
    public <TRef extends PsiReference, TResult> TResult resolveWithCaching(@NotNull TRef ref, @NotNull AbstractResolver<TRef, TResult> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(30);
        }
        if (resolver == null) {
            ResolveCache.$$$reportNull$$$0(31);
        }
        boolean isPhysical = ref.getElement().isPhysical();
        ProgressIndicatorProvider.checkCanceled();
        if (isPhysical) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        int index2 = ResolveCache.getIndex(incompleteCode, false);
        return (TResult)ResolveCache.resolve(ref, this.getMap(isPhysical, index2), needToPreventRecursion, () -> resolver.resolve(ref, incompleteCode));
    }

    @NotNull
    private <TRef, TResult> Map<TRef, TResult> getMap(boolean physical, int index2) {
        AtomicReferenceArray<Map<?, ?>> array = physical ? this.myPhysicalMaps : this.myNonPhysicalMaps;
        Map<Object, Object> map = array.get(index2);
        while (map == null) {
            Map newMap2 = ResolveCache.createWeakMap();
            map = array.compareAndSet(index2, null, newMap2) ? newMap2 : array.get(index2);
        }
        Map<?, ?> map2 = map;
        if (map2 == null) {
            ResolveCache.$$$reportNull$$$0(32);
        }
        return map2;
    }

    private static int getIndex(boolean incompleteCode, boolean isPoly) {
        return (incompleteCode ? 0 : 2) + (isPoly ? 0 : 1);
    }

    private static <TRef, TResult> void cache(@NotNull TRef ref, @NotNull Map<? super TRef, TResult> map, TResult result2, @NotNull Computable<? extends TResult> doResolve) {
        Object cached;
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(33);
        }
        if (map == null) {
            ResolveCache.$$$reportNull$$$0(34);
        }
        if (doResolve == null) {
            ResolveCache.$$$reportNull$$$0(35);
        }
        if ((cached = map.get(ref)) != null) {
            if (cached == result2) {
                return;
            }
            IdempotenceChecker.checkEquivalence(cached, result2, ref.getClass(), doResolve);
        }
        cached = result2 == null ? NULL_RESULT : result2;
        map.put(ref, cached);
    }

    @NotNull
    private static <K, V> StrongValueReference<K, V> createStrongReference(@NotNull V value2) {
        if (value2 == null) {
            ResolveCache.$$$reportNull$$$0(36);
        }
        return value2 == NULL_RESULT ? NULL_VALUE_REFERENCE : (value2 == ResolveResult.EMPTY_ARRAY ? EMPTY_RESOLVE_RESULT : new StrongValueReference(value2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 26: 
            case 32: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 26: 
            case 32: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 29: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 16: 
            case 19: 
            case 23: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/source/resolve/ResolveCache";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doResolve";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/resolve/ResolveCache";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 17: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveWithCaching";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "loggingResolver";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getMap";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "clearCacheOnPsiChange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "clearArray";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolveWithCaching";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 26: 
            case 32: {
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loggingResolver";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "ensureValidResults";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "ensureValidPsi";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getCachedResults";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "cache";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createStrongReference";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 26: 
            case 32: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StrongValueReference<K, V>
    implements ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> {
        private final V myValue;

        StrongValueReference(@NotNull V value2) {
            if (value2 == null) {
                StrongValueReference.$$$reportNull$$$0(0);
            }
            this.myValue = value2;
        }

        @Override
        @NotNull
        public ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> getKeyReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public V get() {
            V v2 = this.myValue;
            if (v2 == null) {
                StrongValueReference.$$$reportNull$$$0(1);
            }
            return v2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/impl/source/resolve/ResolveCache$StrongValueReference";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/impl/source/resolve/ResolveCache$StrongValueReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @FunctionalInterface
    public static interface PolyVariantResolver<T extends PsiPolyVariantReference>
    extends AbstractResolver<T, ResolveResult[]> {
        @Override
        public ResolveResult @NotNull [] resolve(@NotNull T var1, boolean var2);
    }

    @FunctionalInterface
    public static interface PolyVariantContextResolver<T extends PsiPolyVariantReference> {
        public ResolveResult @NotNull [] resolve(@NotNull T var1, @NotNull PsiFile var2, boolean var3);
    }

    @FunctionalInterface
    @ApiStatus.Experimental
    public static interface PsiSymbolReferenceResolver<R extends @NotNull PsiSymbolReference> {
        @NotNull
        public @NotNull Collection<? extends @NotNull Symbol> resolve(@NotNull R var1);
    }

    @FunctionalInterface
    public static interface AbstractResolver<TRef extends PsiReference, TResult> {
        public TResult resolve(@NotNull TRef var1, boolean var2);
    }

    @FunctionalInterface
    public static interface Resolver
    extends AbstractResolver<PsiReference, PsiElement> {
    }
}

