/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.vfs;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.fileEditor.FileDocumentManager;
import ksp.com.intellij.openapi.progress.ProgressManager;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.openapi.util.io.NioPathUtil;
import ksp.com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import ksp.com.intellij.openapi.vfs.VfsUtilCore;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.openapi.vfs.VirtualFileCachedValue;
import ksp.com.intellij.openapi.vfs.VirtualFileManager;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import ksp.com.intellij.util.concurrency.annotations.RequiresReadLock;
import ksp.com.intellij.util.concurrency.annotations.RequiresWriteLock;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\u001b\u0010\t\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u000b\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0007\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\b*\u00020\u0002H\u0007\u001a\u001b\u0010\u000e\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u000b\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0007\u001a\u001b\u0010\u000f\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u000b\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0007\u001a\u0019\u0010\u0010\u001a\u00020\u0002*\u00020\u00022\u000b\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0007\u001a\u0019\u0010\u0011\u001a\u00020\u0002*\u00020\u00022\u000b\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0007\u001a\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0007\u001am\u0010\u0016\u001a\u0002H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u0018*\u00020\u00022\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\u001b0\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u00012\u0016\b\u0002\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001e2\u001a\u0010\u001f\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u0002H\u00170 H\u0007\u00a2\u0006\u0002\u0010!\u001a:\u0010\"\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2#\u0010#\u001a\u001f\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00020$\u00a2\u0006\u0002\b%H\u0082\b\u001a\n\u0010&\u001a\u00020'*\u00020\u0002\u001a\n\u0010(\u001a\u00020\u000b*\u00020\u0002\u001a\f\u0010)\u001a\u0004\u0018\u00010\u0002*\u00020*\u001a\f\u0010+\u001a\u0004\u0018\u00010\u0002*\u00020*\u001a\f\u0010,\u001a\u0004\u0018\u00010\u0002*\u00020*\u001a \u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020*0.*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0016\u0010/\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u00100\u001a\u00020\u000bH\u0007\u001a\f\u00101\u001a\u0004\u0018\u00010**\u00020\u0002\u001a\f\u00102\u001a\u0004\u0018\u00010\u0002*\u00020\u0002\u001a\u0014\u00103\u001a\u000204*\u00020\u00022\u0006\u00105\u001a\u00020'H\u0007\u001a\u0014\u00106\u001a\u000204*\u00020\u00022\u0006\u00105\u001a\u00020\u000bH\u0007\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u00067"}, d2={"isFile", "", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)Z", "loadText", "", "packageJsonFile", "packageJsonDocument", "Lksp/com/intellij/openapi/editor/Document;", "findDirectory", "relativePath", "", "Lksp/org/jetbrains/annotations/SystemIndependent;", "findDocument", "findFile", "findFileOrDirectory", "findOrCreateDirectory", "findOrCreateFile", "findPsiFile", "Lksp/com/intellij/psi/PsiFile;", "project", "Lksp/com/intellij/openapi/project/Project;", "getCachedValue", "T", "", "key", "Lksp/com/intellij/openapi/util/Key;", "Lksp/com/intellij/openapi/vfs/VirtualFileCachedValue;", "useSoftCache", "canCache", "Lkotlin/Function1;", "provider", "Lkotlin/Function2;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/util/Key;ZLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "getResolvedVirtualFile", "getChild", "Lkotlin/Function3;", "Lkotlin/ExtensionFunctionType;", "readBytes", "", "readText", "refreshAndFindVirtualDirectory", "Ljava/nio/file/Path;", "refreshAndFindVirtualFile", "refreshAndFindVirtualFileOrDirectory", "relativizeToClosestAncestor", "Lkotlin/Pair;", "resolveFromRootOrRelative", "absoluteOrRelativeFilePath", "toNioPathOrNull", "validOrNull", "writeBytes", "", "content", "writeText", "intellij.platform.core"})
@JvmName(name="VirtualFileUtil")
@SourceDebugExtension(value={"SMAP\nVirtualFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileUtil.kt\ncom/intellij/openapi/vfs/VirtualFileUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,277:1\n88#1,4:283\n92#1,12:291\n88#1,4:303\n92#1,12:311\n88#1,4:323\n92#1,12:331\n1#2:278\n1549#3:279\n1620#3,3:280\n1549#3:287\n1620#3,3:288\n1549#3:307\n1620#3,3:308\n1549#3:327\n1620#3,3:328\n9#4:343\n*S KotlinDebug\n*F\n+ 1 VirtualFileUtil.kt\ncom/intellij/openapi/vfs/VirtualFileUtil\n*L\n108#1:283,4\n108#1:291,12\n141#1:303,4\n141#1:311,12\n159#1:323,4\n159#1:331,12\n91#1:279\n91#1:280,3\n108#1:287\n108#1:288,3\n141#1:307\n141#1:308,3\n159#1:327\n159#1:328,3\n223#1:343\n*E\n"})
public final class VirtualFileUtil {
    @Nullable
    public static final VirtualFile validOrNull(@NotNull VirtualFile $this$validOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$validOrNull, (String)"<this>");
        return $this$validOrNull.isValid() ? $this$validOrNull : null;
    }

    public static final boolean isFile(@NotNull VirtualFile $this$isFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isFile, (String)"<this>");
        return $this$isFile.isValid() && !$this$isFile.isDirectory();
    }

    @NotNull
    public static final String readText(@NotNull VirtualFile $this$readText) {
        Intrinsics.checkNotNullParameter((Object)$this$readText, (String)"<this>");
        String string2 = VfsUtilCore.loadText($this$readText);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"loadText(...)");
        return string2;
    }

    @RequiresWriteLock
    public static final void writeText(@NotNull VirtualFile $this$writeText, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)$this$writeText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        VfsUtilCore.saveText($this$writeText, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] readBytes(@NotNull VirtualFile $this$readBytes) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$readBytes, (String)"<this>");
        Closeable closeable = $this$readBytes.getInputStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            byArray = ByteStreamsKt.readBytes((InputStream)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    @RequiresWriteLock
    public static final void writeBytes(@NotNull VirtualFile $this$writeBytes, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)$this$writeBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        $this$writeBytes.setBinaryContent(content);
    }

    @Nullable
    public static final Path toNioPathOrNull(@NotNull VirtualFile $this$toNioPathOrNull) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toNioPathOrNull, (String)"<this>");
        Object object2 = $this$toNioPathOrNull;
        try {
            VirtualFile $this$toNioPathOrNull_u24lambda_u241 = object2;
            boolean bl2 = false;
            object = Result.constructor-impl((Object)$this$toNioPathOrNull_u24lambda_u241.toNioPath());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Path)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @RequiresReadLock
    @Nullable
    public static final Document findDocument(@NotNull VirtualFile $this$findDocument) {
        Intrinsics.checkNotNullParameter((Object)$this$findDocument, (String)"<this>");
        return FileDocumentManager.getInstance().getDocument($this$findDocument);
    }

    @RequiresReadLock
    @Nullable
    public static final PsiFile findPsiFile(@NotNull VirtualFile $this$findPsiFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$findPsiFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return PsiManager.getInstance(project).findFile($this$findPsiFile);
    }

    private static final Pair<VirtualFile, Path> relativizeToClosestAncestor(VirtualFile $this$relativizeToClosestAncestor, String relativePath) {
        Path basePath = Paths.get($this$relativizeToClosestAncestor.getPath(), new String[0]);
        Intrinsics.checkNotNull((Object)basePath);
        Pair<Path, Path> pair = NioPathUtil.relativizeToClosestAncestor(basePath, relativePath);
        Path normalizedBasePath = (Path)pair.component1();
        Path normalizedRelativePath = (Path)pair.component2();
        Ref.ObjectRef baseVirtualFile = new Ref.ObjectRef();
        baseVirtualFile.element = $this$relativizeToClosestAncestor;
        int n2 = basePath.getNameCount() - normalizedBasePath.getNameCount();
        int n3 = 0;
        while (n3 < n2) {
            int it = n3++;
            boolean bl2 = false;
            if (((VirtualFile)baseVirtualFile.element).getParent() == null) {
                Object cfr_ignored_0 = baseVirtualFile.element;
                Ref.ObjectRef objectRef = baseVirtualFile;
                boolean bl3 = false;
                Ref.ObjectRef objectRef2 = objectRef;
                String string2 = StringsKt.trimMargin$default((String)("\n        |Cannot resolve base virtual file for " + baseVirtualFile.element + "\n        |  basePath = " + $this$relativizeToClosestAncestor.getPath() + "\n        |  relativePath = " + relativePath + "\n      "), null, (int)1, null);
                throw new IllegalStateException(string2.toString());
            }
            baseVirtualFile.element = baseVirtualFile.element;
        }
        return TuplesKt.to((Object)baseVirtualFile.element, (Object)normalizedRelativePath);
    }

    /*
     * WARNING - void declaration
     */
    private static final VirtualFile getResolvedVirtualFile(VirtualFile $this$getResolvedVirtualFile, String relativePath, Function3<? super VirtualFile, ? super String, ? super Boolean, ? extends VirtualFile> getChild) {
        boolean $i$f$getResolvedVirtualFile = false;
        Pair<VirtualFile, Path> pair = VirtualFileUtil.relativizeToClosestAncestor($this$getResolvedVirtualFile, relativePath);
        VirtualFile baseVirtualFile = (VirtualFile)pair.component1();
        Path normalizedRelativePath = (Path)pair.component2();
        VirtualFile virtualFile = baseVirtualFile;
        if (((CharSequence)((Object)normalizedRelativePath).toString()).length() > 0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = normalizedRelativePath;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(it.toString());
            }
            List names = (List)destination$iv$iv;
            Iterator iterator2 = names.iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                int i2 = n2++;
                String name2 = (String)iterator2.next();
                if (!virtualFile.isDirectory()) {
                    throw new IOException(StringsKt.trimMargin$default((String)("\n          |Expected directory instead of file: " + virtualFile + "\n          |  basePath = " + $this$getResolvedVirtualFile.getPath() + "\n          |  relativePath = " + relativePath + "\n        "), null, (int)1, null));
                }
                virtualFile = (VirtualFile)getChild.invoke((Object)virtualFile, (Object)name2, (Object)(i2 == CollectionsKt.getLastIndex((List)names) ? 1 : 0));
            }
        }
        return virtualFile;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @Nullable
    public static final VirtualFile findFileOrDirectory(@NotNull VirtualFile $this$findFileOrDirectory, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$findFileOrDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile $this$getResolvedVirtualFile$iv = $this$findFileOrDirectory;
        boolean $i$f$getResolvedVirtualFile = false;
        Pair<VirtualFile, Path> pair = VirtualFileUtil.relativizeToClosestAncestor($this$getResolvedVirtualFile$iv, relativePath);
        VirtualFile baseVirtualFile$iv = (VirtualFile)pair.component1();
        Path normalizedRelativePath$iv = (Path)pair.component2();
        VirtualFile virtualFile$iv = baseVirtualFile$iv;
        if (((CharSequence)((Object)normalizedRelativePath$iv).toString()).length() > 0) {
            void $this$mapTo$iv$iv$iv;
            Iterable $this$map$iv$iv = normalizedRelativePath$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void it$iv;
                Path path = (Path)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it$iv);
                collection.add(it$iv.toString());
            }
            List names$iv = (List)destination$iv$iv$iv;
            Iterator iterator2 = names$iv.iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                void name2;
                VirtualFile virtualFile;
                int i$iv = n2++;
                String name$iv = (String)iterator2.next();
                if (!virtualFile$iv.isDirectory()) {
                    throw new IOException(StringsKt.trimMargin$default((String)("\n          |Expected directory instead of file: " + virtualFile$iv + "\n          |  basePath = " + $this$getResolvedVirtualFile$iv.getPath() + "\n          |  relativePath = " + relativePath + "\n        "), null, (int)1, null));
                }
                if (i$iv == CollectionsKt.getLastIndex((List)names$iv)) {
                    // empty if block
                }
                String string2 = name$iv;
                VirtualFile $this$findFileOrDirectory_u24lambda_u245 = virtualFile$iv;
                boolean bl3 = false;
                VirtualFile virtualFile2 = virtualFile = $this$findFileOrDirectory_u24lambda_u245.findChild((String)name2);
                if (virtualFile2 == null) {
                    return null;
                }
                Intrinsics.checkNotNull((Object)virtualFile2);
                virtualFile$iv = virtualFile;
            }
        }
        return virtualFile$iv;
    }

    @RequiresReadLock
    @Nullable
    public static final VirtualFile findFile(@NotNull VirtualFile $this$findFile, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$findFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile virtualFile = VirtualFileUtil.findFileOrDirectory($this$findFile, relativePath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file2 = virtualFile;
        if (!VirtualFileUtil.isFile(file2)) {
            throw new IOException(StringsKt.trimMargin$default((String)("\n      |Expected file instead of directory: " + file2 + "\n      |  basePath = " + $this$findFile.getPath() + "\n      |  relativePath = " + relativePath + "\n    "), null, (int)1, null));
        }
        return file2;
    }

    @RequiresReadLock
    @Nullable
    public static final VirtualFile findDirectory(@NotNull VirtualFile $this$findDirectory, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$findDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile virtualFile = VirtualFileUtil.findFileOrDirectory($this$findDirectory, relativePath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile directory = virtualFile;
        if (!directory.isDirectory()) {
            throw new IOException(StringsKt.trimMargin$default((String)("\n      |Expected directory instead of file: " + directory + "\n      |  basePath = " + $this$findDirectory.getPath() + "\n      |  relativePath = " + relativePath + "\n    "), null, (int)1, null));
        }
        return directory;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresWriteLock
    @NotNull
    public static final VirtualFile findOrCreateFile(@NotNull VirtualFile $this$findOrCreateFile, @NotNull String relativePath) {
        VirtualFile file2;
        Intrinsics.checkNotNullParameter((Object)$this$findOrCreateFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile $this$getResolvedVirtualFile$iv = $this$findOrCreateFile;
        boolean $i$f$getResolvedVirtualFile = false;
        Pair<VirtualFile, Path> pair = VirtualFileUtil.relativizeToClosestAncestor($this$getResolvedVirtualFile$iv, relativePath);
        VirtualFile baseVirtualFile$iv = (VirtualFile)pair.component1();
        Path normalizedRelativePath$iv = (Path)pair.component2();
        VirtualFile virtualFile$iv = baseVirtualFile$iv;
        if (((CharSequence)((Object)normalizedRelativePath$iv).toString()).length() > 0) {
            void $this$mapTo$iv$iv$iv;
            Iterable $this$map$iv$iv = normalizedRelativePath$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void it$iv;
                Path path = (Path)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it$iv);
                collection.add(it$iv.toString());
            }
            List names$iv = (List)destination$iv$iv$iv;
            Iterator iterator2 = names$iv.iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                VirtualFile virtualFile;
                void name2;
                VirtualFile virtualFile2;
                int i$iv = n2++;
                String name$iv = (String)iterator2.next();
                if (!virtualFile$iv.isDirectory()) {
                    throw new IOException(StringsKt.trimMargin$default((String)("\n          |Expected directory instead of file: " + virtualFile$iv + "\n          |  basePath = " + $this$getResolvedVirtualFile$iv.getPath() + "\n          |  relativePath = " + relativePath + "\n        "), null, (int)1, null));
                }
                boolean bl3 = i$iv == CollectionsKt.getLastIndex((List)names$iv);
                String string2 = name$iv;
                VirtualFile $this$findOrCreateFile_u24lambda_u246 = virtualFile$iv;
                boolean bl4 = false;
                VirtualFile virtualFile3 = virtualFile2 = $this$findOrCreateFile_u24lambda_u246.findChild((String)name2);
                if (virtualFile3 == null) {
                    void isLast;
                    VirtualFile virtualFile4 = isLast == true ? $this$findOrCreateFile_u24lambda_u246.createChildData($this$findOrCreateFile_u24lambda_u246.getFileSystem(), (String)name2) : $this$findOrCreateFile_u24lambda_u246.createChildDirectory($this$findOrCreateFile_u24lambda_u246.getFileSystem(), (String)name2);
                    Intrinsics.checkNotNull((Object)virtualFile4);
                    virtualFile = virtualFile4;
                } else {
                    Intrinsics.checkNotNull((Object)virtualFile3);
                    virtualFile = virtualFile2;
                }
                virtualFile$iv = virtualFile;
            }
        }
        if (!VirtualFileUtil.isFile(file2 = virtualFile$iv)) {
            throw new IOException(StringsKt.trimMargin$default((String)("\n      |Expected file instead of directory: " + file2 + "\n      |  basePath = " + $this$findOrCreateFile.getPath() + "\n      |  relativePath = " + relativePath + "\n    "), null, (int)1, null));
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresWriteLock
    @NotNull
    public static final VirtualFile findOrCreateDirectory(@NotNull VirtualFile $this$findOrCreateDirectory, @NotNull String relativePath) {
        VirtualFile directory;
        Intrinsics.checkNotNullParameter((Object)$this$findOrCreateDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile $this$getResolvedVirtualFile$iv = $this$findOrCreateDirectory;
        boolean $i$f$getResolvedVirtualFile = false;
        Pair<VirtualFile, Path> pair = VirtualFileUtil.relativizeToClosestAncestor($this$getResolvedVirtualFile$iv, relativePath);
        VirtualFile baseVirtualFile$iv = (VirtualFile)pair.component1();
        Path normalizedRelativePath$iv = (Path)pair.component2();
        VirtualFile virtualFile$iv = baseVirtualFile$iv;
        if (((CharSequence)((Object)normalizedRelativePath$iv).toString()).length() > 0) {
            void $this$mapTo$iv$iv$iv;
            Iterable $this$map$iv$iv = normalizedRelativePath$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void it$iv;
                Path path = (Path)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it$iv);
                collection.add(it$iv.toString());
            }
            List names$iv = (List)destination$iv$iv$iv;
            Iterator iterator2 = names$iv.iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                VirtualFile virtualFile;
                void name2;
                VirtualFile virtualFile2;
                int i$iv = n2++;
                String name$iv = (String)iterator2.next();
                if (!virtualFile$iv.isDirectory()) {
                    throw new IOException(StringsKt.trimMargin$default((String)("\n          |Expected directory instead of file: " + virtualFile$iv + "\n          |  basePath = " + $this$getResolvedVirtualFile$iv.getPath() + "\n          |  relativePath = " + relativePath + "\n        "), null, (int)1, null));
                }
                if (i$iv == CollectionsKt.getLastIndex((List)names$iv)) {
                    // empty if block
                }
                String string2 = name$iv;
                VirtualFile $this$findOrCreateDirectory_u24lambda_u247 = virtualFile$iv;
                boolean bl3 = false;
                VirtualFile virtualFile3 = virtualFile2 = $this$findOrCreateDirectory_u24lambda_u247.findChild((String)name2);
                if (virtualFile3 == null) {
                    VirtualFile virtualFile4 = $this$findOrCreateDirectory_u24lambda_u247.createChildDirectory($this$findOrCreateDirectory_u24lambda_u247.getFileSystem(), (String)name2);
                    virtualFile = virtualFile4;
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"createChildDirectory(...)");
                } else {
                    Intrinsics.checkNotNull((Object)virtualFile3);
                    virtualFile = virtualFile2;
                }
                virtualFile$iv = virtualFile;
            }
        }
        if (!(directory = virtualFile$iv).isDirectory()) {
            throw new IOException(StringsKt.trimMargin$default((String)("\n      |Expected directory instead of file: " + directory + "\n      |  basePath = " + $this$findOrCreateDirectory.getPath() + "\n      |  relativePath = " + relativePath + "\n    "), null, (int)1, null));
        }
        return directory;
    }

    @Nullable
    public static final VirtualFile refreshAndFindVirtualFileOrDirectory(@NotNull Path $this$refreshAndFindVirtualFileOrDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$refreshAndFindVirtualFileOrDirectory, (String)"<this>");
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
        VirtualFileManager fileManager = virtualFileManager;
        return fileManager.refreshAndFindFileByNioPath($this$refreshAndFindVirtualFileOrDirectory);
    }

    @Nullable
    public static final VirtualFile refreshAndFindVirtualFile(@NotNull Path $this$refreshAndFindVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$refreshAndFindVirtualFile, (String)"<this>");
        VirtualFile virtualFile = VirtualFileUtil.refreshAndFindVirtualFileOrDirectory($this$refreshAndFindVirtualFile);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file2 = virtualFile;
        if (!VirtualFileUtil.isFile(file2)) {
            throw new IOException("Expected file instead of directory: " + $this$refreshAndFindVirtualFile);
        }
        return file2;
    }

    @Nullable
    public static final VirtualFile refreshAndFindVirtualDirectory(@NotNull Path $this$refreshAndFindVirtualDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$refreshAndFindVirtualDirectory, (String)"<this>");
        VirtualFile virtualFile = VirtualFileUtil.refreshAndFindVirtualFileOrDirectory($this$refreshAndFindVirtualDirectory);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file2 = virtualFile;
        if (!file2.isDirectory()) {
            throw new IOException("Expected directory instead of file: " + $this$refreshAndFindVirtualDirectory);
        }
        return file2;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static final VirtualFile resolveFromRootOrRelative(@NotNull VirtualFile $this$resolveFromRootOrRelative, @NotNull String absoluteOrRelativeFilePath) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveFromRootOrRelative, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)absoluteOrRelativeFilePath, (String)"absoluteOrRelativeFilePath");
        VirtualFile virtualFile = $this$resolveFromRootOrRelative.getFileSystem().findFileByPath(absoluteOrRelativeFilePath);
        if (virtualFile == null) {
            virtualFile = $this$resolveFromRootOrRelative.findFileByRelativePath(absoluteOrRelativeFilePath);
        }
        return virtualFile;
    }

    @ApiStatus.Experimental
    @NotNull
    public static final <T> T getCachedValue(@NotNull VirtualFile $this$getCachedValue, @NotNull Key<VirtualFileCachedValue<T>> key, boolean useSoftCache, @Nullable Function1<? super VirtualFile, Boolean> canCache, @NotNull Function2<? super VirtualFile, ? super CharSequence, ? extends T> provider2) {
        Object data;
        Intrinsics.checkNotNullParameter((Object)$this$getCachedValue, (String)"<this>");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(provider2, (String)"provider");
        if (!$this$getCachedValue.isValid() && ApplicationManager.getApplication().isReadAccessAllowed()) {
            VirtualFile $this$thisLogger$iv = $this$getCachedValue;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(VirtualFile.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error(new InvalidVirtualFileAccessException($this$getCachedValue));
            return (T)provider2.invoke((Object)$this$getCachedValue, null);
        }
        ProgressManager.checkCanceled();
        Document document = FileDocumentManager.getInstance().getCachedDocument($this$getCachedValue);
        VirtualFileCachedValue<T> cached = key.get($this$getCachedValue);
        Document document2 = document;
        long documentModificationStamp = document2 != null ? document2.getModificationStamp() : -1L;
        VirtualFileCachedValue<T> virtualFileCachedValue = cached;
        Object object = data = virtualFileCachedValue != null ? virtualFileCachedValue.getData$intellij_platform_core() : null;
        if (cached == null || data == null || cached.getDocumentModificationStamp$intellij_platform_core() != documentModificationStamp || cached.getFileModificationStamp$intellij_platform_core() != $this$getCachedValue.getModificationStamp()) {
            CharSequence text = VirtualFileUtil.loadText($this$getCachedValue, document);
            data = provider2.invoke((Object)$this$getCachedValue, (Object)text);
            cached = new VirtualFileCachedValue<T>(data, useSoftCache, $this$getCachedValue.getModificationStamp(), documentModificationStamp);
            Function1<? super VirtualFile, Boolean> function1 = canCache;
            if (!(function1 != null ? !((Boolean)function1.invoke((Object)$this$getCachedValue)).booleanValue() : false)) {
                key.set($this$getCachedValue, cached);
            }
        }
        return data;
    }

    public static /* synthetic */ Object getCachedValue$default(VirtualFile virtualFile, Key key, boolean bl2, Function1 function1, Function2 function2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        if ((n2 & 4) != 0) {
            function1 = null;
        }
        return VirtualFileUtil.getCachedValue(virtualFile, key, bl2, (Function1<? super VirtualFile, Boolean>)function1, function2);
    }

    private static final CharSequence loadText(VirtualFile packageJsonFile, Document packageJsonDocument) {
        CharSequence charSequence;
        if (packageJsonDocument != null) {
            return packageJsonDocument.getImmutableCharSequence();
        }
        try {
            charSequence = VfsUtilCore.loadText(packageJsonFile);
        }
        catch (IOException e2) {
            charSequence = null;
        }
        return charSequence;
    }
}

