/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir.interpreter.state.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import ksp.org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import ksp.org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KClassProxy;
import ksp.org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KTypeParameterProxy;
import ksp.org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KTypeProxy;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.reflection.KClassState;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeParameterState;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.reflection.ReflectionState;
import ksp.org.jetbrains.kotlin.ir.types.IrSimpleType;
import ksp.org.jetbrains.kotlin.ir.types.IrStarProjection;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeArgument;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeProjection;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0017H\u0002J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lksp/org/jetbrains/kotlin/ir/interpreter/state/reflection/KTypeState;", "Lksp/org/jetbrains/kotlin/ir/interpreter/state/reflection/ReflectionState;", "irType", "Lksp/org/jetbrains/kotlin/ir/types/IrType;", "irClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "<init>", "(Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "getIrType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "_classifier", "Lkotlin/reflect/KClassifier;", "_arguments", "", "Lkotlin/reflect/KTypeProjection;", "getClassifier", "callInterceptor", "Lksp/org/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "getArguments", "getVariance", "Lksp/org/jetbrains/kotlin/types/Variance;", "Lksp/org/jetbrains/kotlin/ir/types/IrTypeArgument;", "equals", "", "other", "", "hashCode", "", "toString", "", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nKTypeState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KTypeState.kt\norg/jetbrains/kotlin/ir/interpreter/state/reflection/KTypeState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1563#2:79\n1634#2,3:80\n*S KotlinDebug\n*F\n+ 1 KTypeState.kt\norg/jetbrains/kotlin/ir/interpreter/state/reflection/KTypeState\n*L\n40#1:79\n40#1:80,3\n*E\n"})
public final class KTypeState
extends ReflectionState {
    @NotNull
    private final IrType irType;
    @NotNull
    private final IrClass irClass;
    @Nullable
    private KClassifier _classifier;
    @Nullable
    private List<KTypeProjection> _arguments;

    public KTypeState(@NotNull IrType irType, @NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        this.irType = irType;
        this.irClass = irClass;
    }

    @NotNull
    public final IrType getIrType() {
        return this.irType;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Nullable
    public final KClassifier getClassifier(@NotNull CallInterceptor callInterceptor) {
        KClassifier kClassifier;
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        if (this._classifier != null) {
            KClassifier kClassifier2 = this._classifier;
            Intrinsics.checkNotNull((Object)kClassifier2);
            return kClassifier2;
        }
        IrSymbolOwner classifier = IrTypesKt.getClassifierOrFail(this.irType).getOwner();
        if (classifier instanceof IrClass) {
            kClassifier = (KClassifier)new KClassProxy(new KClassState((IrClass)classifier, (IrClass)callInterceptor.getIrBuiltIns().getKClassClass().getOwner()), callInterceptor);
        } else if (classifier instanceof IrTypeParameter) {
            IrClass kTypeParameterIrClass = (IrClass)callInterceptor.getEnvironment().getKTypeParameterClass$ir_interpreter().getOwner();
            kClassifier = (KClassifier)new KTypeParameterProxy(new KTypeParameterState((IrTypeParameter)classifier, kTypeParameterIrClass), callInterceptor);
        } else {
            throw new NotImplementedError(null, 1, null);
        }
        KClassifier kClassifier3 = this._classifier = kClassifier;
        Intrinsics.checkNotNull((Object)kClassifier3);
        return kClassifier3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KTypeProjection> getArguments(@NotNull CallInterceptor callInterceptor) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        if (this._arguments != null) {
            List<KTypeProjection> list = this._arguments;
            Intrinsics.checkNotNull(list);
            return list;
        }
        Object object = callInterceptor.getEnvironment().getJavaClassToIrClass$ir_interpreter();
        Pair pair = TuplesKt.to(KTypeProjection.class, (Object)callInterceptor.getEnvironment().getKTypeProjectionClass$ir_interpreter().getOwner());
        object.put(pair.getFirst(), (IrClass)pair.getSecond());
        IrType irType = this.irType;
        Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        object = ((IrSimpleType)irType).getArguments();
        KTypeState kTypeState = this;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KTypeProjection kTypeProjection;
            void it;
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Variance variance2 = this.getVariance((IrTypeArgument)it);
            switch (variance2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[variance2.ordinal()]) {
                case 1: {
                    IrType irType2 = IrTypesKt.getTypeOrNull((IrTypeArgument)it);
                    Intrinsics.checkNotNull((Object)irType2);
                    kTypeProjection = KTypeProjection.Companion.invariant((KType)new KTypeProxy(new KTypeState(irType2, this.getIrClass()), callInterceptor));
                    break;
                }
                case 2: {
                    IrType irType3 = IrTypesKt.getTypeOrNull((IrTypeArgument)it);
                    Intrinsics.checkNotNull((Object)irType3);
                    kTypeProjection = KTypeProjection.Companion.contravariant((KType)new KTypeProxy(new KTypeState(irType3, this.getIrClass()), callInterceptor));
                    break;
                }
                case 3: {
                    IrType irType4 = IrTypesKt.getTypeOrNull((IrTypeArgument)it);
                    Intrinsics.checkNotNull((Object)irType4);
                    kTypeProjection = KTypeProjection.Companion.covariant((KType)new KTypeProxy(new KTypeState(irType4, this.getIrClass()), callInterceptor));
                    break;
                }
                case -1: {
                    kTypeProjection = KTypeProjection.Companion.getSTAR();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            collection.add(kTypeProjection);
        }
        kTypeState._arguments = (List)destination$iv$iv;
        List<KTypeProjection> list = this._arguments;
        Intrinsics.checkNotNull(list);
        return list;
    }

    private final Variance getVariance(IrTypeArgument $this$getVariance) {
        Variance variance2;
        IrTypeArgument irTypeArgument = $this$getVariance;
        if (irTypeArgument instanceof IrSimpleType) {
            variance2 = Variance.INVARIANT;
        } else if (irTypeArgument instanceof IrTypeProjection) {
            variance2 = ((IrTypeProjection)$this$getVariance).getVariance();
        } else if (irTypeArgument instanceof IrStarProjection) {
            variance2 = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return variance2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState");
        KTypeState cfr_ignored_0 = (KTypeState)other;
        return Intrinsics.areEqual((Object)this.irType, (Object)((KTypeState)other).irType);
    }

    public int hashCode() {
        return this.irType.hashCode();
    }

    @NotNull
    public String toString() {
        return this.renderType(this.irType);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Variance.values().length];
            try {
                nArray[Variance.INVARIANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

