/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirContextReceiversDeclarationCheckerKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirFunctionParameterChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameterKindKt;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\u0002H\u0002\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextReceiversDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isDelegationOperator", "", "Lksp/org/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "getContextParameters", "", "Lksp/org/jetbrains/kotlin/fir/declarations/FirValueParameter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContextReceiversDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContextReceiversDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextReceiversDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,172:1\n1563#2:173\n1634#2,3:174\n1869#2,2:177\n38#3:179\n*S KotlinDebug\n*F\n+ 1 FirContextReceiversDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextReceiversDeclarationChecker\n*L\n64#1:173\n64#1:174,3\n104#1:177,2\n126#1:179\n*E\n"})
public final class FirContextReceiversDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirContextReceiversDeclarationChecker INSTANCE = new FirContextReceiversDeclarationChecker();

    private FirContextReceiversDeclarationChecker() {
        super(MppCheckerKind.Platform);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        List<FirValueParameter> contextParameters;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = declaration2.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        KtSourceElement ktSourceElement2 = declaration2.getSource();
        if (ktSourceElement2 == null || (ktSourceElement2 = SourceHelpersKt.findContextReceiverListSource(ktSourceElement2)) == null) {
            return;
        }
        KtSourceElement source = ktSourceElement2;
        if (declaration2 instanceof FirTypeAlias) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Context parameters on type aliases are unsupported.", (DiagnosticContext)context2, null, 16, null);
        }
        if (declaration2 instanceof FirAnonymousInitializer) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Context parameters on initializers are unsupported.", (DiagnosticContext)context2, null, 16, null);
        }
        if ((contextParameters = this.getContextParameters(declaration2)).isEmpty()) {
            return;
        }
        boolean contextReceiversEnabled = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ContextReceivers);
        boolean contextParametersEnabled = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ContextParameters);
        if (!contextReceiversEnabled && !contextParametersEnabled) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)((Object)LanguageFeature.ContextParameters), (Object)context2.getLanguageVersionSettings()), (DiagnosticContext)context2, null, 16, null);
            return;
        }
        if (contextReceiversEnabled) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = contextParameters;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(FirTypeUtilsKt.getConeType(it.getReturnTypeRef()));
            }
            if (FirContextReceiversDeclarationCheckerKt.checkSubTypes((List)destination$iv$iv, context2)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getSUBTYPING_BETWEEN_CONTEXT_RECEIVERS(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        if (contextParametersEnabled) {
            FirDeclaration firDeclaration = declaration2;
            if (firDeclaration instanceof FirClass) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Context parameters on classes are unsupported.", (DiagnosticContext)context2, null, 16, null);
            } else if (firDeclaration instanceof FirConstructor) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Context parameters on constructors are unsupported.", (DiagnosticContext)context2, null, 16, null);
            } else if (firDeclaration instanceof FirCallableDeclaration && this.isDelegationOperator((FirCallableDeclaration)declaration2)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Context parameters on delegation operators are unsupported.", (DiagnosticContext)context2, null, 16, null);
            } else if (firDeclaration instanceof FirProperty && ((FirProperty)declaration2).getDelegate() != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Context parameters on delegated properties are unsupported.", (DiagnosticContext)context2, null, 16, null);
            } else {
                for (FirValueParameter parameter2 : contextParameters) {
                    List<FirModifier<?>> list;
                    if (FirValueParameterKindKt.isLegacyContextReceiver(parameter2)) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter2.getSource(), FirErrors.INSTANCE.getCONTEXT_PARAMETER_WITHOUT_NAME(), (DiagnosticContext)context2, null, 8, null);
                    }
                    if ((list = parameter2.getSource()) != null && (list = FirKeywordUtilsKt.getModifierList((KtSourceElement)((Object)list))) != null && (list = ((FirModifierList)((Object)list)).getModifiers()) != null) {
                        Iterable $this$forEach$iv = list;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            FirModifier modifier = (FirModifier)element$iv;
                            boolean bl3 = false;
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)modifier.getSource(), FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET(), (Object)modifier.getToken(), (Object)"context parameter", (DiagnosticContext)context2, null, 32, null);
                        }
                    }
                    FirFunctionParameterChecker.INSTANCE.checkValOrVar$checkers(parameter2, reporter, context2);
                }
            }
        } else {
            for (FirValueParameter parameter3 : contextParameters) {
                if (FirValueParameterKindKt.isLegacyContextReceiver(parameter3)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter3.getSource(), FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)((Object)LanguageFeature.ContextParameters), (Object)context2.getLanguageVersionSettings()), (DiagnosticContext)context2, null, 16, null);
            }
        }
    }

    private final boolean isDelegationOperator(FirCallableDeclaration $this$isDelegationOperator) {
        FirMemberDeclaration $this$isOperator$iv = $this$isDelegationOperator;
        boolean $i$f$isOperator = false;
        return $this$isOperator$iv.getStatus().isOperator() && OperatorNameConventions.DELEGATED_PROPERTY_OPERATORS.contains(FirDeclarationUtilKt.getNameOrSpecialName($this$isDelegationOperator));
    }

    private final List<FirValueParameter> getContextParameters(FirDeclaration $this$getContextParameters) {
        FirDeclaration firDeclaration = $this$getContextParameters;
        return firDeclaration instanceof FirCallableDeclaration ? ((FirCallableDeclaration)$this$getContextParameters).getContextParameters() : (firDeclaration instanceof FirRegularClass ? ((FirRegularClass)$this$getContextParameters).getContextParameters() : CollectionsKt.emptyList());
    }
}

