/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.java.stubs;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.LighterAST;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiNameHelper;
import ksp.com.intellij.psi.impl.cache.ModifierFlags;
import ksp.com.intellij.psi.impl.cache.RecordUtil;
import ksp.com.intellij.psi.impl.cache.TypeInfo;
import ksp.com.intellij.psi.impl.java.stubs.JavaStubElementType;
import ksp.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import ksp.com.intellij.psi.impl.java.stubs.PsiMemberStub;
import ksp.com.intellij.psi.impl.java.stubs.PsiMethodStub;
import ksp.com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import ksp.com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import ksp.com.intellij.psi.impl.java.stubs.PsiParameterStub;
import ksp.com.intellij.psi.impl.java.stubs.PsiTypeParameterListStub;
import ksp.com.intellij.psi.impl.java.stubs.PsiTypeParameterStub;
import ksp.com.intellij.psi.impl.java.stubs.impl.PsiMethodStubImpl;
import ksp.com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import ksp.com.intellij.psi.impl.source.PsiAnnotationMethodImpl;
import ksp.com.intellij.psi.impl.source.PsiMethodImpl;
import ksp.com.intellij.psi.impl.source.tree.ElementType;
import ksp.com.intellij.psi.impl.source.tree.JavaDocElementType;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.com.intellij.psi.impl.source.tree.LightTreeUtil;
import ksp.com.intellij.psi.impl.source.tree.java.AnnotationMethodElement;
import ksp.com.intellij.psi.stubs.IndexSink;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.psi.stubs.StubInputStream;
import ksp.com.intellij.psi.stubs.StubOutputStream;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.util.TypeConversionUtil;
import ksp.com.intellij.util.BitUtil;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;

abstract class JavaMethodElementType
extends JavaStubElementType<PsiMethodStub, PsiMethod> {
    JavaMethodElementType(@NonNls String name2, @NotNull IElementType parentElementType) {
        if (parentElementType == null) {
            JavaMethodElementType.$$$reportNull$$$0(0);
        }
        super(name2, parentElementType);
    }

    @Override
    public PsiMethod createPsi(@NotNull PsiMethodStub stub2) {
        if (stub2 == null) {
            JavaMethodElementType.$$$reportNull$$$0(1);
        }
        return this.getPsiFactory(stub2).createMethod(stub2);
    }

    @Override
    public PsiMethod createPsi(@NotNull ASTNode node) {
        if (node == null) {
            JavaMethodElementType.$$$reportNull$$$0(2);
        }
        if (node instanceof AnnotationMethodElement) {
            return new PsiAnnotationMethodImpl(node);
        }
        return new PsiMethodImpl(node);
    }

    @Override
    @NotNull
    public PsiMethodStub createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement<?> parentStub) {
        if (tree == null) {
            JavaMethodElementType.$$$reportNull$$$0(3);
        }
        if (node == null) {
            JavaMethodElementType.$$$reportNull$$$0(4);
        }
        if (parentStub == null) {
            JavaMethodElementType.$$$reportNull$$$0(5);
        }
        String name2 = null;
        boolean isConstructor = true;
        boolean isVarArgs = false;
        boolean isDeprecatedByComment = false;
        boolean hasDeprecatedAnnotation = false;
        boolean hasDocComment = false;
        String defValueText = null;
        boolean expectingDef = false;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type2 = child.getTokenType();
            if (type2 == JavaDocElementType.DOC_COMMENT) {
                hasDocComment = true;
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment(tree, child);
                continue;
            }
            if (type2 == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation(tree, child);
                continue;
            }
            if (type2 == JavaElementType.TYPE) {
                isConstructor = false;
                continue;
            }
            if (type2 == JavaTokenType.IDENTIFIER) {
                name2 = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (type2 == JavaElementType.PARAMETER_LIST) {
                LighterASTNode pType;
                List<LighterASTNode> params = LightTreeUtil.getChildrenOfType(tree, child, JavaElementType.PARAMETER);
                if (params.isEmpty() || (pType = LightTreeUtil.firstChildOfType(tree, params.get(params.size() - 1), JavaElementType.TYPE)) == null) continue;
                isVarArgs = LightTreeUtil.firstChildOfType(tree, pType, JavaTokenType.ELLIPSIS) != null;
                continue;
            }
            if (type2 == JavaTokenType.DEFAULT_KEYWORD) {
                expectingDef = true;
                continue;
            }
            if (!expectingDef || ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(type2) || type2 == JavaTokenType.SEMICOLON || type2 == JavaElementType.CODE_BLOCK) continue;
            defValueText = LightTreeUtil.toFilteredString(tree, child, null);
            break;
        }
        TypeInfo typeInfo = isConstructor ? TypeInfo.createConstructorType() : TypeInfo.create(tree, node, parentStub);
        boolean isAnno = node.getTokenType() == JavaElementType.ANNOTATION_METHOD;
        byte flags = PsiMethodStubImpl.packFlags(isConstructor, isAnno, isVarArgs, isDeprecatedByComment, hasDeprecatedAnnotation, hasDocComment);
        return new PsiMethodStubImpl(parentStub, name2, typeInfo, flags, defValueText);
    }

    @Override
    public void serialize(@NotNull PsiMethodStub stub2, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub2 == null) {
            JavaMethodElementType.$$$reportNull$$$0(6);
        }
        if (dataStream == null) {
            JavaMethodElementType.$$$reportNull$$$0(7);
        }
        dataStream.writeName(stub2.getName());
        TypeInfo.writeTYPE(dataStream, stub2.getReturnTypeText());
        dataStream.writeByte(((PsiMethodStubImpl)stub2).getFlags());
        if (stub2.isAnnotationMethod()) {
            dataStream.writeName(stub2.getDefaultValueText());
        }
    }

    @Override
    @NotNull
    public PsiMethodStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JavaMethodElementType.$$$reportNull$$$0(8);
        }
        String name2 = dataStream.readNameString();
        TypeInfo type2 = TypeInfo.readTYPE(dataStream);
        byte flags = dataStream.readByte();
        String defaultMethodValue = PsiMethodStubImpl.isAnnotationMethod(flags) ? dataStream.readNameString() : null;
        return new PsiMethodStubImpl(parentStub, name2, type2, flags, defaultMethodValue);
    }

    @Override
    public void indexStub(@NotNull PsiMethodStub stub2, @NotNull IndexSink sink) {
        String name2;
        if (stub2 == null) {
            JavaMethodElementType.$$$reportNull$$$0(9);
        }
        if (sink == null) {
            JavaMethodElementType.$$$reportNull$$$0(10);
        }
        if ((name2 = stub2.getName()) != null) {
            sink.occurrence(JavaStubIndexKeys.METHODS, name2);
            if (RecordUtil.isStaticNonPrivateMember(stub2)) {
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_NAMES, name2);
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_TYPES, stub2.getReturnTypeText().getShortTypeText());
            }
        }
        Set<String> methodTypeParams = JavaMethodElementType.getVisibleTypeParameters(stub2);
        for (StubElement stubElement : stub2.getChildrenStubs()) {
            if (!(stubElement instanceof PsiParameterListStub)) continue;
            for (StubElement paramStub : stubElement.getChildrenStubs()) {
                TypeInfo type2;
                String typeName;
                if (!(paramStub instanceof PsiParameterStub) || TypeConversionUtil.isPrimitive(typeName = PsiNameHelper.getShortClassName((type2 = ((PsiParameterStub)paramStub).getType()).text())) || TypeConversionUtil.isPrimitiveWrapper(typeName) || methodTypeParams.contains(typeName)) continue;
                sink.occurrence(JavaStubIndexKeys.METHOD_TYPES, typeName);
            }
        }
    }

    @NotNull
    private static Set<String> getVisibleTypeParameters(@NotNull StubElement<?> stub2) {
        if (stub2 == null) {
            JavaMethodElementType.$$$reportNull$$$0(11);
        }
        HashSet<String> result2 = null;
        while (stub2 != null) {
            Set<String> names = JavaMethodElementType.getOwnTypeParameterNames(stub2);
            if (!names.isEmpty()) {
                if (result2 == null) {
                    result2 = new HashSet<String>();
                }
                result2.addAll(names);
            }
            if (JavaMethodElementType.isStatic(stub2)) break;
            stub2 = stub2.getParentStub();
        }
        Set<String> set = result2 == null ? Collections.emptySet() : result2;
        if (set == null) {
            JavaMethodElementType.$$$reportNull$$$0(12);
        }
        return set;
    }

    private static boolean isStatic(@NotNull StubElement<?> stub2) {
        PsiModifierListStub modList;
        if (stub2 == null) {
            JavaMethodElementType.$$$reportNull$$$0(13);
        }
        if (stub2 instanceof PsiMemberStub && (modList = stub2.findChildStubByType(JavaStubElementTypes.MODIFIER_LIST)) != null) {
            return BitUtil.isSet(modList.getModifiersMask(), ModifierFlags.NAME_TO_MODIFIER_FLAG_MAP.getInt("static"));
        }
        return false;
    }

    private static Set<String> getOwnTypeParameterNames(StubElement<?> stubElement) {
        PsiTypeParameterListStub typeParamList = stubElement.findChildStubByType(JavaStubElementTypes.TYPE_PARAMETER_LIST);
        if (typeParamList == null) {
            return Collections.emptySet();
        }
        HashSet<String> methodTypeParams = null;
        for (StubElement tStub : typeParamList.getChildrenStubs()) {
            if (!(tStub instanceof PsiTypeParameterStub)) continue;
            if (methodTypeParams == null) {
                methodTypeParams = new HashSet<String>();
            }
            methodTypeParams.add(((PsiTypeParameterStub)tStub).getName());
        }
        return methodTypeParams == null ? Collections.emptySet() : methodTypeParams;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 12: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElementType";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/java/stubs/JavaMethodElementType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/java/stubs/JavaMethodElementType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleTypeParameters";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleTypeParameters";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isStatic";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

