/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi;

import java.util.Set;
import ksp.com.intellij.extapi.psi.StubBasedPsiElementBase;
import ksp.com.intellij.injected.editor.VirtualFileWindow;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.application.ReadAction;
import ksp.com.intellij.openapi.application.ex.ApplicationManagerEx;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.fileEditor.FileDocumentManager;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Comparing;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.FileViewProvider;
import ksp.com.intellij.psi.PsiCompiledElement;
import ksp.com.intellij.psi.PsiDirectory;
import ksp.com.intellij.psi.PsiDocumentManager;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiInvalidElementAccessException;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.StubBasedPsiElement;
import ksp.com.intellij.psi.WrappedElementAnchor;
import ksp.com.intellij.psi.impl.FreeThreadedFileViewProvider;
import ksp.com.intellij.psi.impl.smartPointers.Identikit;
import ksp.com.intellij.psi.impl.smartPointers.SelfElementInfo;
import ksp.com.intellij.psi.impl.smartPointers.SmartPointerAnchorProvider;
import ksp.com.intellij.psi.impl.source.PsiFileImpl;
import ksp.com.intellij.psi.impl.source.PsiFileWithStubSupport;
import ksp.com.intellij.psi.impl.source.StubbedSpine;
import ksp.com.intellij.psi.stubs.IStubElementType;
import ksp.com.intellij.psi.stubs.StubBase;
import ksp.com.intellij.psi.tree.IStubFileElementType;
import ksp.com.intellij.psi.util.PsiUtilCore;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public abstract class PsiAnchor {
    private static final Logger LOG = Logger.getInstance(PsiAnchor.class);

    @Nullable
    public abstract PsiElement retrieve();

    public abstract PsiFile getFile();

    public abstract int getStartOffset();

    public abstract int getEndOffset();

    @NotNull
    public static PsiAnchor create(@NotNull PsiElement element2) {
        PsiElement restored;
        if (element2 == null) {
            PsiAnchor.$$$reportNull$$$0(0);
        }
        PsiUtilCore.ensureValid(element2);
        PsiAnchor anchor = PsiAnchor.doCreateAnchor(element2);
        if (ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManagerEx.isInStressTest() && !element2.equals(restored = anchor.retrieve())) {
            LOG.error("Cannot restore element " + element2 + " of " + element2.getClass() + " from anchor " + anchor + ", getting " + restored + " instead");
        }
        PsiAnchor psiAnchor = anchor;
        if (psiAnchor == null) {
            PsiAnchor.$$$reportNull$$$0(1);
        }
        return psiAnchor;
    }

    @NotNull
    private static PsiAnchor doCreateAnchor(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiAnchor.$$$reportNull$$$0(2);
        }
        if (element2 instanceof PsiFile) {
            VirtualFile virtualFile = ((PsiFile)element2).getVirtualFile();
            if (virtualFile != null) {
                return new PsiFileReference(virtualFile, (PsiFile)element2);
            }
            return new HardReference(element2);
        }
        if (element2 instanceof PsiDirectory) {
            VirtualFile virtualFile = ((PsiDirectory)element2).getVirtualFile();
            return new PsiDirectoryReference(virtualFile, element2.getProject());
        }
        PsiFile file2 = element2.getContainingFile();
        if (file2 == null) {
            return new HardReference(element2);
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null || virtualFile instanceof VirtualFileWindow) {
            return new HardReference(element2);
        }
        StubIndexReference stubRef = PsiAnchor.createStubReference(element2, file2);
        if (stubRef != null) {
            StubIndexReference stubIndexReference = stubRef;
            if (stubIndexReference == null) {
                PsiAnchor.$$$reportNull$$$0(3);
            }
            return stubIndexReference;
        }
        if (!element2.isPhysical()) {
            return PsiAnchor.wrapperOrHardReference(element2);
        }
        TextRange textRange = element2.getTextRange();
        if (textRange == null) {
            return PsiAnchor.wrapperOrHardReference(element2);
        }
        Language lang = null;
        FileViewProvider viewProvider = file2.getViewProvider();
        for (Language l2 : viewProvider.getLanguages()) {
            if (viewProvider.getPsi(l2) != file2) continue;
            lang = l2;
            break;
        }
        if (lang == null) {
            return PsiAnchor.wrapperOrHardReference(element2);
        }
        return new TreeRangeReference(file2, textRange.getStartOffset(), textRange.getEndOffset(), Identikit.fromPsi(element2, lang), virtualFile);
    }

    @NotNull
    private static PsiAnchor wrapperOrHardReference(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiAnchor.$$$reportNull$$$0(4);
        }
        for (SmartPointerAnchorProvider provider2 : SmartPointerAnchorProvider.EP_NAME.getExtensionList()) {
            PsiAnchor wrappedAnchor;
            PsiElement anchorElement = provider2.getAnchor(element2);
            if (anchorElement == null || anchorElement == element2 || (wrappedAnchor = PsiAnchor.create(anchorElement)) instanceof HardReference) continue;
            return new WrappedElementAnchor(provider2, wrappedAnchor);
        }
        return new HardReference(element2);
    }

    @Nullable
    public static StubIndexReference createStubReference(@NotNull PsiElement element2, @NotNull PsiFile containingFile2) {
        if (element2 == null) {
            PsiAnchor.$$$reportNull$$$0(5);
        }
        if (containingFile2 == null) {
            PsiAnchor.$$$reportNull$$$0(6);
        }
        if (element2 instanceof StubBasedPsiElement && element2.isPhysical() && (element2 instanceof PsiCompiledElement || PsiAnchor.canHaveStub(containingFile2))) {
            int index2;
            StubBasedPsiElement elt = (StubBasedPsiElement)element2;
            IStubElementType elementType = elt.getElementType();
            if ((elt.getStub() != null || elementType.shouldCreateStub(element2.getNode())) && (index2 = PsiAnchor.calcStubIndex((StubBasedPsiElement)element2)) != -1) {
                return new StubIndexReference(containingFile2, index2, containingFile2.getLanguage(), elementType);
            }
        }
        return null;
    }

    private static boolean canHaveStub(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiAnchor.$$$reportNull$$$0(7);
        }
        if (!(file2 instanceof PsiFileImpl)) {
            return false;
        }
        VirtualFile vFile = file2.getVirtualFile();
        IStubFileElementType<?> elementType = ((PsiFileImpl)file2).getElementTypeForStubBuilder();
        return elementType != null && vFile != null && elementType.shouldBuildStubFor(vFile);
    }

    public static int calcStubIndex(@NotNull StubBasedPsiElement<?> psi) {
        Object liveStub;
        if (psi == null) {
            PsiAnchor.$$$reportNull$$$0(8);
        }
        if (psi instanceof PsiFile) {
            return 0;
        }
        Object object = liveStub = psi instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)((Object)psi)).getGreenStub() : psi.getStub();
        if (liveStub != null) {
            return ((StubBase)liveStub).getStubId();
        }
        return ((PsiFileImpl)psi.getContainingFile()).calcTreeElement().getStubbedSpine().getStubIndex(psi);
    }

    @NotNull
    public PsiElement retrieveOrThrow() {
        PsiElement element2 = this.retrieve();
        if (element2 == null) {
            String msg = this instanceof StubIndexReference ? ((StubIndexReference)this).diagnoseNull() : "Anchor hasn't survived: " + this;
            throw new PsiInvalidElementAccessException(null, msg);
        }
        PsiElement psiElement = element2;
        if (psiElement == null) {
            PsiAnchor.$$$reportNull$$$0(9);
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement restoreFromStubIndex(PsiFileWithStubSupport fileImpl, int index2, @NotNull IStubElementType<?, ?> elementType, boolean throwIfNull) {
        if (elementType == null) {
            PsiAnchor.$$$reportNull$$$0(10);
        }
        if (fileImpl == null) {
            if (throwIfNull) {
                throw new AssertionError((Object)"Null file");
            }
            return null;
        }
        if (index2 == 0) {
            return fileImpl;
        }
        StubbedSpine spine = fileImpl.getStubbedSpine();
        StubBasedPsiElement psi = (StubBasedPsiElement)spine.getStubPsi(index2);
        if (psi == null) {
            if (throwIfNull) {
                throw new AssertionError((Object)("Too large index: " + index2 + ">=" + spine.getStubCount()));
            }
            return null;
        }
        if (psi.getElementType() != elementType) {
            if (throwIfNull) {
                throw new AssertionError((Object)("Element type mismatch: " + psi.getElementType() + "!=" + elementType));
            }
            return null;
        }
        return psi;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/PsiAnchor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/PsiAnchor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateAnchor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveOrThrow";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doCreateAnchor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wrapperOrHardReference";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createStubReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canHaveStub";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calcStubIndex";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "restoreFromStubIndex";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PsiFileReference
    extends PsiAnchor {
        private final VirtualFile myFile;
        private final Project myProject;
        @NotNull
        private final Language myLanguage;

        private PsiFileReference(@NotNull VirtualFile file2, @NotNull PsiFile psiFile) {
            if (file2 == null) {
                PsiFileReference.$$$reportNull$$$0(0);
            }
            if (psiFile == null) {
                PsiFileReference.$$$reportNull$$$0(1);
            }
            this.myFile = file2;
            this.myProject = psiFile.getProject();
            this.myLanguage = PsiFileReference.findLanguage(psiFile);
        }

        @NotNull
        private static Language findLanguage(@NotNull PsiFile file2) {
            if (file2 == null) {
                PsiFileReference.$$$reportNull$$$0(2);
            }
            FileViewProvider vp = file2.getViewProvider();
            Set<Language> languages = vp.getLanguages();
            for (Language language : languages) {
                if (!file2.equals(vp.getPsi(language))) continue;
                Language language2 = language;
                if (language2 == null) {
                    PsiFileReference.$$$reportNull$$$0(3);
                }
                return language2;
            }
            throw new AssertionError((Object)("Non-retrievable file: " + file2.getClass() + "; " + file2.getLanguage() + "; " + languages));
        }

        @Override
        public PsiElement retrieve() {
            return this.getFile();
        }

        @Override
        @Nullable
        public PsiFile getFile() {
            return SelfElementInfo.restoreFileFromVirtual(this.myFile, this.myProject, this.myLanguage);
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return (int)this.myFile.getLength();
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof PsiFileReference)) {
                return false;
            }
            PsiFileReference reference2 = (PsiFileReference)o2;
            if (!this.myFile.equals(reference2.myFile)) {
                return false;
            }
            if (!this.myLanguage.equals(reference2.myLanguage)) {
                return false;
            }
            return this.myProject.equals(reference2.myProject);
        }

        public int hashCode() {
            return 31 * this.myFile.hashCode() + this.myLanguage.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/PsiAnchor$PsiFileReference";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/PsiAnchor$PsiFileReference";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findLanguage";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findLanguage";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class HardReference
    extends PsiAnchor {
        private final PsiElement myElement;

        public HardReference(@NotNull PsiElement element2) {
            if (element2 == null) {
                HardReference.$$$reportNull$$$0(0);
            }
            this.myElement = element2;
        }

        @Override
        public PsiElement retrieve() {
            return this.myElement.isValid() ? this.myElement : null;
        }

        @Override
        @NotNull
        public PsiElement retrieveOrThrow() {
            PsiUtilCore.ensureValid(this.myElement);
            PsiElement psiElement = super.retrieveOrThrow();
            if (psiElement == null) {
                HardReference.$$$reportNull$$$0(1);
            }
            return psiElement;
        }

        @Override
        public PsiFile getFile() {
            return this.myElement.getContainingFile();
        }

        @Override
        public int getStartOffset() {
            return this.myElement.getTextRange().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.myElement.getTextRange().getEndOffset();
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof HardReference)) {
                return false;
            }
            HardReference that = (HardReference)o2;
            return this.myElement.equals(that.myElement);
        }

        public int hashCode() {
            return this.myElement.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/PsiAnchor$HardReference";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/PsiAnchor$HardReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "retrieveOrThrow";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class PsiDirectoryReference
    extends PsiAnchor {
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final Project myProject;

        private PsiDirectoryReference(@NotNull VirtualFile file2, @NotNull Project project) {
            if (file2 == null) {
                PsiDirectoryReference.$$$reportNull$$$0(0);
            }
            if (project == null) {
                PsiDirectoryReference.$$$reportNull$$$0(1);
            }
            this.myFile = file2;
            this.myProject = project;
            assert (file2.isDirectory()) : file2;
        }

        @Override
        public PsiElement retrieve() {
            return SelfElementInfo.restoreDirectoryFromVirtual(this.myFile, this.myProject);
        }

        @Override
        public PsiFile getFile() {
            return null;
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return -1;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof PsiDirectoryReference)) {
                return false;
            }
            PsiDirectoryReference reference2 = (PsiDirectoryReference)o2;
            if (!this.myFile.equals(reference2.myFile)) {
                return false;
            }
            return this.myProject.equals(reference2.myProject);
        }

        public int hashCode() {
            return this.myFile.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "ksp/com/intellij/psi/PsiAnchor$PsiDirectoryReference";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class StubIndexReference
    extends PsiAnchor {
        @NotNull
        private final VirtualFile myVirtualFile;
        @NotNull
        private final Project myProject;
        private final int myIndex;
        @NotNull
        private final Language myLanguage;
        @NotNull
        private final IStubElementType<?, ?> myElementType;

        private StubIndexReference(@NotNull PsiFile file2, int index2, @NotNull Language language, @NotNull IStubElementType<?, ?> elementType) {
            if (file2 == null) {
                StubIndexReference.$$$reportNull$$$0(0);
            }
            if (language == null) {
                StubIndexReference.$$$reportNull$$$0(1);
            }
            if (elementType == null) {
                StubIndexReference.$$$reportNull$$$0(2);
            }
            this.myLanguage = language;
            this.myElementType = elementType;
            this.myVirtualFile = file2.getVirtualFile();
            if (file2.getViewProvider() instanceof FreeThreadedFileViewProvider) {
                throw new IllegalArgumentException("Must not use StubIndexReference for injected file; take a closer look at HardReference instead");
            }
            this.myProject = file2.getProject();
            this.myIndex = index2;
        }

        @Override
        @Nullable
        public PsiFile getFile() {
            if (this.myProject.isDisposed() || !this.myVirtualFile.isValid()) {
                return null;
            }
            FileViewProvider viewProvider = PsiManager.getInstance(this.myProject).findViewProvider(this.myVirtualFile);
            PsiFile file2 = viewProvider == null ? null : viewProvider.getPsi(this.myLanguage);
            return file2 instanceof PsiFileWithStubSupport ? file2 : null;
        }

        @Override
        public PsiElement retrieve() {
            return ReadAction.compute(() -> StubIndexReference.restoreFromStubIndex((PsiFileWithStubSupport)this.getFile(), this.myIndex, this.myElementType, false));
        }

        @NotNull
        @NonNls
        public String diagnoseNull() {
            String string2;
            PsiFile file2 = ReadAction.compute(this::getFile);
            try {
                PsiElement element2 = ReadAction.compute(() -> StubIndexReference.restoreFromStubIndex((PsiFileWithStubSupport)file2, this.myIndex, this.myElementType, true));
                string2 = "No diagnostics, element=" + element2 + "@" + (element2 == null ? 0 : System.identityHashCode(element2));
            }
            catch (AssertionError e2) {
                String msg = ((Throwable)((Object)e2)).getMessage();
                msg = msg + (file2 == null ? "\n no PSI file" : "\n current file stamp=" + (short)file2.getModificationStamp());
                Document document = FileDocumentManager.getInstance().getCachedDocument(this.myVirtualFile);
                if (document != null) {
                    msg = msg + "\n committed=" + PsiDocumentManager.getInstance(this.myProject).isCommitted(document);
                    msg = msg + "\n saved=" + !FileDocumentManager.getInstance().isDocumentUnsaved(document);
                }
                String string3 = msg;
                if (string3 == null) {
                    StubIndexReference.$$$reportNull$$$0(4);
                }
                return string3;
            }
            if (string2 == null) {
                StubIndexReference.$$$reportNull$$$0(3);
            }
            return string2;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof StubIndexReference)) {
                return false;
            }
            StubIndexReference that = (StubIndexReference)o2;
            return this.myIndex == that.myIndex && this.myVirtualFile.equals(that.myVirtualFile) && Comparing.equal(this.myElementType, that.myElementType) && this.myLanguage == that.myLanguage;
        }

        public int hashCode() {
            return ((31 * this.myVirtualFile.hashCode() + this.myIndex) * 31 + this.myElementType.hashCode()) * 31 + this.myLanguage.hashCode();
        }

        @NonNls
        public String toString() {
            return "StubIndexReference{myVirtualFile=" + this.myVirtualFile + ", myProject=" + this.myProject + ", myIndex=" + this.myIndex + ", myLanguage=" + this.myLanguage + ", myElementType=" + this.myElementType + '}';
        }

        @Override
        public int getStartOffset() {
            return this.getTextRange().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.getTextRange().getEndOffset();
        }

        @NotNull
        private TextRange getTextRange() {
            PsiElement resolved = this.retrieve();
            if (resolved == null) {
                throw new PsiInvalidElementAccessException(null, "Element type: " + this.myElementType + "; " + this.myVirtualFile);
            }
            TextRange textRange = resolved.getTextRange();
            if (textRange == null) {
                StubIndexReference.$$$reportNull$$$0(5);
            }
            return textRange;
        }

        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.myVirtualFile;
            if (virtualFile == null) {
                StubIndexReference.$$$reportNull$$$0(6);
            }
            return virtualFile;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                StubIndexReference.$$$reportNull$$$0(7);
            }
            return project;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementType";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/PsiAnchor$StubIndexReference";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/PsiAnchor$StubIndexReference";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "diagnoseNull";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class TreeRangeReference
    extends PsiAnchor {
        private final VirtualFile myVirtualFile;
        private final Project myProject;
        private final Identikit myInfo;
        private final int myStartOffset;
        private final int myEndOffset;

        private TreeRangeReference(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull Identikit info, @NotNull VirtualFile virtualFile) {
            if (file2 == null) {
                TreeRangeReference.$$$reportNull$$$0(0);
            }
            if (info == null) {
                TreeRangeReference.$$$reportNull$$$0(1);
            }
            if (virtualFile == null) {
                TreeRangeReference.$$$reportNull$$$0(2);
            }
            this.myVirtualFile = virtualFile;
            this.myProject = file2.getProject();
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myInfo = info;
        }

        @Override
        @Nullable
        public PsiElement retrieve() {
            PsiFile psiFile = this.getFile();
            if (psiFile == null || !psiFile.isValid()) {
                return null;
            }
            return this.myInfo.findPsiElement(psiFile, this.myStartOffset, this.myEndOffset);
        }

        @Override
        @Nullable
        public PsiFile getFile() {
            Language language = this.myInfo.getFileLanguage();
            if (language == null) {
                return null;
            }
            return SelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, language);
        }

        @Override
        public int getStartOffset() {
            return this.myStartOffset;
        }

        @Override
        public int getEndOffset() {
            return this.myEndOffset;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof TreeRangeReference)) {
                return false;
            }
            TreeRangeReference that = (TreeRangeReference)o2;
            return this.myEndOffset == that.myEndOffset && this.myStartOffset == that.myStartOffset && this.myInfo.equals(that.myInfo) && this.myVirtualFile.equals(that.myVirtualFile);
        }

        public int hashCode() {
            int result2 = this.myInfo.hashCode();
            result2 = 31 * result2 + this.myStartOffset;
            result2 = 31 * result2 + this.myEndOffset;
            result2 = 31 * result2 + this.myVirtualFile.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "virtualFile";
                    break;
                }
            }
            objectArray[1] = "ksp/com/intellij/psi/PsiAnchor$TreeRangeReference";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

