/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.ide.plugins;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import ksp.com.intellij.ide.plugins.DescriptorListLoadingContext;
import ksp.com.intellij.ide.plugins.FileItem;
import ksp.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import ksp.com.intellij.ide.plugins.MixedDirAndJarDataLoader;
import ksp.com.intellij.ide.plugins.PathResolver;
import ksp.com.intellij.ide.plugins.PluginDescriptorLoader;
import ksp.com.intellij.ide.plugins.PluginDescriptorsDebugData;
import ksp.com.intellij.ide.plugins.PluginXmlPathResolver;
import ksp.com.intellij.ide.plugins.ProductLoadingStrategy;
import ksp.com.intellij.ide.plugins.ProductLoadingStrategyKt;
import ksp.com.intellij.ide.plugins.RawPluginDescriptor;
import ksp.com.intellij.ide.plugins.XmlReader;
import ksp.com.intellij.idea.AppMode;
import ksp.com.intellij.openapi.application.PathManager;
import ksp.com.intellij.util.lang.ZipFilePool;
import ksp.com.intellij.util.xml.dom.StaxFactory;
import ksp.org.codehaus.stax2.XMLStreamReader2;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J@\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00130\u00122\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J6\u0010\u001e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00130\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016JC\u0010!\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00130\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010%R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006&"}, d2={"Lksp/com/intellij/ide/plugins/PathBasedProductLoadingStrategy;", "Lksp/com/intellij/ide/plugins/ProductLoadingStrategy;", "()V", "currentModeId", "", "getCurrentModeId", "()Ljava/lang/String;", "shouldLoadDescriptorsFromCoreClassPath", "", "getShouldLoadDescriptorsFromCoreClassPath", "()Z", "addMainModuleGroupToClassPath", "", "bootstrapClassLoader", "Ljava/lang/ClassLoader;", "isOptionalProductModule", "moduleName", "loadBundledPluginDescriptors", "", "Lkotlinx/coroutines/Deferred;", "Lksp/com/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "bundledPluginDir", "Ljava/nio/file/Path;", "isUnitTestMode", "context", "Lksp/com/intellij/ide/plugins/DescriptorListLoadingContext;", "zipFilePool", "Lksp/com/intellij/util/lang/ZipFilePool;", "loadCustomPluginDescriptors", "", "customPluginDir", "loadFromPluginClasspathDescriptor", "", "data", "", "([BLcom/intellij/ide/plugins/DescriptorListLoadingContext;Lcom/intellij/util/lang/ZipFilePool;Ljava/nio/file/Path;Lkotlinx/coroutines/CoroutineScope;)[Lkotlinx/coroutines/Deferred;", "intellij.platform.core.impl"})
@SourceDebugExtension(value={"SMAP\nProductLoadingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProductLoadingStrategy.kt\ncom/intellij/ide/plugins/PathBasedProductLoadingStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,272:1\n1#2:273\n*E\n"})
final class PathBasedProductLoadingStrategy
extends ProductLoadingStrategy {
    @Override
    @NotNull
    public String getCurrentModeId() {
        return AppMode.isRemoteDevHost() ? "backend" : "local_IDE";
    }

    @Override
    public void addMainModuleGroupToClassPath(@NotNull ClassLoader bootstrapClassLoader) {
        Intrinsics.checkNotNullParameter((Object)bootstrapClassLoader, (String)"bootstrapClassLoader");
    }

    @Override
    @NotNull
    public List<Deferred<IdeaPluginDescriptorImpl>> loadBundledPluginDescriptors(@NotNull CoroutineScope scope, @Nullable Path bundledPluginDir, boolean isUnitTestMode, @NotNull DescriptorListLoadingContext context2, @NotNull ZipFilePool zipFilePool) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)zipFilePool, (String)"zipFilePool");
        Path path = bundledPluginDir;
        if (path == null) {
            if (isUnitTestMode) {
                List<Deferred<IdeaPluginDescriptorImpl>> list = Collections.emptyList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
                return list;
            }
            path = Paths.get(PathManager.getPreInstalledPluginsPath(), new String[0]);
        }
        Path effectiveBundledPluginDir = path;
        Path classPathFile = effectiveBundledPluginDir.resolve("plugin-classpath.txt");
        try {
            byArray = Files.readAllBytes(classPathFile);
        }
        catch (NoSuchFileException ignored) {
            byArray = null;
        }
        byte[] data = byArray;
        if (data == null || data[0] != 1) {
            Intrinsics.checkNotNull((Object)effectiveBundledPluginDir);
            return PluginDescriptorLoader.loadDescriptorsFromDir(scope, effectiveBundledPluginDir, context2, true, zipFilePool);
        }
        Intrinsics.checkNotNull((Object)effectiveBundledPluginDir);
        return ArraysKt.asList((Object[])this.loadFromPluginClasspathDescriptor(data, context2, zipFilePool, effectiveBundledPluginDir, scope));
    }

    @Override
    @NotNull
    public Collection<Deferred<IdeaPluginDescriptorImpl>> loadCustomPluginDescriptors(@NotNull CoroutineScope scope, @NotNull Path customPluginDir, @NotNull DescriptorListLoadingContext context2, @NotNull ZipFilePool zipFilePool) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)customPluginDir, (String)"customPluginDir");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)zipFilePool, (String)"zipFilePool");
        return PluginDescriptorLoader.loadDescriptorsFromDir(scope, customPluginDir, context2, false, zipFilePool);
    }

    /*
     * WARNING - void declaration
     */
    private final Deferred<IdeaPluginDescriptorImpl>[] loadFromPluginClasspathDescriptor(byte[] data, DescriptorListLoadingContext context2, ZipFilePool zipFilePool, Path bundledPluginDir, CoroutineScope scope) {
        boolean jarOnly = data[1] == 1;
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(data, 2, data.length));
        int pluginCount = input.readUnsignedShort();
        Deferred[] deferredArray = new Deferred[pluginCount];
        for (int i2 = 0; i2 < pluginCount; ++i2) {
            Deferred[] deferredArray2;
            int n2;
            byte[] byArray;
            int n3 = i2;
            Deferred[] deferredArray3 = deferredArray;
            int n4 = n3;
            int fileCount = input.readUnsignedShort();
            Path pluginDir = bundledPluginDir.resolve(input.readUTF());
            int descriptorSize = input.readInt();
            if (descriptorSize == 0) {
                byArray = null;
            } else {
                void it;
                byte[] byArray2;
                byte[] byArray3 = byArray2 = new byte[descriptorSize];
                n2 = n4;
                deferredArray2 = deferredArray3;
                boolean bl2 = false;
                input.read((byte[])it);
                Unit unit = Unit.INSTANCE;
                deferredArray3 = deferredArray2;
                n4 = n2;
                byArray = byArray2;
            }
            byte[] pluginDescriptorData = byArray;
            FileItem[] fileItemArray = new FileItem[fileCount];
            n2 = n4;
            deferredArray2 = deferredArray3;
            for (int i3 = 0; i3 < fileCount; ++i3) {
                int n5 = i3;
                String path = input.readUTF();
                Path file2 = pluginDir.resolve(path);
                if (!jarOnly) {
                    file2 = file2.normalize();
                }
                Path path2 = file2;
                Intrinsics.checkNotNull((Object)path2);
                Intrinsics.checkNotNull((Object)path);
                fileItemArray[n5] = new FileItem(path2, path);
            }
            FileItem[] fileItems = fileItemArray;
            deferredArray2[n2] = ProductLoadingStrategyKt.access$asyncOrNull(scope, fileItems, (Function0)new Function0<IdeaPluginDescriptorImpl>(fileItems, zipFilePool, jarOnly, pluginDescriptorData, context2, pluginDir){
                final /* synthetic */ FileItem[] $fileItems;
                final /* synthetic */ ZipFilePool $zipFilePool;
                final /* synthetic */ boolean $jarOnly;
                final /* synthetic */ byte[] $pluginDescriptorData;
                final /* synthetic */ DescriptorListLoadingContext $context;
                final /* synthetic */ Path $pluginDir;
                {
                    this.$fileItems = $fileItems;
                    this.$zipFilePool = $zipFilePool;
                    this.$jarOnly = $jarOnly;
                    this.$pluginDescriptorData = $pluginDescriptorData;
                    this.$context = $context;
                    this.$pluginDir = $pluginDir;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final IdeaPluginDescriptorImpl invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    XMLStreamReader2 xMLStreamReader2;
                    FileItem item = (FileItem)ArraysKt.first((Object[])this.$fileItems);
                    MixedDirAndJarDataLoader dataLoader2 = new MixedDirAndJarDataLoader(this.$fileItems, this.$zipFilePool, this.$jarOnly);
                    PathResolver pluginPathResolver = PluginXmlPathResolver.DEFAULT_PATH_RESOLVER;
                    if (this.$pluginDescriptorData != null) {
                        xMLStreamReader2 = StaxFactory.createNonCoalescingXmlStreamReader(this.$pluginDescriptorData, item.path);
                    } else if (this.$jarOnly || StringsKt.endsWith$default((String)item.path, (String)".jar", (boolean)false, (int)2, null)) {
                        InputStream inputStream = dataLoader2.load("META-INF/plugin.xml", true);
                        Intrinsics.checkNotNull((Object)inputStream);
                        xMLStreamReader2 = StaxFactory.createNonCoalescingXmlStreamReader(inputStream, item.path);
                    } else {
                        InputStream inputStream = Files.newInputStream(item.file.resolve("META-INF/plugin.xml"), new OpenOption[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                        xMLStreamReader2 = StaxFactory.createNonCoalescingXmlStreamReader(inputStream, item.path);
                    }
                    XMLStreamReader2 descriptorInput = xMLStreamReader2;
                    RawPluginDescriptor raw = XmlReader.readModuleDescriptor(descriptorInput, this.$context, pluginPathResolver, dataLoader2, null, null);
                    Path path = this.$pluginDir;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"$pluginDir");
                    IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(raw, path, true, null, null, false, 32, null);
                    PluginDescriptorsDebugData pluginDescriptorsDebugData = this.$context.debugData;
                    if (pluginDescriptorsDebugData != null) {
                        pluginDescriptorsDebugData.recordDescriptorPath$intellij_platform_core_impl(descriptor2, raw, "META-INF/plugin.xml");
                    }
                    descriptor2.readExternal(raw, pluginPathResolver, this.$context, false, dataLoader2);
                    FileItem[] fileItemArray = this.$fileItems;
                    IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = descriptor2;
                    boolean $i$f$map = false;
                    void var9_10 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    int n2 = ((void)$this$mapTo$iv$iv).length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        void it;
                        void item$iv$iv;
                        void var15_16 = item$iv$iv = $this$mapTo$iv$iv[i2];
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(it.file);
                    }
                    ideaPluginDescriptorImpl.jarFiles = (List)destination$iv$iv;
                    return descriptor2;
                }
            });
        }
        return deferredArray;
    }

    @Override
    public boolean isOptionalProductModule(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return false;
    }

    @Override
    public boolean getShouldLoadDescriptorsFromCoreClassPath() {
        return true;
    }
}

