/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.extensions.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import ksp.com.intellij.openapi.components.ComponentManager;
import ksp.com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import ksp.com.intellij.openapi.extensions.PluginDescriptor;
import ksp.com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import ksp.com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import ksp.com.intellij.openapi.extensions.impl.ImplementationClassResolver;
import ksp.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lksp/com/intellij/openapi/extensions/impl/InterfaceExtensionImplementationClassResolver;", "Lksp/com/intellij/openapi/extensions/impl/ImplementationClassResolver;", "()V", "resolveImplementationClass", "Ljava/lang/Class;", "componentManager", "Lksp/com/intellij/openapi/components/ComponentManager;", "adapter", "Lksp/com/intellij/openapi/extensions/impl/ExtensionComponentAdapter;", "intellij.platform.extensions"})
public final class InterfaceExtensionImplementationClassResolver
implements ImplementationClassResolver {
    @NotNull
    public static final InterfaceExtensionImplementationClassResolver INSTANCE = new InterfaceExtensionImplementationClassResolver();

    private InterfaceExtensionImplementationClassResolver() {
    }

    @Override
    @NotNull
    public Class<?> resolveImplementationClass(@NotNull ComponentManager componentManager, @NotNull ExtensionComponentAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Object className = adapter.implementationClassOrName;
        if (!(className instanceof String)) {
            Intrinsics.checkNotNull((Object)className, (String)"null cannot be cast to non-null type java.lang.Class<*>");
            return (Class)className;
        }
        PluginDescriptor pluginDescriptor = adapter.pluginDescriptor;
        Class clazz = componentManager.loadClass((String)className, pluginDescriptor);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loadClass(...)");
        Class result2 = clazz;
        if (!(result2.getClassLoader() == pluginDescriptor.getPluginClassLoader() || pluginDescriptor.getPluginClassLoader() == null || StringsKt.startsWith$default((String)((String)className), (String)"ksp.com.intellij.webcore.resourceRoots.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)((String)className), (String)"ksp.com.intellij.tasks.impl.", (boolean)false, (int)2, null) || result2.isAnnotationPresent(InternalIgnoreDependencyViolation.class))) {
            String string2 = pluginDescriptor.getPluginId().getIdString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdString(...)");
            String idString = string2;
            if (!(Intrinsics.areEqual((Object)idString, (Object)"ksp.com.intellij.java") || Intrinsics.areEqual((Object)idString, (Object)"ksp.com.intellij.java.ide") || Intrinsics.areEqual((Object)idString, (Object)"ksp.com.intellij.java.frontend") || Intrinsics.areEqual((Object)idString, (Object)"ksp.org.jetbrains.android") || Intrinsics.areEqual((Object)idString, (Object)"ksp.com.intellij.kotlinNative.platformDeps") || Intrinsics.areEqual((Object)idString, (Object)"com.jetbrains.rider.android"))) {
                ExtensionPointImpl.LOG.error(componentManager.createError("Created extension classloader is not equal to plugin's one.\nSee https://youtrack.jetbrains.com/articles/IDEA-A-65/Plugin-Model#internalignoredependencyviolation\n(\n  className=" + className + ",\n  extensionInstanceClassloader=" + result2.getClassLoader() + ",\n  pluginClassloader=" + pluginDescriptor.getPluginClassLoader() + "\n)", pluginDescriptor.getPluginId()));
            }
        }
        adapter.implementationClassOrName = result2;
        return result2;
    }
}

