/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import ksp.org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.InheritedDefaultMethodsOnClassesLoweringKt;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import ksp.org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import ksp.org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFactory;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;

@PhaseDescription(name="GenerateJvmDefaultCompatibilityBridges")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/GenerateJvmDefaultCompatibilityBridges;", "Lksp/org/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "replaceWithDefaultCompatibilityBridgeIfNeeded", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "needsJvmDefaultCompatibilityBridge", "", "Lksp/org/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "generateBridge", "implementation", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nGenerateJvmDefaultCompatibilityBridges.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateJvmDefaultCompatibilityBridges.kt\norg/jetbrains/kotlin/backend/jvm/lower/GenerateJvmDefaultCompatibilityBridges\n+ 2 transform.kt\norg/jetbrains/kotlin/ir/util/TransformKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 5 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n26#2,4:131\n669#3,11:135\n669#3,11:146\n238#4,4:157\n382#5,13:161\n98#6:174\n99#6:176\n1#7:175\n*S KotlinDebug\n*F\n+ 1 GenerateJvmDefaultCompatibilityBridges.kt\norg/jetbrains/kotlin/backend/jvm/lower/GenerateJvmDefaultCompatibilityBridges\n*L\n60#1:131,4\n76#1:135,11\n82#1:146,11\n88#1:157,4\n111#1:161,13\n111#1:174\n111#1:176\n*E\n"})
public final class GenerateJvmDefaultCompatibilityBridges
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public GenerateJvmDefaultCompatibilityBridges(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        if (!this.context.getConfig().getJvmDefaultMode().isEnabled()) {
            return;
        }
        if (JvmIrUtilsKt.isJvmInterface(irClass)) {
            return;
        }
        List<IrDeclaration> $this$transformInPlace$iv = irClass.getDeclarations();
        boolean $i$f$transformInPlace = false;
        int n2 = $this$transformInPlace$iv.size();
        for (int i$iv = 0; i$iv < n2; ++i$iv) {
            IrElement irElement;
            void declaration2;
            IrDeclaration irDeclaration2 = $this$transformInPlace$iv.get(i$iv);
            int n3 = i$iv;
            List<IrDeclaration> list = $this$transformInPlace$iv;
            boolean bl2 = false;
            IrDeclaration irDeclaration3 = this.replaceWithDefaultCompatibilityBridgeIfNeeded((IrDeclaration)declaration2, irClass);
            IrElement irElement2 = irElement = irDeclaration3 != null ? (IrElement)irDeclaration3 : (IrElement)declaration2;
            if (irElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
            }
            list.set(n3, (IrDeclaration)((IrElement)((IrDeclaration)irElement2)));
        }
    }

    private final IrDeclaration replaceWithDefaultCompatibilityBridgeIfNeeded(IrDeclaration declaration2, IrClass irClass) {
        if (!(declaration2 instanceof IrSimpleFunction) || !((IrSimpleFunction)declaration2).isFakeOverride()) {
            return null;
        }
        IrSimpleFunction irSimpleFunction = InheritedDefaultMethodsOnClassesLoweringKt.findInterfaceImplementation((IrSimpleFunction)declaration2, this.context.getConfig().getJvmDefaultMode(), true);
        if (irSimpleFunction == null) {
            return null;
        }
        IrSimpleFunction implementation2 = irSimpleFunction;
        if (!this.needsJvmDefaultCompatibilityBridge((IrSimpleFunction)declaration2)) {
            return null;
        }
        return this.generateBridge((IrSimpleFunction)declaration2, implementation2, irClass);
    }

    private final boolean needsJvmDefaultCompatibilityBridge(IrSimpleFunction declaration2) {
        IrSimpleFunction current;
        Object v0;
        IrSimpleFunctionSymbol it;
        boolean found$iv;
        Object single$iv;
        boolean $i$f$singleOrNull;
        Iterable $this$singleOrNull$iv;
        block7: {
            $this$singleOrNull$iv = declaration2.getOverriddenSymbols();
            $i$f$singleOrNull = false;
            single$iv = null;
            found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                it = (IrSimpleFunctionSymbol)element$iv;
                boolean bl2 = false;
                if (!IrUtilsKt.isClass(IrUtilsKt.getParentAsClass(it.getOwner()))) continue;
                if (found$iv) {
                    v0 = null;
                    break block7;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = v0;
        IrSimpleFunction irSimpleFunction = current = irSimpleFunctionSymbol != null ? (IrSimpleFunction)irSimpleFunctionSymbol.getOwner() : null;
        while (current != null) {
            Object v3;
            block8: {
                if (current.getModality() == Modality.ABSTRACT) {
                    return false;
                }
                if (InheritedDefaultMethodsOnClassesLoweringKt.findInterfaceImplementation$default(current, this.context.getConfig().getJvmDefaultMode(), false, 2, null) != null) {
                    return true;
                }
                $this$singleOrNull$iv = current.getOverriddenSymbols();
                $i$f$singleOrNull = false;
                single$iv = null;
                found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    it = (IrSimpleFunctionSymbol)element$iv;
                    boolean bl3 = false;
                    if (!IrUtilsKt.isClass(IrUtilsKt.getParentAsClass(it.getOwner()))) continue;
                    if (found$iv) {
                        v3 = null;
                        break block8;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v3 = !found$iv ? null : single$iv;
            }
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = v3;
            current = irSimpleFunctionSymbol2 != null ? (IrSimpleFunction)irSimpleFunctionSymbol2.getOwner() : null;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction generateBridge(IrSimpleFunction declaration2, IrSimpleFunction implementation2, IrClass irClass) {
        void $this$generateBridge_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245;
        void $this$generateBridge_u24lambda_u248_u24lambda_u247_u24lambda_u246;
        IrCall irCall;
        void this_$iv$iv;
        DeclarationIrBuilder declarationIrBuilder;
        IrSimpleFunction irSimpleFunction;
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
        boolean bl2 = false;
        IrFunctionBuilder $this$generateBridge_u24lambda_u243 = $this$buildFun_u24lambda_u2420$iv;
        boolean bl3 = false;
        $this$generateBridge_u24lambda_u243.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getSUPER_INTERFACE_METHOD_BRIDGE());
        $this$generateBridge_u24lambda_u243.setName(declaration2.getName());
        $this$generateBridge_u24lambda_u243.setVisibility(declaration2.getVisibility());
        $this$generateBridge_u24lambda_u243.setModality(declaration2.getModality());
        $this$generateBridge_u24lambda_u243.setReturnType(declaration2.getReturnType());
        $this$generateBridge_u24lambda_u243.setInline(declaration2.isInline());
        $this$generateBridge_u24lambda_u243.setExternal(false);
        $this$generateBridge_u24lambda_u243.setTailrec(false);
        $this$generateBridge_u24lambda_u243.setSuspend(declaration2.isSuspend());
        $this$generateBridge_u24lambda_u243.setOperator(declaration2.isOperator());
        $this$generateBridge_u24lambda_u243.setInfix(declaration2.isInfix());
        $this$generateBridge_u24lambda_u243.setExpect(false);
        $this$generateBridge_u24lambda_u243.setFakeOverride(false);
        IrSimpleFunction $this$generateBridge_u24lambda_u248 = irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
        boolean bl4 = false;
        $this$generateBridge_u24lambda_u248.setParent(irClass);
        $this$generateBridge_u24lambda_u248.setOverriddenSymbols((List<? extends IrSimpleFunctionSymbol>)declaration2.getOverriddenSymbols());
        IrUtilsKt.copyValueAndTypeParametersFrom($this$generateBridge_u24lambda_u248, declaration2);
        IrValueParameter irValueParameter = $this$generateBridge_u24lambda_u248.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            irValueParameter.setType(IrUtilsKt.getDefaultType(irClass));
        }
        $this$generateBridge_u24lambda_u248.setAnnotations(declaration2.getAnnotations());
        JvmIrUtilsKt.copyCorrespondingPropertyFrom($this$generateBridge_u24lambda_u248, declaration2);
        DeclarationIrBuilder $this$generateBridge_u24lambda_u248_u24lambda_u247 = declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.context, (IrSymbol)$this$generateBridge_u24lambda_u248.getSymbol(), irClass.getStartOffset(), irClass.getEndOffset());
        boolean bl5 = false;
        IrBuilderWithScope $this$irBlock_u24default$iv = $this$generateBridge_u24lambda_u248_u24lambda_u247;
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void var18_21 = this_$iv$iv;
        IrBuilderWithScope irBuilderWithScope = $this$generateBridge_u24lambda_u248_u24lambda_u247;
        IrSimpleFunction irSimpleFunction2 = $this$generateBridge_u24lambda_u248;
        boolean bl6 = false;
        IrSimpleFunctionSymbol superMethod = JvmIrUtilsKt.firstSuperMethodFromKotlin(declaration2, implementation2);
        IrCall irCall2 = irCall = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)$this$generateBridge_u24lambda_u248_u24lambda_u247_u24lambda_u246, superMethod, $this$generateBridge_u24lambda_u248.getReturnType(), 0, null, 12, null);
        void var25_28 = $this$generateBridge_u24lambda_u248_u24lambda_u247_u24lambda_u246;
        boolean bl7 = false;
        $this$generateBridge_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setSuperQualifierSymbol(IrUtilsKt.getParentAsClass(superMethod.getOwner()).getSymbol());
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$generateBridge_u24lambda_u248_u24lambda_u247_u24lambda_u246;
        IrValueParameter irValueParameter2 = $this$generateBridge_u24lambda_u248.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter2);
        $this$generateBridge_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setDispatchReceiver(ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter2));
        IrValueParameter irValueParameter3 = $this$generateBridge_u24lambda_u248.getExtensionReceiverParameter();
        if (irValueParameter3 != null) {
            IrValueParameter it = irValueParameter3;
            boolean bl8 = false;
            $this$generateBridge_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setExtensionReceiver(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateBridge_u24lambda_u248_u24lambda_u247_u24lambda_u246, it));
        }
        Iterator iterator2 = ((Iterable)$this$generateBridge_u24lambda_u248.getTypeParameters()).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int index2 = n2++;
            IrTypeParameter parameter2 = (IrTypeParameter)iterator2.next();
            $this$generateBridge_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.getTypeArguments().set(index2, IrTypesKt.getDefaultType(parameter2));
        }
        iterator2 = ((Iterable)$this$generateBridge_u24lambda_u248.getValueParameters()).iterator();
        n2 = 0;
        while (iterator2.hasNext()) {
            int index3 = n2++;
            IrValueParameter parameter3 = (IrValueParameter)iterator2.next();
            $this$generateBridge_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.putValueArgument(index3, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateBridge_u24lambda_u248_u24lambda_u247_u24lambda_u246, parameter3));
        }
        var25_28.unaryPlus(irCall);
        Unit unit = Unit.INSTANCE;
        irSimpleFunction2.setBody(ExpressionHelpersKt.irExprBody(irBuilderWithScope, this_$iv$iv.doBuild()));
        return irSimpleFunction;
    }
}

