/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.sun.jna.win32;

import java.lang.reflect.Method;
import ksp.com.sun.jna.Function;
import ksp.com.sun.jna.FunctionMapper;
import ksp.com.sun.jna.Native;
import ksp.com.sun.jna.NativeLibrary;
import ksp.com.sun.jna.NativeMapped;
import ksp.com.sun.jna.NativeMappedConverter;

public class StdCallFunctionMapper
implements FunctionMapper {
    protected int getArgumentNativeStackSize(Class<?> cls) {
        if (NativeMapped.class.isAssignableFrom(cls)) {
            cls = NativeMappedConverter.getInstance(cls).nativeType();
        }
        if (cls.isArray()) {
            return Native.POINTER_SIZE;
        }
        try {
            return Native.getNativeSize(cls);
        }
        catch (IllegalArgumentException e2) {
            throw new IllegalArgumentException("Unknown native stack allocation size for " + cls);
        }
    }

    @Override
    public String getFunctionName(NativeLibrary library, Method method) {
        Class<?>[] argTypes;
        String name2 = method.getName();
        int pop = 0;
        for (Class<?> cls : argTypes = method.getParameterTypes()) {
            pop += this.getArgumentNativeStackSize(cls);
        }
        String decorated = name2 + "@" + pop;
        int conv = 63;
        try {
            Function func = library.getFunction(decorated, conv);
            name2 = func.getName();
        }
        catch (UnsatisfiedLinkError e2) {
            try {
                Function func = library.getFunction("_" + decorated, conv);
                name2 = func.getName();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        return name2;
    }
}

