/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.serialization;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.serialization.MutableAccessor;
import ksp.com.intellij.serialization.SerializationException;
import ksp.com.intellij.util.ExceptionUtilRt;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PropertyAccessor
implements MutableAccessor {
    private static final Logger LOG = Logger.getInstance(PropertyAccessor.class);
    private final String name;
    private final Class<?> type;
    private final Method readMethod;
    private final Method writeMethod;
    private final Type genericType;

    PropertyAccessor(@NotNull String name2, @NotNull Class<?> type2, @NotNull Method readMethod, @Nullable Method writeMethod) {
        if (name2 == null) {
            PropertyAccessor.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            PropertyAccessor.$$$reportNull$$$0(1);
        }
        if (readMethod == null) {
            PropertyAccessor.$$$reportNull$$$0(2);
        }
        this.name = name2;
        this.type = type2;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.genericType = readMethod.getGenericReturnType();
        try {
            this.readMethod.setAccessible(true);
            if (writeMethod != null) {
                writeMethod.setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @NotNull
    public String getGetterName() {
        String string2 = this.readMethod.getName();
        if (string2 == null) {
            PropertyAccessor.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    public Object read(@NotNull Object o2) {
        if (o2 == null) {
            PropertyAccessor.$$$reportNull$$$0(4);
        }
        try {
            return this.readMethod.invoke(o2, new Object[0]);
        }
        catch (IllegalAccessException e2) {
            throw new SerializationException(e2);
        }
        catch (InvocationTargetException e3) {
            ExceptionUtilRt.rethrowUnchecked(e3.getTargetException());
            throw new SerializationException(e3);
        }
    }

    @Override
    public Object readUnsafe(@NotNull Object o2) throws IllegalAccessException, InvocationTargetException {
        if (o2 == null) {
            PropertyAccessor.$$$reportNull$$$0(5);
        }
        return this.readMethod.invoke(o2, new Object[0]);
    }

    @Override
    public int readInt(@NotNull Object o2) throws IllegalAccessException, InvocationTargetException {
        if (o2 == null) {
            PropertyAccessor.$$$reportNull$$$0(6);
        }
        return (Integer)this.readMethod.invoke(o2, new Object[0]);
    }

    @Override
    public long readLong(@NotNull Object o2) throws IllegalAccessException, InvocationTargetException {
        if (o2 == null) {
            PropertyAccessor.$$$reportNull$$$0(7);
        }
        return (Long)this.readMethod.invoke(o2, new Object[0]);
    }

    @Override
    public float readFloat(@NotNull Object o2) throws IllegalAccessException, InvocationTargetException {
        if (o2 == null) {
            PropertyAccessor.$$$reportNull$$$0(8);
        }
        return ((Float)this.readMethod.invoke(o2, new Object[0])).floatValue();
    }

    @Override
    public double readDouble(@NotNull Object o2) throws IllegalAccessException, InvocationTargetException {
        if (o2 == null) {
            PropertyAccessor.$$$reportNull$$$0(9);
        }
        return (Double)this.readMethod.invoke(o2, new Object[0]);
    }

    @Override
    public boolean readBoolean(@NotNull Object o2) throws IllegalAccessException, InvocationTargetException {
        if (o2 == null) {
            PropertyAccessor.$$$reportNull$$$0(10);
        }
        return (Boolean)this.readMethod.invoke(o2, new Object[0]);
    }

    @Override
    public void set(@NotNull Object host, @Nullable Object value2) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(11);
        }
        if (this.writeMethod == null) {
            throw new SerializationException(host.getClass().getName() + "::" + this.name + " lacks a setter");
        }
        try {
            this.writeMethod.invoke(host, value2);
        }
        catch (IllegalAccessException e2) {
            throw new SerializationException(e2);
        }
        catch (InvocationTargetException e3) {
            T[] constants;
            Throwable cause = e3.getCause();
            if (cause instanceof NullPointerException && this.genericType instanceof Class && ((Class)this.genericType).isEnum() && cause.getMessage().contains("Parameter specified as non-null is null:") && (constants = ((Class)this.genericType).getEnumConstants()).length > 0) {
                try {
                    LOG.warn("Cannot set enum value, will be set to first enum value", e3);
                    this.writeMethod.invoke(host, constants[0]);
                    return;
                }
                catch (IllegalAccessException | InvocationTargetException e1) {
                    throw new SerializationException(e3);
                }
            }
            throw new SerializationException(cause);
        }
    }

    @Override
    public void setBoolean(@NotNull Object host, boolean value2) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(12);
        }
        this.set(host, value2);
    }

    @Override
    public void setInt(@NotNull Object host, int value2) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(13);
        }
        this.set(host, value2);
    }

    @Override
    public void setShort(@NotNull Object host, short value2) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(14);
        }
        this.set(host, value2);
    }

    @Override
    public void setLong(@NotNull Object host, long value2) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(15);
        }
        this.set(host, value2);
    }

    @Override
    public void setDouble(@NotNull Object host, double value2) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(16);
        }
        this.set(host, value2);
    }

    @Override
    public void setFloat(@NotNull Object host, float value2) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(17);
        }
        this.set(host, Float.valueOf(value2));
    }

    @Override
    public <T extends Annotation> T getAnnotation(@NotNull Class<T> annotationClass) {
        T annotation;
        if (annotationClass == null) {
            PropertyAccessor.$$$reportNull$$$0(18);
        }
        return (annotation = this.readMethod.getAnnotation(annotationClass)) != null || this.writeMethod == null ? annotation : this.writeMethod.getAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> boolean isAnnotationPresent(@NotNull Class<T> annotationClass) {
        boolean isPresent;
        if (annotationClass == null) {
            PropertyAccessor.$$$reportNull$$$0(19);
        }
        return (isPresent = this.readMethod.isAnnotationPresent(annotationClass)) || this.writeMethod == null ? isPresent : this.writeMethod.isAnnotationPresent(annotationClass);
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.name;
        if (string2 == null) {
            PropertyAccessor.$$$reportNull$$$0(20);
        }
        return string2;
    }

    @Override
    @NotNull
    public Class<?> getValueClass() {
        Class<?> clazz = this.type;
        if (clazz == null) {
            PropertyAccessor.$$$reportNull$$$0(21);
        }
        return clazz;
    }

    @Override
    @NotNull
    public Type getGenericType() {
        Type type2 = this.genericType;
        if (type2 == null) {
            PropertyAccessor.$$$reportNull$$$0(22);
        }
        return type2;
    }

    @Override
    public boolean isWritable() {
        return this.writeMethod != null && this.writeMethod.isAccessible();
    }

    @NonNls
    public String toString() {
        return "PropertyAccessor(name=" + this.name + ", class=" + this.readMethod.getDeclaringClass().getName() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 20: 
            case 21: 
            case 22: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 20: 
            case 21: 
            case 22: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readMethod";
                break;
            }
            case 3: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/serialization/PropertyAccessor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/serialization/PropertyAccessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGetterName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueClass";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readUnsafe";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readInt";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readLong";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readFloat";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readDouble";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readBoolean";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setBoolean";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setInt";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setShort";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setLong";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setDouble";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setFloat";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotation";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotationPresent";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

