/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.core;

import java.util.ArrayList;
import java.util.List;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.roots.PackageIndex;
import ksp.com.intellij.openapi.vfs.VfsUtilCore;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.util.CollectionQuery;
import ksp.com.intellij.util.Query;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class CorePackageIndex
extends PackageIndex {
    private static final Logger LOG = Logger.getInstance(CorePackageIndex.class);
    private final List<VirtualFile> myClasspath = new ArrayList<VirtualFile>();

    private List<VirtualFile> roots() {
        return this.myClasspath;
    }

    private List<VirtualFile> findDirectoriesByPackageName(String packageName2) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        String dirName = packageName2.replace(".", "/");
        for (VirtualFile root : this.roots()) {
            VirtualFile classDir = root.findFileByRelativePath(dirName);
            if (classDir == null) continue;
            result2.add(classDir);
        }
        return result2;
    }

    @Override
    public VirtualFile @NotNull [] getDirectoriesByPackageName(@NotNull String packageName2, boolean includeLibrarySources) {
        if (packageName2 == null) {
            CorePackageIndex.$$$reportNull$$$0(0);
        }
        VirtualFile[] virtualFileArray = this.getDirsByPackageName(packageName2, includeLibrarySources).toArray((VirtualFile[])VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            CorePackageIndex.$$$reportNull$$$0(1);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirsByPackageName(@NotNull String packageName2, boolean includeLibrarySources) {
        if (packageName2 == null) {
            CorePackageIndex.$$$reportNull$$$0(2);
        }
        return new CollectionQuery<VirtualFile>(this.findDirectoriesByPackageName(packageName2));
    }

    public void addToClasspath(VirtualFile root) {
        this.myClasspath.add(root);
    }

    @Override
    @Nullable
    public String getPackageNameByDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            CorePackageIndex.$$$reportNull$$$0(3);
        }
        for (VirtualFile root : this.roots()) {
            if (!VfsUtilCore.isAncestor(root, dir, false)) continue;
            return VfsUtilCore.getRelativePath(dir, root, '.');
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/core/CorePackageIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/core/CorePackageIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesByPackageName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDirsByPackageName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameByDirectory";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

