/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.operation;

import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.general.Translation;
import ksp.org.jetbrains.kotlin.js.translate.operation.IncrementTranslator;
import ksp.org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtConstantExpression;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtUnaryExpression;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import ksp.org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;

public final class UnaryOperationTranslator {
    private UnaryOperationTranslator() {
    }

    @NotNull
    public static JsExpression translate(@NotNull KtUnaryExpression expression2, @NotNull TranslationContext context2) {
        Object baseExpression;
        IElementType operationToken;
        if (expression2 == null) {
            UnaryOperationTranslator.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            UnaryOperationTranslator.$$$reportNull$$$0(1);
        }
        if ((operationToken = expression2.getOperationReference().getReferencedNameElementType()) == KtTokens.EXCLEXCL) {
            KtExpression baseExpression2 = PsiUtils.getBaseExpression(expression2);
            JsExpression translatedExpression = Translation.translateAsExpression(baseExpression2, context2);
            JsExpression jsExpression = TranslationUtils.sure(baseExpression2, translatedExpression, context2);
            if (jsExpression == null) {
                UnaryOperationTranslator.$$$reportNull$$$0(2);
            }
            return jsExpression;
        }
        if (operationToken == KtTokens.MINUS && (baseExpression = PsiUtils.getBaseExpression(expression2)) instanceof KtConstantExpression) {
            CompileTimeConstant<?> compileTimeValue = ConstantExpressionEvaluator.getConstant(expression2, context2.bindingContext());
            assert (compileTimeValue != null) : ErrorReportingUtils.message(expression2, "Expression is not compile time value: " + expression2.getText() + " ");
            Object value2 = BindingUtils.getCompileTimeValue(context2.bindingContext(), expression2, compileTimeValue);
            if (value2 instanceof Long) {
                JsExpression jsExpression = JsAstUtils.newLong((Long)value2);
                if (jsExpression == null) {
                    UnaryOperationTranslator.$$$reportNull$$$0(3);
                }
                return jsExpression;
            }
        }
        if (IncrementTranslator.isIncrement(operationToken)) {
            JsExpression jsExpression = IncrementTranslator.translate(expression2, context2);
            if (jsExpression == null) {
                UnaryOperationTranslator.$$$reportNull$$$0(4);
            }
            return jsExpression;
        }
        baseExpression = TranslationUtils.translateBaseExpression(context2, expression2);
        if (UnaryOperationTranslator.isExclForBinaryEqualLikeExpr(expression2, (JsExpression)baseExpression)) {
            JsExpression jsExpression = TranslationUtils.translateExclForBinaryEqualLikeExpr((JsBinaryOperation)baseExpression);
            if (jsExpression == null) {
                UnaryOperationTranslator.$$$reportNull$$$0(5);
            }
            return jsExpression;
        }
        ResolvedCall<? extends FunctionDescriptor> resolvedCall2 = CallUtilKt.getFunctionResolvedCallWithAssert(expression2, context2.bindingContext());
        JsExpression jsExpression = CallTranslator.translate(context2, resolvedCall2, (JsExpression)baseExpression);
        if (jsExpression == null) {
            UnaryOperationTranslator.$$$reportNull$$$0(6);
        }
        return jsExpression;
    }

    private static boolean isExclForBinaryEqualLikeExpr(@NotNull KtUnaryExpression expression2, @NotNull JsExpression baseExpression) {
        if (expression2 == null) {
            UnaryOperationTranslator.$$$reportNull$$$0(7);
        }
        if (baseExpression == null) {
            UnaryOperationTranslator.$$$reportNull$$$0(8);
        }
        if (PsiUtils.getOperationToken(expression2).equals(KtTokens.EXCL) && baseExpression instanceof JsBinaryOperation) {
            return TranslationUtils.isEqualLikeOperator(((JsBinaryOperation)baseExpression).getOperator());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isExclForBinaryEqualLikeExpr";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

