/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.operation;

import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import ksp.org.jetbrains.kotlin.js.patterns.PatternBuilder;
import ksp.org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import ksp.org.jetbrains.kotlin.js.translate.general.Translation;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import ksp.org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;

public class InOperationTranslator
extends AbstractTranslator {
    private static final DescriptorPredicate INT_SPECIALIZATION_TEST = PatternBuilder.pattern("ranges.IntRange.contains");
    private static final DescriptorPredicate INT_RANGE_TEST = PatternBuilder.pattern("Int.rangeTo");
    private final JsExpression left;
    private final KtExpression right;
    private final KtSimpleNameExpression operation;
    private final boolean negated;

    public InOperationTranslator(@NotNull TranslationContext context2, @NotNull JsExpression left, @NotNull KtExpression right, @NotNull KtSimpleNameExpression operation, boolean negated) {
        if (context2 == null) {
            InOperationTranslator.$$$reportNull$$$0(0);
        }
        if (left == null) {
            InOperationTranslator.$$$reportNull$$$0(1);
        }
        if (right == null) {
            InOperationTranslator.$$$reportNull$$$0(2);
        }
        if (operation == null) {
            InOperationTranslator.$$$reportNull$$$0(3);
        }
        super(context2);
        this.left = left;
        this.right = right;
        this.operation = operation;
        this.negated = negated;
    }

    @NotNull
    public JsExpression translate() {
        JsExpression candidate;
        ResolvedCall<? extends FunctionDescriptor> call2 = CallUtilKt.getFunctionResolvedCallWithAssert(this.operation, this.bindingContext());
        if (INT_SPECIALIZATION_TEST.test(call2.getResultingDescriptor()) && (candidate = this.translateInt()) != null) {
            JsExpression jsExpression = candidate;
            if (jsExpression == null) {
                InOperationTranslator.$$$reportNull$$$0(4);
            }
            return jsExpression;
        }
        JsExpression rightTranslated = Translation.translateAsExpression(this.right, this.context());
        return this.translateGeneral(call2, rightTranslated);
    }

    @NotNull
    private JsExpression translateGeneral(@NotNull ResolvedCall<? extends FunctionDescriptor> call2, @NotNull JsExpression rightTranslated) {
        if (call2 == null) {
            InOperationTranslator.$$$reportNull$$$0(5);
        }
        if (rightTranslated == null) {
            InOperationTranslator.$$$reportNull$$$0(6);
        }
        JsExpression result2 = CallTranslator.translate(this.context(), call2, rightTranslated);
        if (this.negated) {
            result2 = JsAstUtils.not(result2);
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            InOperationTranslator.$$$reportNull$$$0(7);
        }
        return jsExpression;
    }

    @Nullable
    private JsExpression translateInt() {
        ResolvedCall<? extends CallableDescriptor> rightCall = CallUtilKt.getResolvedCallWithAssert(this.right, this.bindingContext());
        if (!(rightCall.getResultingDescriptor() instanceof FunctionDescriptor)) {
            return null;
        }
        FunctionDescriptor callDescriptor = (FunctionDescriptor)rightCall.getResultingDescriptor();
        if (!INT_RANGE_TEST.test(callDescriptor)) {
            return null;
        }
        if (!(rightCall.getDispatchReceiver() instanceof ExpressionReceiver)) {
            return null;
        }
        KtExpression lower2 = ((ExpressionReceiver)rightCall.getDispatchReceiver()).getExpression();
        KtExpression upper = rightCall.getCall().getValueArguments().get(0).getArgumentExpression();
        assert (upper != null) : "Parse error occurred: " + PsiUtilsKt.getTextWithLocation(this.right);
        return this.translateInt(lower2, upper);
    }

    @NotNull
    private JsExpression translateInt(@NotNull KtExpression lowerExpression, @NotNull KtExpression upperExpression) {
        if (lowerExpression == null) {
            InOperationTranslator.$$$reportNull$$$0(8);
        }
        if (upperExpression == null) {
            InOperationTranslator.$$$reportNull$$$0(9);
        }
        JsExpression lower2 = Translation.translateAsExpression(lowerExpression, this.context());
        JsExpression upper = Translation.translateAsExpression(upperExpression, this.context());
        if (!this.negated) {
            JsBinaryOperation first = JsAstUtils.greaterThanEq(this.left, lower2);
            JsBinaryOperation second = JsAstUtils.lessThanEq(this.left, upper);
            JsBinaryOperation jsBinaryOperation = JsAstUtils.and(first, second);
            if (jsBinaryOperation == null) {
                InOperationTranslator.$$$reportNull$$$0(10);
            }
            return jsBinaryOperation;
        }
        JsBinaryOperation first = JsAstUtils.lessThan(this.left, lower2);
        JsBinaryOperation second = JsAstUtils.greaterThan(this.left, upper);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.or(first, second);
        if (jsBinaryOperation == null) {
            InOperationTranslator.$$$reportNull$$$0(11);
        }
        return jsBinaryOperation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/js/translate/operation/InOperationTranslator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightTranslated";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lowerExpression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/js/translate/operation/InOperationTranslator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "translateGeneral";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "translateInt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "translateGeneral";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "translateInt";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

