/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.backend.jvm;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import ksp.org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMapper;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import ksp.org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import ksp.org.jetbrains.kotlin.metadata.jvm.serialization.JvmStringTable;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/fir/backend/jvm/FirJvmElementAwareStringTable;", "Lksp/org/jetbrains/kotlin/metadata/jvm/serialization/JvmStringTable;", "Lksp/org/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "typeMapper", "Lksp/org/jetbrains/kotlin/backend/jvm/mapping/IrTypeMapper;", "components", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "nameResolver", "Lksp/org/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/mapping/IrTypeMapper;Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;)V", "getLocalClassIdReplacement", "Lksp/org/jetbrains/kotlin/name/ClassId;", "firClass", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "jvm-backend"})
@SourceDebugExtension(value={"SMAP\nFirJvmElementAwareStringTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmElementAwareStringTable.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmElementAwareStringTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1863#2,2:64\n*S KotlinDebug\n*F\n+ 1 FirJvmElementAwareStringTable.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmElementAwareStringTable\n*L\n56#1:64,2\n*E\n"})
public final class FirJvmElementAwareStringTable
extends JvmStringTable
implements FirElementAwareStringTable {
    @NotNull
    private final IrTypeMapper typeMapper;
    @NotNull
    private final Fir2IrComponents components;

    public FirJvmElementAwareStringTable(@NotNull IrTypeMapper typeMapper2, @NotNull Fir2IrComponents components, @Nullable JvmNameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)typeMapper2, (String)"typeMapper");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        super(nameResolver);
        this.typeMapper = typeMapper2;
        this.components = components;
    }

    public /* synthetic */ FirJvmElementAwareStringTable(IrTypeMapper irTypeMapper, Fir2IrComponents fir2IrComponents, JvmNameResolver jvmNameResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            jvmNameResolver = null;
        }
        this(irTypeMapper, fir2IrComponents, jvmNameResolver);
    }

    @Override
    @NotNull
    public ClassId getLocalClassIdReplacement(@NotNull FirClass firClass) {
        Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
        if (this.components.getConfiguration().getSkipBodies()) {
            Object object = (ConeClassLikeType)CollectionsKt.firstOrNull(FirDeclarationUtilKt.getSuperConeTypes(firClass));
            if (object == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null || (object = ((ConeClassLikeLookupTag)object).getClassId()) == null) {
                object = StandardClassIds.INSTANCE.getAny();
            }
            return object;
        }
        return this.getLocalClassIdReplacement(this.components.getClassifierStorage().getIrClass(firClass));
    }

    private final ClassId getLocalClassIdReplacement(IrClass $this$getLocalClassIdReplacement) {
        String thisClassName = StringsKt.replace$default((String)this.typeMapper.classInternalName($this$getLocalClassIdReplacement), (char)'/', (char)'.', (boolean)false, (int)4, null);
        if (JvmIrAttributesKt.isEnclosedInConstructor($this$getLocalClassIdReplacement)) {
            FqName thisClassFqName = new FqName(thisClassName);
            return new ClassId(thisClassFqName.parent(), FqName.Companion.topLevel(thisClassFqName.shortName()), true);
        }
        IrClass topmostClassParent = (IrClass)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)$this$getLocalClassIdReplacement, FirJvmElementAwareStringTable::getLocalClassIdReplacement$lambda$0));
        String topmostClassParentName = StringsKt.replace$default((String)this.typeMapper.classInternalName(topmostClassParent), (char)'/', (char)'.', (boolean)false, (int)4, null);
        FqName prefixFqName = new FqName(topmostClassParentName);
        ClassId classId = null;
        classId = new ClassId(prefixFqName.parent(), FqName.Companion.topLevel(prefixFqName.shortName()), true);
        if (thisClassName.length() == topmostClassParentName.length()) {
            return classId;
        }
        String string2 = thisClassName.substring(topmostClassParentName.length() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        char[] cArray = new char[]{'$'};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)string2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Name name2 = Name.identifier(it);
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            classId = classId.createNestedClassId(name2);
        }
        return classId;
    }

    private static final IrClass getLocalClassIdReplacement$lambda$0(IrClass it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrDeclarationParent irDeclarationParent = it.getParent();
        return irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
    }
}

