/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.wasm.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.wasm.FirWasmErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.wasm.checkers.FirWasmJsCodeHelpersKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirScript;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import ksp.org.jetbrains.kotlin.name.WebCommonStandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/wasm/checkers/expression/FirWasmJsCodeCallChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.wasm"})
@SourceDebugExtension(value={"SMAP\nFirWasmJsCodeCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWasmJsCodeCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/wasm/checkers/expression/FirWasmJsCodeCallChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,86:1\n43#2:87\n40#2:88\n*S KotlinDebug\n*F\n+ 1 FirWasmJsCodeCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/wasm/checkers/expression/FirWasmJsCodeCallChecker\n*L\n54#1:87\n57#1:88\n*E\n"})
public final class FirWasmJsCodeCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirWasmJsCodeCallChecker INSTANCE = new FirWasmJsCodeCallChecker();

    private FirWasmJsCodeCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol symbol = firCallableSymbol;
        if (!Intrinsics.areEqual((Object)symbol.getCallableId(), (Object)WebCommonStandardClassIds.Callables.Js)) {
            return;
        }
        List<FirDeclaration> containingDeclarations = context2.getContainingDeclarations();
        FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull(containingDeclarations);
        if (firDeclaration == null) {
            return;
        }
        FirDeclaration containingDeclaration = firDeclaration;
        FirDeclaration containingDeclarationOfContainingDeclaration = (FirDeclaration)CollectionsKt.getOrNull(containingDeclarations, (int)(containingDeclarations.size() - 2));
        boolean isContainingDeclarationTopLevel = containingDeclarationOfContainingDeclaration instanceof FirFile || containingDeclarationOfContainingDeclaration instanceof FirScript;
        KtSourceElement source = expression2.getCalleeReference().getSource();
        if (!isContainingDeclarationTopLevel) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_WRONG_CONTEXT(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        FirDeclaration firDeclaration2 = containingDeclaration;
        if (firDeclaration2 instanceof FirSimpleFunction) {
            if (!FirWasmJsCodeHelpersKt.hasValidJsCodeBody((FirSimpleFunction)containingDeclaration)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_WRONG_CONTEXT(), (DiagnosticContext)context2, null, 8, null);
            } else {
                FirMemberDeclaration $this$isSuspend$iv = (FirMemberDeclaration)containingDeclaration;
                boolean $i$f$isSuspend = false;
                if ($this$isSuspend$iv.getStatus().isSuspend()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_UNSUPPORTED_FUNCTION_KIND(), (Object)"suspend function", (DiagnosticContext)context2, null, 16, null);
                }
                FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)containingDeclaration;
                boolean $i$f$isInline = false;
                if ($this$isInline$iv.getStatus().isInline()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_UNSUPPORTED_FUNCTION_KIND(), (Object)"inline function", (DiagnosticContext)context2, null, 16, null);
                }
                if (FirDeclarationUtilKt.isExtension((FirCallableDeclaration)containingDeclaration)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_UNSUPPORTED_FUNCTION_KIND(), (Object)"function with extension receiver", (DiagnosticContext)context2, null, 16, null);
                }
                for (FirValueParameter parameter2 : ((FirSimpleFunction)containingDeclaration).getValueParameters()) {
                    String string2 = parameter2.getName().getIdentifierOrNullIfSpecial();
                    if (string2 != null ? IdentifierPolicyKt.isValidES5Identifier(string2) : false) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter2.getSource(), FirWasmErrors.INSTANCE.getJSCODE_INVALID_PARAMETER_NAME(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        } else if (firDeclaration2 instanceof FirProperty) {
            if (!FirWasmJsCodeHelpersKt.hasValidJsCodeBody((FirProperty)containingDeclaration)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_WRONG_CONTEXT(), (DiagnosticContext)context2, null, 8, null);
            }
        } else {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_WRONG_CONTEXT(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

