/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ksp.com.intellij.diagnostic.PluginException;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.extensions.ExtensionPointName;
import ksp.com.intellij.openapi.extensions.PluginAware;
import ksp.com.intellij.openapi.extensions.PluginDescriptor;
import ksp.com.intellij.openapi.extensions.RequiredElement;
import ksp.com.intellij.openapi.progress.ProcessCanceledException;
import ksp.com.intellij.patterns.ElementPattern;
import ksp.com.intellij.patterns.ElementPatternBean;
import ksp.com.intellij.patterns.StandardPatterns;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiReferenceProvider;
import ksp.com.intellij.util.KeyedLazyInstance;
import ksp.com.intellij.util.xmlb.annotations.Attribute;
import ksp.com.intellij.util.xmlb.annotations.Property;
import ksp.com.intellij.util.xmlb.annotations.Tag;
import ksp.com.intellij.util.xmlb.annotations.Transient;
import ksp.com.intellij.util.xmlb.annotations.XCollection;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class PsiReferenceProviderBean
implements KeyedLazyInstance<PsiReferenceProviderBean>,
PluginAware {
    public static final ExtensionPointName<PsiReferenceProviderBean> EP_NAME = new ExtensionPointName("ksp.com.intellij.psi.referenceProvider");
    @Attribute(value="language")
    public String language = Language.ANY.getID();
    @Attribute(value="providerClass")
    @RequiredElement
    public String className;
    @Tag(value="description")
    public String description;
    @Property(surroundWithTag=false)
    @XCollection
    @RequiredElement
    public ElementPatternBean[] patterns;
    private PluginDescriptor pluginDescriptor;

    public String getDescription() {
        return this.description;
    }

    public PsiReferenceProvider instantiate() {
        try {
            return (PsiReferenceProvider)ApplicationManager.getApplication().instantiateClass(this.className, this.pluginDescriptor);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(PsiReferenceProviderBean.class).error(e);
            return null;
        }
    }

    @Override
    @Transient
    public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            PsiReferenceProviderBean.$$$reportNull$$$0(0);
        }
        this.pluginDescriptor = pluginDescriptor;
    }

    @Nullable
    public ElementPattern<PsiElement> createElementPattern() {
        if (this.patterns == null || this.patterns.length == 0) {
            Logger.getInstance(PsiReferenceProviderBean.class).error(new PluginException("At least one pattern should be specified", this.pluginDescriptor.getPluginId()));
            return null;
        }
        if (this.patterns.length > 1) {
            List<ElementPattern> result2 = new ArrayList(this.patterns.length);
            for (ElementPatternBean t2 : this.patterns) {
                ElementPattern<PsiElement> o = t2.compilePattern();
                if (o == null) continue;
                result2.add(o);
            }
            result2 = result2.isEmpty() ? Collections.emptyList() : result2;
            return StandardPatterns.or(result2.toArray(new ElementPattern[0]));
        }
        return this.patterns[0].compilePattern();
    }

    @Override
    @NotNull
    public String getKey() {
        String string2 = this.language;
        if (string2 == null) {
            PsiReferenceProviderBean.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    @NotNull
    public PsiReferenceProviderBean getInstance() {
        PsiReferenceProviderBean psiReferenceProviderBean = this;
        if (psiReferenceProviderBean == null) {
            PsiReferenceProviderBean.$$$reportNull$$$0(2);
        }
        return psiReferenceProviderBean;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/PsiReferenceProviderBean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/PsiReferenceProviderBean";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setPluginDescriptor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

