/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.progress.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.functions.Function1;
import ksp.com.intellij.codeWithMe.ClientId;
import ksp.com.intellij.concurrency.ThreadContext;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.application.AccessToken;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.application.ModalityKt;
import ksp.com.intellij.openapi.application.ModalityState;
import ksp.com.intellij.openapi.application.ex.ApplicationManagerEx;
import ksp.com.intellij.openapi.application.impl.LaterInvocator;
import ksp.com.intellij.openapi.application.impl.ModalityStateEx;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.progress.EmptyProgressIndicator;
import ksp.com.intellij.openapi.progress.ProcessCanceledException;
import ksp.com.intellij.openapi.progress.ProgressIndicator;
import ksp.com.intellij.openapi.progress.ProgressManager;
import ksp.com.intellij.openapi.progress.Task;
import ksp.com.intellij.openapi.progress.impl.BlockingProgressIndicator;
import ksp.com.intellij.openapi.progress.impl.ProgressResult;
import ksp.com.intellij.openapi.util.Disposer;
import ksp.com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import ksp.com.intellij.util.concurrency.AppExecutorUtil;
import ksp.com.intellij.util.concurrency.ChildContext;
import ksp.com.intellij.util.concurrency.Propagation;
import ksp.com.intellij.util.concurrency.Semaphore;
import ksp.com.intellij.util.ui.EDT;
import ksp.kotlinx.coroutines.Job;
import ksp.org.jetbrains.annotations.Async;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class ProgressRunner<R> {
    private static final Logger LOG = Logger.getInstance(ProgressRunner.class);
    @NotNull
    private final @NotNull Function<? super @NotNull ProgressIndicator, ? extends R> myComputation;
    private final boolean isSync;
    private final boolean isModal;
    private final ThreadToUse myThreadToUse;
    @NotNull
    private final @NotNull CompletableFuture<? extends @NotNull ProgressIndicator> myProgressIndicatorFuture;

    public ProgressRunner(@NotNull Runnable computation) {
        if (computation == null) {
            ProgressRunner.$$$reportNull$$$0(0);
        }
        this((? super ProgressIndicator __) -> {
            computation.run();
            return null;
        });
    }

    public ProgressRunner(@NotNull Task task) {
        if (task == null) {
            ProgressRunner.$$$reportNull$$$0(1);
        }
        this((? super ProgressIndicator progress) -> {
            try {
                task.run((ProgressIndicator)progress);
            }
            finally {
                if (progress instanceof ProgressIndicatorEx) {
                    ((ProgressIndicatorEx)progress).finish(task);
                }
            }
            return null;
        });
    }

    public ProgressRunner(@NotNull @NotNull Function<? super @NotNull ProgressIndicator, ? extends R> computation) {
        if (computation == null) {
            ProgressRunner.$$$reportNull$$$0(2);
        }
        this(computation, false, false, ThreadToUse.POOLED, CompletableFuture.completedFuture(new EmptyProgressIndicator()));
    }

    private ProgressRunner(@NotNull @NotNull Function<? super @NotNull ProgressIndicator, ? extends R> computation, boolean sync, boolean modal, @NotNull ThreadToUse threadToUse, @NotNull @NotNull CompletableFuture<? extends @NotNull ProgressIndicator> progressIndicatorFuture) {
        if (computation == null) {
            ProgressRunner.$$$reportNull$$$0(3);
        }
        if (threadToUse == null) {
            ProgressRunner.$$$reportNull$$$0(4);
        }
        if (progressIndicatorFuture == null) {
            ProgressRunner.$$$reportNull$$$0(5);
        }
        this.myComputation = ClientId.decorateFunction(computation);
        this.isSync = sync;
        this.isModal = modal;
        this.myThreadToUse = threadToUse;
        this.myProgressIndicatorFuture = progressIndicatorFuture;
    }

    @Contract(pure=true)
    @NotNull
    public ProgressRunner<R> sync() {
        return this.isSync ? this : new ProgressRunner<R>(this.myComputation, true, this.isModal, this.myThreadToUse, this.myProgressIndicatorFuture);
    }

    @Contract(pure=true)
    @NotNull
    public ProgressRunner<R> modal() {
        return this.isModal ? this : new ProgressRunner<R>(this.myComputation, this.isSync, true, this.myThreadToUse, this.myProgressIndicatorFuture);
    }

    @Contract(pure=true)
    @NotNull
    public ProgressRunner<R> onThread(@NotNull ThreadToUse thread) {
        if (thread == null) {
            ProgressRunner.$$$reportNull$$$0(6);
        }
        return thread == this.myThreadToUse ? this : new ProgressRunner<R>(this.myComputation, this.isSync, this.isModal, thread, this.myProgressIndicatorFuture);
    }

    @Contract(pure=true)
    @NotNull
    public ProgressRunner<R> withProgress(@NotNull ProgressIndicator progressIndicator) {
        ProgressIndicator myIndicator;
        if (progressIndicator == null) {
            ProgressRunner.$$$reportNull$$$0(7);
        }
        try {
            myIndicator = this.myProgressIndicatorFuture.isDone() ? this.myProgressIndicatorFuture.get() : null;
        }
        catch (InterruptedException | ExecutionException e) {
            myIndicator = null;
        }
        return progressIndicator.equals(myIndicator) ? this : new ProgressRunner<R>(this.myComputation, this.isSync, this.isModal, this.myThreadToUse, CompletableFuture.completedFuture(progressIndicator));
    }

    @Contract(pure=true)
    @NotNull
    public ProgressRunner<R> withProgress(@NotNull @NotNull CompletableFuture<? extends @NotNull ProgressIndicator> progressIndicatorFuture) {
        if (progressIndicatorFuture == null) {
            ProgressRunner.$$$reportNull$$$0(8);
        }
        return this.myProgressIndicatorFuture == progressIndicatorFuture ? this : new ProgressRunner<R>(this.myComputation, this.isSync, this.isModal, this.myThreadToUse, progressIndicatorFuture);
    }

    @NotNull
    public ProgressResult<R> submitAndGet() {
        ProgressResult progressResult;
        CompletableFuture<ProgressResult<R>> future = this.sync().submit();
        try {
            progressResult = (ProgressResult)future.get();
        }
        catch (Throwable e) {
            throw new AssertionError((Object)"submit() handles exceptions and always returns successful future");
        }
        if (progressResult == null) {
            ProgressRunner.$$$reportNull$$$0(9);
        }
        return progressResult;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public CompletableFuture<ProgressResult<R>> submit() {
        CompletableFuture<Object> resultFuture;
        boolean forceSyncExec = this.checkIfForceDirectExecNeeded();
        @NotNull CompletionStage progressFuture = this.myProgressIndicatorFuture.thenApply(progress -> {
            if (progress instanceof Disposable) {
                Disposer.register(ApplicationManager.getApplication(), (Disposable)((Object)progress));
            }
            return progress;
        });
        if (forceSyncExec) {
            resultFuture = new CompletableFuture<Object>();
            try {
                ProgressIndicator progressIndicator2 = (ProgressIndicator)((CompletableFuture)progressFuture).join();
                resultFuture.complete(ProgressManager.getInstance().runProcess(() -> this.myComputation.apply(progressIndicator2), progressIndicator2));
            }
            catch (Throwable t2) {
                resultFuture.completeExceptionally(t2);
            }
        } else {
            Semaphore modalityEntered = new Semaphore(1);
            Function<@NotNull ProgressIndicator, Object> onThreadCallable = progressIndicator -> {
                if (this.isModal) {
                    modalityEntered.waitFor();
                }
                return ProgressManager.getInstance().runProcess(() -> this.myComputation.apply((ProgressIndicator)progressIndicator), (ProgressIndicator)progressIndicator);
            };
            resultFuture = ApplicationManager.getApplication().isDispatchThread() ? this.execFromEDT((CompletableFuture<ProgressIndicator>)progressFuture, modalityEntered, onThreadCallable) : this.normalExec((CompletableFuture<ProgressIndicator>)progressFuture, modalityEntered, onThreadCallable);
        }
        CompletionStage completionStage = resultFuture.handle((arg_0, arg_1) -> ProgressRunner.lambda$submit$6((CompletableFuture)progressFuture, arg_0, arg_1));
        if (completionStage == null) {
            ProgressRunner.$$$reportNull$$$0(10);
        }
        return completionStage;
    }

    private boolean checkIfForceDirectExecNeeded() {
        boolean forceDirectExec;
        if (!EDT.isCurrentThreadEdt()) {
            return false;
        }
        if (this.isSync && !ApplicationManager.getApplication().isWriteIntentLockAcquired()) {
            throw new IllegalStateException("Running sync tasks on pure EDT (w/o IW lock) is dangerous for several reasons.");
        }
        if (!this.isSync && this.isModal) {
            throw new IllegalStateException("Running async modal tasks from EDT is impossible: modal implies sync dialog show + polling events");
        }
        boolean bl = forceDirectExec = this.isSync && (ApplicationManager.getApplication().isWriteAccessAllowed() || !this.isModal);
        if (forceDirectExec) {
            String reason = ApplicationManager.getApplication().isWriteAccessAllowed() ? "inside Write Action" : "not modal execution";
            @NonNls String failedConstraints = "";
            if (this.isModal) {
                failedConstraints = failedConstraints + "Use Modal execution; ";
            }
            if (this.myThreadToUse == ThreadToUse.POOLED) {
                failedConstraints = failedConstraints + "Use pooled thread; ";
            }
            failedConstraints = failedConstraints.isEmpty() ? "none" : failedConstraints;
            Logger.getInstance(ProgressRunner.class).warn("Forced to sync exec on EDT. Reason: " + reason + ". Failed constraints: " + failedConstraints, new Throwable());
        }
        return forceDirectExec;
    }

    @NotNull
    private CompletableFuture<R> execFromEDT(@NotNull @NotNull CompletableFuture<? extends @NotNull ProgressIndicator> progressFuture, @NotNull Semaphore modalityEntered, @NotNull Function<ProgressIndicator, R> onThreadCallable) {
        CompletionStage<Object> resultFuture;
        if (progressFuture == null) {
            ProgressRunner.$$$reportNull$$$0(11);
        }
        if (modalityEntered == null) {
            ProgressRunner.$$$reportNull$$$0(12);
        }
        if (onThreadCallable == null) {
            ProgressRunner.$$$reportNull$$$0(13);
        }
        CompletableFuture taskFuture = this.launchTask(onThreadCallable, progressFuture);
        if (this.isModal) {
            CompletionStage blockingRunFuture = progressFuture.thenAccept(progressIndicator -> {
                if (progressIndicator instanceof BlockingProgressIndicator) {
                    ((BlockingProgressIndicator)progressIndicator).startBlocking(modalityEntered::up, taskFuture);
                } else {
                    Logger.getInstance(ProgressRunner.class).warn("Can't go modal without BlockingProgressIndicator");
                    modalityEntered.up();
                }
            });
            ((CompletableFuture)blockingRunFuture).exceptionally(throwable -> {
                taskFuture.completeExceptionally((Throwable)throwable);
                return null;
            });
            resultFuture = taskFuture.thenCombine(blockingRunFuture, (r, __) -> r);
        } else {
            resultFuture = taskFuture;
        }
        if (this.isSync && !resultFuture.isDone()) {
            throw new IllegalStateException("Result future must be done at this point");
        }
        CompletableFuture completableFuture = resultFuture;
        if (completableFuture == null) {
            ProgressRunner.$$$reportNull$$$0(14);
        }
        return completableFuture;
    }

    @NotNull
    private CompletableFuture<R> normalExec(@NotNull @NotNull CompletableFuture<? extends @NotNull ProgressIndicator> progressFuture, @NotNull Semaphore modalityEntered, @NotNull @NotNull Function<@NotNull ProgressIndicator, R> onThreadCallable) {
        if (progressFuture == null) {
            ProgressRunner.$$$reportNull$$$0(15);
        }
        if (modalityEntered == null) {
            ProgressRunner.$$$reportNull$$$0(16);
        }
        if (onThreadCallable == null) {
            ProgressRunner.$$$reportNull$$$0(17);
        }
        if (this.isModal) {
            Function<ProgressIndicator, ProgressIndicator> modalityRunnable = progressIndicator -> {
                LaterInvocator.enterModal(progressIndicator, (ModalityStateEx)progressIndicator.getModalityState());
                modalityEntered.up();
                return progressIndicator;
            };
            progressFuture = progressFuture.thenApplyAsync(modalityRunnable, r -> {
                if (ApplicationManager.getApplication().isWriteIntentLockAcquired()) {
                    r.run();
                } else {
                    ApplicationManager.getApplication().invokeLaterOnWriteThread(r);
                }
            });
        }
        CompletionStage<Object> resultFuture = this.launchTask(onThreadCallable, (CompletableFuture<? extends ProgressIndicator>)progressFuture);
        if (this.isModal) {
            CompletionStage modalityExitFuture = ((CompletableFuture)resultFuture.handle((r, throwable) -> r)).thenAcceptBoth(progressFuture, (r, progressIndicator) -> {
                if (ApplicationManager.getApplication().isWriteIntentLockAcquired()) {
                    LaterInvocator.leaveModal(progressIndicator);
                } else {
                    ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> LaterInvocator.leaveModal(progressIndicator), progressIndicator.getModalityState());
                }
            });
            resultFuture = resultFuture.thenCombine(modalityExitFuture, (r, __) -> r);
        }
        if (this.isSync) {
            ProgressRunner.waitForFutureUnlockingThread(resultFuture);
        }
        CompletableFuture<R> completableFuture = resultFuture;
        if (completableFuture == null) {
            ProgressRunner.$$$reportNull$$$0(18);
        }
        return completableFuture;
    }

    private static void waitForFutureUnlockingThread(@NotNull CompletableFuture<?> resultFuture) {
        if (resultFuture == null) {
            ProgressRunner.$$$reportNull$$$0(19);
        }
        if (ApplicationManager.getApplication().isWriteIntentLockAcquired()) {
            ProgressRunner.pollLaterInvocatorActively(resultFuture, LaterInvocator::pollWriteThreadEventsOnce);
            return;
        }
        if (EDT.isCurrentThreadEdt()) {
            throw new UnsupportedOperationException("Sync waiting from EDT is dangerous.");
        }
        try {
            resultFuture.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void pollLaterInvocatorActively(@NotNull CompletableFuture<?> resultFuture, @NotNull Runnable pollAction) {
        if (resultFuture == null) {
            ProgressRunner.$$$reportNull$$$0(20);
        }
        if (pollAction == null) {
            ProgressRunner.$$$reportNull$$$0(21);
        }
        ApplicationManagerEx.getApplicationEx().runUnlockingIntendedWrite(() -> {
            while (true) {
                try {
                    resultFuture.get(10L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ignore) {
                    ApplicationManagerEx.getApplicationEx().runIntendedWriteActionOnCurrentThread(pollAction);
                }
                finally {
                    continue;
                }
                break;
            }
            return null;
        });
    }

    public static boolean isCanceled(@NotNull Future<? extends ProgressIndicator> progressFuture) {
        if (progressFuture == null) {
            ProgressRunner.$$$reportNull$$$0(22);
        }
        try {
            return progressFuture.get().isCanceled();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static Throwable unwrap(@Nullable Throwable exception) {
        return exception instanceof CompletionException || exception instanceof ExecutionException ? exception.getCause() : exception;
    }

    @NotNull
    private CompletableFuture<R> launchTask(@NotNull @NotNull Function<@NotNull ProgressIndicator, R> task, @NotNull @NotNull CompletableFuture<? extends @NotNull ProgressIndicator> progressIndicatorFuture) {
        if (task == null) {
            ProgressRunner.$$$reportNull$$$0(23);
        }
        if (progressIndicatorFuture == null) {
            ProgressRunner.$$$reportNull$$$0(24);
        }
        CompletableFuture resultFuture = new CompletableFuture();
        ChildContext childContext = Propagation.createChildContext();
        CoroutineContext context2 = childContext.getContext();
        Job job = childContext.getJob();
        if (job != null) {
            job.invokeOnCompletion(true, true, (Function1<? super Throwable, Unit>)((Function1)throwable -> {
                if (throwable != null) {
                    resultFuture.completeExceptionally((Throwable)throwable);
                }
                return Unit.INSTANCE;
            }));
        }
        progressIndicatorFuture.whenComplete((progressIndicator, throwable) -> {
            if (throwable != null) {
                resultFuture.completeExceptionally((Throwable)throwable);
                return;
            }
            ProgressRunnable runnable = new ProgressRunnable(resultFuture, task, (ProgressIndicator)progressIndicator);
            ProgressRunnable contextRunnable = context2.equals(EmptyCoroutineContext.INSTANCE) ? runnable : () -> {
                CoroutineContext effectiveContext = context2.plus(ModalityKt.asContextElement(progressIndicator.getModalityState()));
                try (AccessToken ignored = ThreadContext.installThreadContext(effectiveContext, false);){
                    childContext.runAsCoroutine(runnable);
                }
            };
            switch (this.myThreadToUse) {
                case POOLED: {
                    AppExecutorUtil.getAppExecutorService().execute(contextRunnable);
                    break;
                }
                case WRITE: {
                    ModalityState processModality = progressIndicator.getModalityState();
                    ApplicationManager.getApplication().invokeLaterOnWriteThread(contextRunnable, processModality);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.myThreadToUse));
                }
            }
        });
        CompletableFuture completableFuture = resultFuture;
        if (completableFuture == null) {
            ProgressRunner.$$$reportNull$$$0(25);
        }
        return completableFuture;
    }

    private static /* synthetic */ ProgressResult lambda$submit$6(CompletableFuture progressFuture, Object result2, Throwable e) {
        Throwable throwable = ProgressRunner.unwrap(e);
        if (LOG.isDebugEnabled()) {
            if (throwable != null) {
                LOG.debug("ProgressRunner: task completed with throwable", throwable);
            }
            if (ProgressRunner.isCanceled(progressFuture)) {
                LOG.debug("ProgressRunner: task cancelled");
            }
        }
        return new ProgressResult<Object>(result2, throwable instanceof ProcessCanceledException || ProgressRunner.isCanceled(progressFuture), throwable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 25: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 1: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadToUse";
                break;
            }
            case 5: 
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicatorFuture";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/progress/impl/ProgressRunner";
                break;
            }
            case 11: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressFuture";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityEntered";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onThreadCallable";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultFuture";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pollAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/progress/impl/ProgressRunner";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "submitAndGet";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "submit";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "execFromEDT";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "normalExec";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "launchTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onThread";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withProgress";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 25: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "execFromEDT";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "normalExec";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "waitForFutureUnlockingThread";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "pollLaterInvocatorActively";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isCanceled";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "launchTask";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 25: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ThreadToUse {
        WRITE,
        POOLED;

    }

    static class ProgressRunnable<R>
    implements Runnable {
        private final CompletableFuture<R> resultFuture;
        private final Function<@NotNull ProgressIndicator, R> task;
        private final ProgressIndicator progressIndicator;

        @Async.Schedule
        ProgressRunnable(CompletableFuture<R> future, Function<@NotNull ProgressIndicator, R> task, ProgressIndicator indicator) {
            this.resultFuture = future;
            this.task = task;
            this.progressIndicator = indicator;
        }

        @Override
        @Async.Execute
        public void run() {
            try {
                this.resultFuture.complete(this.task.apply(this.progressIndicator));
            }
            catch (Throwable e) {
                this.resultFuture.completeExceptionally(e);
            }
        }
    }
}

