/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.wasm.resolve.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.MemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import ksp.org.jetbrains.kotlin.wasm.resolve.diagnostics.ErrorsWasm;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/wasm/resolve/diagnostics/WasmJsFunAnnotationChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "jsFunFqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "wasm.frontend"})
public final class WasmJsFunAnnotationChecker
implements DeclarationChecker {
    @NotNull
    public static final WasmJsFunAnnotationChecker INSTANCE = new WasmJsFunAnnotationChecker();
    @NotNull
    private static final FqName jsFunFqName = new FqName("kotlin.JsFun");

    private WasmJsFunAnnotationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof MemberDescriptor)) {
            return;
        }
        AnnotationDescriptor annotationDescriptor = descriptor2.getAnnotations().findAnnotation(jsFunFqName);
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor jsFun = annotationDescriptor;
        if (!DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2) || !DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            PsiElement psiElement = PsiSourceElementKt.getPsi(jsFun.getSource());
            if (psiElement == null) {
                psiElement = declaration2;
            }
            PsiElement jsFunPsi = psiElement;
            context2.getTrace().report(ErrorsWasm.WRONG_JS_FUN_TARGET.on(jsFunPsi));
        }
    }
}

