/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.search;

import java.util.List;
import ksp.com.intellij.openapi.application.QueryExecutorBase;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.psi.HierarchicalMethodSignature;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.search.searches.SuperMethodsSearch;
import ksp.com.intellij.psi.util.InheritanceUtil;
import ksp.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import ksp.com.intellij.psi.util.MethodSignatureUtil;
import ksp.com.intellij.util.Processor;
import ksp.org.jetbrains.annotations.NotNull;

public class MethodSuperSearcher
extends QueryExecutorBase<MethodSignatureBackedByPsiMethod, SuperMethodsSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance(MethodSuperSearcher.class);

    public MethodSuperSearcher() {
        super(true);
    }

    @Override
    public void processQuery(@NotNull SuperMethodsSearch.SearchParameters queryParameters, @NotNull Processor<? super MethodSignatureBackedByPsiMethod> consumer2) {
        if (queryParameters == null) {
            MethodSuperSearcher.$$$reportNull$$$0(0);
        }
        if (consumer2 == null) {
            MethodSuperSearcher.$$$reportNull$$$0(1);
        }
        PsiClass parentClass = queryParameters.getPsiClass();
        PsiMethod method = queryParameters.getMethod();
        HierarchicalMethodSignature signature = method.getHierarchicalMethodSignature();
        boolean checkBases = queryParameters.isCheckBases();
        boolean allowStaticMethod = queryParameters.isAllowStaticMethod();
        List<HierarchicalMethodSignature> supers = signature.getSuperSignatures();
        for (HierarchicalMethodSignature superSignature : supers) {
            if (!MethodSignatureUtil.isSubsignature(superSignature, signature) || MethodSuperSearcher.addSuperMethods(superSignature, method, parentClass, allowStaticMethod, checkBases, consumer2)) continue;
            return;
        }
    }

    private static boolean addSuperMethods(HierarchicalMethodSignature signature, PsiMethod method, PsiClass parentClass, boolean allowStaticMethod, boolean checkBases, Processor<? super MethodSignatureBackedByPsiMethod> consumer2) {
        PsiMethod signatureMethod = signature.getMethod();
        PsiClass hisClass = signatureMethod.getContainingClass();
        if ((parentClass == null || InheritanceUtil.isInheritorOrSelf(parentClass, hisClass, true)) && MethodSuperSearcher.isAcceptable(signatureMethod, method, allowStaticMethod)) {
            if (parentClass != null && !parentClass.equals(hisClass) && !checkBases) {
                return true;
            }
            LOG.assertTrue(signatureMethod != method, method);
            return consumer2.process(signature);
        }
        for (HierarchicalMethodSignature superSignature : signature.getSuperSignatures()) {
            if (!MethodSignatureUtil.isSubsignature(superSignature, signature)) continue;
            MethodSuperSearcher.addSuperMethods(superSignature, method, parentClass, allowStaticMethod, checkBases, consumer2);
        }
        return true;
    }

    private static boolean isAcceptable(PsiMethod superMethod, PsiMethod method, boolean allowStaticMethod) {
        boolean hisStatic = superMethod.hasModifierProperty("static");
        return hisStatic == method.hasModifierProperty("static") && (allowStaticMethod || !hisStatic) && JavaPsiFacade.getInstance(method.getProject()).getResolveHelper().isAccessible(superMethod, method, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "ksp/com/intellij/psi/impl/search/MethodSuperSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

