/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl;

import ksp.com.intellij.lang.injection.InjectedLanguageManager;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.roots.ProjectRootModificationTracker;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.psi.PsiDirectory;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.util.PsiModificationTracker;
import ksp.com.intellij.util.ArrayUtil;
import ksp.com.intellij.util.CachedValueBase;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public abstract class PsiCachedValue<T>
extends CachedValueBase<T> {
    private static final Key<?> PSI_MOD_COUNT_OPTIMIZATION = Key.create("PSI_MOD_COUNT_OPTIMIZATION");
    private final PsiManager myManager;

    PsiCachedValue(@NotNull PsiManager manager, boolean trackValue) {
        if (manager == null) {
            PsiCachedValue.$$$reportNull$$$0(0);
        }
        super(trackValue);
        this.myManager = manager;
    }

    @Override
    protected Object @NotNull [] normalizeDependencies(@Nullable T value2, Object @NotNull [] dependencyItems) {
        Object[] dependencies;
        if (dependencyItems == null) {
            PsiCachedValue.$$$reportNull$$$0(1);
        }
        if ((dependencies = super.normalizeDependencies(value2, dependencyItems)).length == 1 && PsiCachedValue.isPsiModificationCount(dependencies[0])) {
            if (dependencies == null) {
                PsiCachedValue.$$$reportNull$$$0(2);
            }
            return dependencies;
        }
        if (dependencies.length > 0 && ContainerUtil.and(dependencies, this::anyChangeImpliesPsiCounterChange)) {
            Object[] objectArray = ArrayUtil.prepend(PSI_MOD_COUNT_OPTIMIZATION, dependencies);
            if (objectArray == null) {
                PsiCachedValue.$$$reportNull$$$0(3);
            }
            return objectArray;
        }
        if (dependencies == null) {
            PsiCachedValue.$$$reportNull$$$0(4);
        }
        return dependencies;
    }

    private boolean anyChangeImpliesPsiCounterChange(@NotNull Object dependency) {
        if (dependency == null) {
            PsiCachedValue.$$$reportNull$$$0(5);
        }
        return dependency instanceof PsiElement && this.isVeryPhysical((PsiElement)dependency) || dependency instanceof ProjectRootModificationTracker || PsiCachedValue.isPsiModificationCount(dependency);
    }

    private static boolean isPsiModificationCount(@NotNull Object dependency) {
        if (dependency == null) {
            PsiCachedValue.$$$reportNull$$$0(6);
        }
        return dependency instanceof PsiModificationTracker || dependency == PsiModificationTracker.MODIFICATION_COUNT;
    }

    private boolean isVeryPhysical(@NotNull PsiElement dependency) {
        if (dependency == null) {
            PsiCachedValue.$$$reportNull$$$0(7);
        }
        if (!dependency.isValid()) {
            return false;
        }
        if (!dependency.isPhysical()) {
            return false;
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance(this.myManager.getProject());
        PsiFile topLevelFile = manager.getTopLevelFile(dependency);
        return topLevelFile != null && topLevelFile.isPhysical();
    }

    @Override
    protected boolean isUpToDate(@NotNull CachedValueBase.Data<T> data) {
        if (data == null) {
            PsiCachedValue.$$$reportNull$$$0(8);
        }
        if (this.myManager.isDisposed()) {
            return false;
        }
        Object[] dependencies = data.getDependencies();
        if (dependencies.length > 0 && dependencies[0] == PSI_MOD_COUNT_OPTIMIZATION && data.getTimeStamps()[0] == this.myManager.getModificationTracker().getModificationCount()) {
            return true;
        }
        return super.isUpToDate(data);
    }

    @Override
    protected boolean isDependencyOutOfDate(@NotNull Object dependency, long oldTimeStamp) {
        if (dependency == null) {
            PsiCachedValue.$$$reportNull$$$0(9);
        }
        if (dependency == PSI_MOD_COUNT_OPTIMIZATION) {
            return false;
        }
        return super.isDependencyOutOfDate(dependency, oldTimeStamp);
    }

    @Override
    protected long getTimeStamp(@NotNull Object dependency) {
        if (dependency == null) {
            PsiCachedValue.$$$reportNull$$$0(10);
        }
        if (dependency instanceof PsiDirectory) {
            return this.myManager.getModificationTracker().getModificationCount();
        }
        if (dependency instanceof PsiElement) {
            PsiElement element2 = (PsiElement)dependency;
            if (!element2.isValid()) {
                return -1L;
            }
            PsiFile containingFile2 = element2.getContainingFile();
            if (containingFile2 != null) {
                return containingFile2.getModificationStamp();
            }
        }
        if (dependency == PsiModificationTracker.MODIFICATION_COUNT || dependency == PSI_MOD_COUNT_OPTIMIZATION) {
            return this.myManager.getModificationTracker().getModificationCount();
        }
        return super.getTimeStamp(dependency);
    }

    @Override
    public boolean isFromMyProject(@NotNull Project project) {
        if (project == null) {
            PsiCachedValue.$$$reportNull$$$0(11);
        }
        return this.myManager.getProject() == project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyItems";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/PsiCachedValue";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/PsiCachedValue";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "normalizeDependencies";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "anyChangeImpliesPsiCounterChange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPsiModificationCount";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isVeryPhysical";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyOutOfDate";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFromMyProject";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

