/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.util;

import ksp.com.intellij.openapi.util.Factory;
import ksp.com.intellij.openapi.util.NullableLazyValue;
import ksp.com.intellij.openapi.util.RecursionGuard;
import ksp.com.intellij.openapi.util.RecursionManager;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public abstract class AtomicNullableLazyValue<T>
extends NullableLazyValue<T> {
    private volatile T myValue;
    private volatile boolean myComputed;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    protected AtomicNullableLazyValue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T getValue() {
        boolean computed = this.myComputed;
        T value2 = this.myValue;
        if (computed) {
            return value2;
        }
        AtomicNullableLazyValue atomicNullableLazyValue = this;
        synchronized (atomicNullableLazyValue) {
            computed = this.myComputed;
            value2 = this.myValue;
            if (!computed) {
                RecursionGuard.StackStamp stamp = RecursionManager.markStack();
                value2 = this.compute();
                if (stamp.mayCacheNow()) {
                    this.myValue = value2;
                    this.myComputed = true;
                }
            }
        }
        return value2;
    }

    @Override
    public boolean isComputed() {
        return this.myComputed;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static <T> AtomicNullableLazyValue<T> createValue(final @NotNull Factory<? extends T> value2) {
        if (value2 == null) {
            AtomicNullableLazyValue.$$$reportNull$$$0(0);
        }
        return new AtomicNullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value2.create();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "ksp/com/intellij/openapi/util/AtomicNullableLazyValue", "createValue"));
    }
}

