/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.google.common.base;

import ksp.com.google.common.annotations.GwtCompatible;
import ksp.com.google.common.base.ElementTypesAreNonnullByDefault;
import ksp.com.google.common.base.Strings;
import ksp.com.google.errorprone.annotations.CanIgnoreReturnValue;
import ksp.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean expression2) {
        if (!expression2) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression2, @CheckForNull Object errorMessage) {
        if (!expression2) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, char p1) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p1)));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, int p1) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p1));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, long p1) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p1));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, @CheckForNull Object p1) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p1));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, char p1, char p2) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p1), Character.valueOf(p2)));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, char p1, int p2) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p1), p2));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, char p1, long p2) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p1), p2));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, char p1, @CheckForNull Object p2) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p1), p2));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, int p1, char p2) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, int p1, int p2) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, int p1, long p2) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, int p1, @CheckForNull Object p2) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, long p1, char p2) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, long p1, int p2) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, long p1, long p2) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, long p1, @CheckForNull Object p2) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, @CheckForNull Object p1, char p2) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, @CheckForNull Object p1, int p2) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, @CheckForNull Object p1, long p2) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean expression2, @CheckForNull String errorMessageTemplate, @CheckForNull Object p1, @CheckForNull Object p2) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, @CheckForNull Object p1, @CheckForNull Object p2, @CheckForNull Object p3) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p1, p2, p3));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, @CheckForNull Object p1, @CheckForNull Object p2, @CheckForNull Object p3, @CheckForNull Object p4) {
        if (!expression2) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p1, p2, p3, p4));
        }
    }

    public static void checkState(boolean expression2) {
        if (!expression2) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression2, @CheckForNull Object errorMessage) {
        if (!expression2) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkState(boolean expression2, @CheckForNull String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, char p1) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p1)));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, int p1) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p1));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, long p1) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p1));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, @CheckForNull Object p1) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p1));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, char p1, char p2) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p1), Character.valueOf(p2)));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, char p1, int p2) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p1), p2));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, char p1, long p2) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p1), p2));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, char p1, @CheckForNull Object p2) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p1), p2));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, int p1, char p2) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, int p1, int p2) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, int p1, long p2) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, int p1, @CheckForNull Object p2) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, long p1, char p2) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, long p1, int p2) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, long p1, long p2) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, long p1, @CheckForNull Object p2) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, @CheckForNull Object p1, char p2) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, @CheckForNull Object p1, int p2) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, @CheckForNull Object p1, long p2) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, @CheckForNull Object p1, @CheckForNull Object p2) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, @CheckForNull Object p1, @CheckForNull Object p2, @CheckForNull Object p3) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p1, p2, p3));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, @CheckForNull Object p1, @CheckForNull Object p2, @CheckForNull Object p3, @CheckForNull Object p4) {
        if (!expression2) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p1, p2, p3, p4));
        }
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2) {
        if (reference2 == null) {
            throw new NullPointerException();
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, @CheckForNull Object errorMessage) {
        if (reference2 == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, errorMessageArgs));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, char p1) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p1)));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, int p1) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p1));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, long p1) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p1));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, @CheckForNull Object p1) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p1));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, char p1, char p2) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p1), Character.valueOf(p2)));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, char p1, int p2) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p1), p2));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, char p1, long p2) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p1), p2));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, char p1, @CheckForNull Object p2) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p1), p2));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, int p1, char p2) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, int p1, int p2) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, int p1, long p2) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, int p1, @CheckForNull Object p2) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, long p1, char p2) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, long p1, int p2) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, long p1, long p2) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, long p1, @CheckForNull Object p2) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, @CheckForNull Object p1, char p2) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, @CheckForNull Object p1, int p2) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, @CheckForNull Object p1, long p2) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, @CheckForNull Object p1, @CheckForNull Object p2) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p1, p2));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, @CheckForNull Object p1, @CheckForNull Object p2, @CheckForNull Object p3) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p1, p2, p3));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference2, String errorMessageTemplate, @CheckForNull Object p1, @CheckForNull Object p2, @CheckForNull Object p3, @CheckForNull Object p4) {
        if (reference2 == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p1, p2, p3, p4));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int index2, int size) {
        return Preconditions.checkElementIndex(index2, size, "index");
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int index2, int size, String desc) {
        if (index2 < 0 || index2 >= size) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(index2, size, desc));
        }
        return index2;
    }

    private static String badElementIndex(int index2, int size, String desc) {
        if (index2 < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", desc, index2);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return Strings.lenientFormat("%s (%s) must be less than size (%s)", desc, index2, size);
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int index2, int size) {
        return Preconditions.checkPositionIndex(index2, size, "index");
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int index2, int size, String desc) {
        if (index2 < 0 || index2 > size) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(index2, size, desc));
        }
        return index2;
    }

    private static String badPositionIndex(int index2, int size, String desc) {
        if (index2 < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", desc, index2);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return Strings.lenientFormat("%s (%s) must not be greater than size (%s)", desc, index2, size);
    }

    public static void checkPositionIndexes(int start, int end, int size) {
        if (start < 0 || end < start || end > size) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(start, end, size));
        }
    }

    private static String badPositionIndexes(int start, int end, int size) {
        if (start < 0 || start > size) {
            return Preconditions.badPositionIndex(start, size, "start index");
        }
        if (end < 0 || end > size) {
            return Preconditions.badPositionIndex(end, size, "end index");
        }
        return Strings.lenientFormat("end index (%s) must not be less than start index (%s)", end, start);
    }

    private static interface Impossible {
    }
}

