/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.ClassMembersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirDeprecatedSmartCastChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirSmartCastExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirSmartCastExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDeprecatedSmartCastChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDeprecatedSmartCastChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirDeprecatedSmartCastChecker\n+ 2 FirReferenceUtils.kt\norg/jetbrains/kotlin/fir/references/FirReferenceUtilsKt\n*L\n1#1,33:1\n24#2,8:34\n*S KotlinDebug\n*F\n+ 1 FirDeprecatedSmartCastChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirDeprecatedSmartCastChecker\n*L\n27#1:34,8\n*E\n"})
public final class FirDeprecatedSmartCastChecker
extends FirExpressionChecker<FirSmartCastExpression> {
    @NotNull
    public static final FirDeprecatedSmartCastChecker INSTANCE = new FirDeprecatedSmartCastChecker();

    private FirDeprecatedSmartCastChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirSmartCastExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        KtSourceElement source;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.UnstableSmartcastOnDelegatedProperties)) {
                    return;
                }
                if (!expression2.isStable()) {
                    return;
                }
                KtSourceElement ktSourceElement = expression2.getSource();
                if (ktSourceElement == null) {
                    return;
                }
                source = ktSourceElement;
                object = ReferenceUtilsKt.toReference(expression2.getOriginalExpression(), context2.getSession());
                if (object == null) break block8;
                FirReference $this$toResolvedSymbol_u24default$iv = object;
                boolean discardErrorReference$iv = false;
                boolean $i$f$toResolvedSymbol = false;
                FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved($this$toResolvedSymbol_u24default$iv);
                FirBasedSymbol<Object> firBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
                if (!(firBasedSymbol instanceof FirPropertySymbol)) {
                    firBasedSymbol = null;
                }
                if ((object = (FirPropertySymbol)((FirBasedSymbol)((FirPropertySymbol)firBasedSymbol))) != null) break block9;
            }
            return;
        }
        Object symbol = object;
        if (ClassMembersKt.isDelegated((FirCallableSymbol)symbol)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEPRECATED_SMARTCAST_ON_DELEGATED_PROPERTY(), (Object)FirTypeUtilsKt.getResolvedType(expression2), symbol, (DiagnosticContext)context2, null, 32, null);
        }
    }
}

