/*
 * Decompiled with CFR 0.152.
 */
package ksp.kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import ksp.kotlinx.serialization.descriptors.SerialDescriptor;
import ksp.kotlinx.serialization.json.internal.AbstractJsonLexer;
import ksp.kotlinx.serialization.json.internal.JsonDecodingException;
import ksp.kotlinx.serialization.json.internal.JsonEncodingException;
import ksp.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u001a \u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0000\u001a \u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0018\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0000\u001a \u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0005H\u0000\u001a\u0016\u0010\u0018\u001a\u00020\u0011*\u00020\u00112\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0014\u0010\u0019\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0003H\u0000\u00a8\u0006\u001b"}, d2={"InvalidFloatingPointDecoded", "Lksp/kotlinx/serialization/json/internal/JsonDecodingException;", "value", "", "key", "", "output", "InvalidFloatingPointEncoded", "Lksp/kotlinx/serialization/json/internal/JsonEncodingException;", "InvalidKeyKindException", "keyDescriptor", "Lksp/kotlinx/serialization/descriptors/SerialDescriptor;", "JsonDecodingException", "offset", "", "message", "input", "", "UnknownKeyException", "unexpectedFpErrorMessage", "invalidTrailingComma", "", "Lksp/kotlinx/serialization/json/internal/AbstractJsonLexer;", "entity", "minify", "throwInvalidFloatingPointDecoded", "result", "kotlinx-serialization-json"})
public final class JsonExceptionsKt {
    @NotNull
    public static final JsonDecodingException JsonDecodingException(int offset, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return new JsonDecodingException(offset >= 0 ? "Unexpected JSON token at offset " + offset + ": " + message : message);
    }

    @NotNull
    public static final JsonDecodingException JsonDecodingException(int offset, @NotNull String message, @NotNull CharSequence input) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return JsonExceptionsKt.JsonDecodingException(offset, message + "\nJSON input: " + JsonExceptionsKt.minify(input, offset));
    }

    @NotNull
    public static final JsonEncodingException InvalidFloatingPointEncoded(@NotNull Number value2, @NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return new JsonEncodingException("Unexpected special floating-point value " + value2 + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + JsonExceptionsKt.minify$default(output, 0, 1, null));
    }

    @NotNull
    public static final Void throwInvalidFloatingPointDecoded(@NotNull AbstractJsonLexer $this$throwInvalidFloatingPointDecoded, @NotNull Number result2) {
        Intrinsics.checkNotNullParameter((Object)$this$throwInvalidFloatingPointDecoded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        AbstractJsonLexer.fail$default($this$throwInvalidFloatingPointDecoded, "Unexpected special floating-point value " + result2 + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification", 0, "It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'", 2, null);
        throw new KotlinNothingValueException();
    }

    @NotNull
    public static final Void invalidTrailingComma(@NotNull AbstractJsonLexer $this$invalidTrailingComma, @NotNull String entity) {
        Intrinsics.checkNotNullParameter((Object)$this$invalidTrailingComma, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        $this$invalidTrailingComma.fail("Trailing comma before the end of JSON " + entity, $this$invalidTrailingComma.currentPosition - 1, "Trailing commas are non-complaint JSON and not allowed by default. Use 'allowTrailingCommas = true' in 'Json {}' builder to support them.");
        throw new KotlinNothingValueException();
    }

    public static /* synthetic */ Void invalidTrailingComma$default(AbstractJsonLexer abstractJsonLexer, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "object";
        }
        return JsonExceptionsKt.invalidTrailingComma(abstractJsonLexer, string2);
    }

    @NotNull
    public static final JsonEncodingException InvalidKeyKindException(@NotNull SerialDescriptor keyDescriptor) {
        Intrinsics.checkNotNullParameter((Object)keyDescriptor, (String)"keyDescriptor");
        return new JsonEncodingException("Value of type '" + keyDescriptor.getSerialName() + "' can't be used in JSON as a key in the map. It should have either primitive or enum kind, but its kind is '" + keyDescriptor.getKind() + "'.\nUse 'allowStructuredMapKeys = true' in 'Json {}' builder to convert such maps to [key1, value1, key2, value2,...] arrays.");
    }

    @NotNull
    public static final JsonEncodingException InvalidFloatingPointEncoded(@NotNull Number value2, @NotNull String key, @NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return new JsonEncodingException(JsonExceptionsKt.unexpectedFpErrorMessage(value2, key, output));
    }

    @NotNull
    public static final JsonDecodingException InvalidFloatingPointDecoded(@NotNull Number value2, @NotNull String key, @NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return JsonExceptionsKt.JsonDecodingException(-1, JsonExceptionsKt.unexpectedFpErrorMessage(value2, key, output));
    }

    private static final String unexpectedFpErrorMessage(Number value2, String key, String output) {
        return "Unexpected special floating-point value " + value2 + " with key " + key + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + JsonExceptionsKt.minify$default(output, 0, 1, null);
    }

    @NotNull
    public static final JsonDecodingException UnknownKeyException(@NotNull String key, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return JsonExceptionsKt.JsonDecodingException(-1, "Encountered an unknown key '" + key + "'.\nUse 'ignoreUnknownKeys = true' in 'Json {}' builder to ignore unknown keys.\nCurrent input: " + JsonExceptionsKt.minify$default(input, 0, 1, null));
    }

    @NotNull
    public static final CharSequence minify(@NotNull CharSequence $this$minify, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$minify, (String)"<this>");
        if ($this$minify.length() < 200) {
            return $this$minify;
        }
        if (offset == -1) {
            int start = $this$minify.length() - 60;
            if (start <= 0) {
                return $this$minify;
            }
            CharSequence charSequence = $this$minify;
            int n = charSequence.length();
            return "....." + ((Object)charSequence.subSequence(start, n)).toString();
        }
        int start = offset - 30;
        int end = offset + 30;
        String prefix = start <= 0 ? "" : ".....";
        String suffix = end >= $this$minify.length() ? "" : ".....";
        return prefix + ((Object)$this$minify.subSequence(RangesKt.coerceAtLeast((int)start, (int)0), RangesKt.coerceAtMost((int)end, (int)$this$minify.length()))).toString() + suffix;
    }

    public static /* synthetic */ CharSequence minify$default(CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return JsonExceptionsKt.minify(charSequence, n);
    }
}

