/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.stubs;

import java.lang.reflect.Field;
import java.util.function.Supplier;
import ksp.com.intellij.psi.stubs.ObjectStubSerializer;
import ksp.com.intellij.psi.stubs.Stub;

final class StubFieldAccessor
implements Supplier<ObjectStubSerializer<?, ? extends Stub>> {
    final String externalId;
    private final Field myField;
    private volatile ObjectStubSerializer<?, Stub> myFieldValue;

    StubFieldAccessor(String externalId, Field field) {
        this.externalId = externalId;
        this.myField = field;
        try {
            field.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public ObjectStubSerializer<?, Stub> get() {
        ObjectStubSerializer delegate = this.myFieldValue;
        if (delegate == null) {
            try {
                ObjectStubSerializer value2;
                this.myFieldValue = delegate = (value2 = (ObjectStubSerializer)this.myField.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(this.myField + " is not assignable to 'ObjectStubSerializer'", e);
            }
            if (!delegate.getExternalId().equals(this.externalId)) {
                throw new IllegalStateException("External id mismatch in " + this + ". Judging by extension declaration it should be " + this.externalId + " but " + delegate.getExternalId() + " is returned.");
            }
        }
        return delegate;
    }

    public String toString() {
        return this.myField.toString();
    }
}

