/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.lexer;

import ksp.com.intellij.lexer.Lexer;
import ksp.com.intellij.lexer.LexerBase;
import ksp.com.intellij.openapi.util.Comparing;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.com.intellij.util.ArrayUtil;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface TokenList {
    public int getTokenCount();

    @NotNull
    public CharSequence getTokenizedText();

    public int getTokenStart(int var1);

    public int getTokenEnd(int var1);

    @NotNull
    default public TextRange getTokenRange(int index2) {
        return new TextRange(this.getTokenStart(index2), this.getTokenEnd(index2));
    }

    public IElementType getTokenType(int var1);

    default public CharSequence getTokenText(int index2) {
        if (index2 < 0 || index2 >= this.getTokenCount()) {
            return null;
        }
        return this.getTokenizedText().subSequence(this.getTokenStart(index2), this.getTokenEnd(index2));
    }

    default public boolean hasType(int index2, @NotNull IElementType type2) {
        if (type2 == null) {
            TokenList.$$$reportNull$$$0(0);
        }
        return this.getTokenType(index2) == type2;
    }

    default public boolean hasType(int index2, IElementType ... types2) {
        if (types2 == null) {
            TokenList.$$$reportNull$$$0(1);
        }
        return ArrayUtil.contains(this.getTokenType(index2), types2);
    }

    default public boolean hasType(int index2, @NotNull TokenSet types2) {
        if (types2 == null) {
            TokenList.$$$reportNull$$$0(2);
        }
        return types2.contains(this.getTokenType(index2));
    }

    default public int backWithBraceMatching(int index2, @NotNull IElementType opening, @NotNull IElementType closing) {
        if (opening == null) {
            TokenList.$$$reportNull$$$0(3);
        }
        if (closing == null) {
            TokenList.$$$reportNull$$$0(4);
        }
        if (this.getTokenType(index2) == closing) {
            int nesting = 1;
            while (nesting > 0 && index2 > 0) {
                IElementType type2;
                if ((type2 = this.getTokenType(--index2)) == closing) {
                    ++nesting;
                    continue;
                }
                if (type2 != opening) continue;
                --nesting;
            }
        }
        return index2 - 1;
    }

    default public int backWhile(int index2, @NotNull TokenSet toSkip) {
        if (toSkip == null) {
            TokenList.$$$reportNull$$$0(5);
        }
        while (this.hasType(index2, toSkip)) {
            --index2;
        }
        return index2;
    }

    default public int forwardWhile(int index2, @NotNull TokenSet toSkip) {
        if (toSkip == null) {
            TokenList.$$$reportNull$$$0(6);
        }
        while (this.hasType(index2, toSkip)) {
            ++index2;
        }
        return index2;
    }

    @NotNull
    default public Lexer asLexer() {
        return new WrappingLexer(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opening";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closing";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSkip";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/lexer/TokenList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "backWithBraceMatching";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "backWhile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "forwardWhile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class WrappingLexer
    extends LexerBase {
        private final TokenList myTokens;
        private int myIndex;

        WrappingLexer(TokenList tokens) {
            this.myTokens = tokens;
        }

        public TokenList getTokens() {
            return this.myTokens;
        }

        @Override
        public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            if (buffer == null) {
                WrappingLexer.$$$reportNull$$$0(0);
            }
            assert (Comparing.equal(buffer, this.myTokens.getTokenizedText()));
            assert (startOffset == 0);
            assert (endOffset == buffer.length());
            assert (initialState == 0);
            this.myIndex = 0;
        }

        @Override
        public int getState() {
            return this.myIndex;
        }

        @Override
        @Nullable
        public IElementType getTokenType() {
            return this.myTokens.getTokenType(this.myIndex);
        }

        @Override
        public int getTokenStart() {
            return this.myTokens.getTokenStart(this.myIndex);
        }

        @Override
        public int getTokenEnd() {
            return this.myTokens.getTokenEnd(this.myIndex);
        }

        @Override
        public void advance() {
            ++this.myIndex;
        }

        @Override
        @NotNull
        public CharSequence getBufferSequence() {
            CharSequence charSequence = this.myTokens.getTokenizedText();
            if (charSequence == null) {
                WrappingLexer.$$$reportNull$$$0(1);
            }
            return charSequence;
        }

        @Override
        public int getBufferEnd() {
            return this.myTokens.getTokenizedText().length();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/lexer/TokenList$WrappingLexer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/lexer/TokenList$WrappingLexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBufferSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "start";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

