/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsicWithReceiverComputed;
import ksp.org.jetbrains.kotlin.js.translate.utils.TranslationUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/KotlinAliasedFunctionIntrinsic;", "Lksp/org/jetbrains/kotlin/js/translate/intrinsic/functions/basic/FunctionIntrinsicWithReceiverComputed;", "functionName", "", "<init>", "(Ljava/lang/String;)V", "apply", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsExpression;", "receiver", "arguments", "", "context", "Lksp/org/jetbrains/kotlin/js/translate/context/TranslationContext;", "js.translator"})
public class KotlinAliasedFunctionIntrinsic
extends FunctionIntrinsicWithReceiverComputed {
    @NotNull
    private final String functionName;

    public KotlinAliasedFunctionIntrinsic(@NotNull String functionName) {
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        this.functionName = functionName;
    }

    @Override
    @NotNull
    public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context2) {
        List<? extends JsExpression> list;
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsExpression jsExpression = context2.getReferenceToIntrinsic(this.functionName);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getReferenceToIntrinsic(...)");
        JsExpression function2 = jsExpression;
        JsExpression jsExpression2 = receiver;
        if (jsExpression2 == null) {
            list = arguments2;
        } else {
            List<JsExpression> list2 = TranslationUtils.generateInvocationArguments(jsExpression2, arguments2);
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"generateInvocationArguments(...)");
        }
        return new JsInvocation(function2, list);
    }
}

