/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.declarations.FirField;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.JvmStandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmRecordChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmRecordChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmRecordChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmRecordChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n1#1,109:1\n51#2:110\n35#2:111\n17#2,2:112\n57#2:114\n65#2:116\n37#3:115\n1863#4,2:117\n1863#4:119\n1864#4:121\n39#5:120\n*S KotlinDebug\n*F\n+ 1 FirJvmRecordChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmRecordChecker\n*L\n51#1:110\n56#1:111\n61#1:112,2\n66#1:114\n71#1:116\n66#1:115\n81#1:117,2\n88#1:119\n88#1:121\n96#1:120\n*E\n"})
public final class FirJvmRecordChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirJvmRecordChecker INSTANCE = new FirJvmRecordChecker();

    private FirJvmRecordChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block17: {
            Modality modality$iv;
            Object object;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirTypeRef firTypeRef = (FirTypeRef)CollectionsKt.firstOrNull(declaration2.getSuperTypeRefs());
            if (firTypeRef != null) {
                FirTypeRef typeRef = firTypeRef;
                boolean bl = false;
                if (typeRef.getSource() != null && Intrinsics.areEqual((Object)FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getConeType(typeRef), context2.getSession()), (Object)JvmStandardClassIds.Java.INSTANCE.getRecord())) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirJvmErrors.INSTANCE.getILLEGAL_JAVA_LANG_RECORD_SUPERTYPE(), (DiagnosticContext)context2, null, 8, null);
                    return;
                }
            }
            if ((object = FirAnnotationUtilsKt.getAnnotationByClassId(declaration2, JvmStandardClassIds.JVM_RECORD_ANNOTATION_CLASS_ID, context2.getSession())) == null || (object = ((FirAnnotation)object).getSource()) == null) {
                return;
            }
            Object annotationSource = object;
            LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
            if (!languageVersionSettings.supportsFeature(LanguageFeature.JvmRecordSupport)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)((Object)LanguageFeature.JvmRecordSupport), (Object)languageVersionSettings), (DiagnosticContext)context2, null, 16, null);
                return;
            }
            FirClassLikeDeclaration $this$isLocal$iv = declaration2;
            boolean $i$f$isLocal = false;
            if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirJvmErrors.INSTANCE.getLOCAL_JVM_RECORD(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
            FirMemberDeclaration $this$isInner$iv = declaration2;
            boolean $i$f$isInner = false;
            if ($this$isInner$iv.getStatus().isInner()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJvmErrors.INSTANCE.getINNER_JVM_RECORD(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
            FirMemberDeclaration $this$isFinal$iv = declaration2;
            boolean $i$f$isFinal = false;
            Modality modality = $this$isFinal$iv.getStatus().getModality();
            if (!(modality == null ? true : (modality$iv = modality) == Modality.FINAL)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJvmErrors.INSTANCE.getNON_FINAL_JVM_RECORD(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
            FirClass $this$isEnumClass$iv = declaration2;
            boolean $i$f$isEnumClass = false;
            ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
            boolean $i$f$isEnumClass2 = false;
            boolean bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJvmErrors.INSTANCE.getENUM_JVM_RECORD(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
            FirRegularClass $this$isData$iv = declaration2;
            boolean $i$f$isData = false;
            if (!$this$isData$iv.getStatus().isData()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirJvmErrors.INSTANCE.getNON_DATA_CLASS_JVM_RECORD(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
            Object object2 = DeclarationUtilsKt.primaryConstructorIfAny(declaration2, context2.getSession());
            if (object2 != null && (object2 = ((FirFunctionSymbol)object2).getValueParameterSymbols()) != null) {
                Object params = object2;
                boolean bl2 = false;
                if (params.isEmpty()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirJvmErrors.INSTANCE.getJVM_RECORD_WITHOUT_PRIMARY_CONSTRUCTOR_PARAMETERS(), (DiagnosticContext)context2, null, 8, null);
                    return;
                }
                Iterable $this$forEach$iv = CollectionsKt.dropLast((List)params, (int)1);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirValueParameterSymbol param = (FirValueParameterSymbol)element$iv;
                    boolean bl3 = false;
                    if (!param.isVararg()) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)param.getSource(), FirJvmErrors.INSTANCE.getJVM_RECORD_NOT_LAST_VARARG_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
                }
            }
            Iterable $this$forEach$iv = declaration2.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirDeclaration decl = (FirDeclaration)element$iv;
                boolean bl4 = false;
                if (decl instanceof FirProperty) {
                    KtSourceElement ktSourceElement = ((FirProperty)decl).getSource();
                    boolean fromConstructor = Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE);
                    if (((FirProperty)decl).isVar() && fromConstructor) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirProperty)decl).getSource(), FirJvmErrors.INSTANCE.getJVM_RECORD_NOT_VAL_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
                        continue;
                    }
                    if (fromConstructor || !DeclarationAttributesKt.getHasBackingField((FirProperty)decl) && ((FirProperty)decl).getDelegateFieldSymbol() == null) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirProperty)decl).getSource(), FirJvmErrors.INSTANCE.getFIELD_IN_JVM_RECORD(), (DiagnosticContext)context2, null, 8, null);
                    continue;
                }
                if (!(decl instanceof FirField)) continue;
                FirDeclaration $this$isSynthetic$iv = decl;
                boolean $i$f$isSynthetic = false;
                if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirField)decl).getSource(), FirJvmErrors.INSTANCE.getDELEGATION_BY_IN_JVM_RECORD(), (DiagnosticContext)context2, null, 8, null);
            }
            FirTypeRef firTypeRef2 = (FirTypeRef)CollectionsKt.firstOrNull(declaration2.getSuperTypeRefs());
            if (firTypeRef2 == null) break block17;
            FirTypeRef typeRef = firTypeRef2;
            boolean bl5 = false;
            KtSourceElement ktSourceElement = typeRef.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE)) {
                FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(typeRef, context2.getSession());
                if ((firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) == ClassKind.CLASS) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJvmErrors.INSTANCE.getJVM_RECORD_EXTENDS_CLASS(), (Object)FirTypeUtilsKt.getConeType(typeRef), (DiagnosticContext)context2, null, 16, null);
                }
            }
        }
    }
}

