/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.java.stubs.impl;

import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.PsiAnnotation;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiJavaParserFacade;
import ksp.com.intellij.psi.impl.PsiElementFactoryImpl;
import ksp.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import ksp.com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import ksp.com.intellij.psi.impl.source.CharTableImpl;
import ksp.com.intellij.psi.stubs.PsiFileStub;
import ksp.com.intellij.psi.stubs.StubBase;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.reference.SoftReference;
import ksp.com.intellij.testFramework.LightVirtualFile;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.org.jetbrains.annotations.NotNull;

public class PsiAnnotationStubImpl
extends StubBase<PsiAnnotation>
implements PsiAnnotationStub {
    private static final Logger LOG = Logger.getInstance(PsiAnnotationStubImpl.class);
    private final String myText;
    private java.lang.ref.SoftReference<PsiAnnotation> myParsedFromRepository;

    public PsiAnnotationStubImpl(StubElement<?> parent2, @NotNull String text) {
        if (text == null) {
            PsiAnnotationStubImpl.$$$reportNull$$$0(0);
        }
        super(parent2, JavaStubElementTypes.ANNOTATION);
        CharSequence interned = CharTableImpl.getStaticInterned(text);
        this.myText = interned == null ? text : interned.toString();
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public PsiAnnotation getPsiElement() {
        PsiAnnotation annotation = SoftReference.dereference(this.myParsedFromRepository);
        if (annotation != null) {
            return annotation;
        }
        String text = this.getText();
        try {
            PsiJavaParserFacade facade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
            annotation = facade instanceof PsiElementFactoryImpl ? ((PsiElementFactoryImpl)facade).createAnnotationFromText(text, (PsiElement)this.getPsi(), false) : facade.createAnnotationFromText(text, (PsiElement)this.getPsi());
            ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
            this.myParsedFromRepository = new java.lang.ref.SoftReference<PsiAnnotation>(annotation);
            return annotation;
        }
        catch (IncorrectOperationException e) {
            LOG.error("Bad annotation in " + this.fileName(), e);
            return null;
        }
    }

    private String fileName() {
        StubElement<PsiAnnotation> stub = this;
        while ((stub = stub.getParentStub()) != null) {
            PsiAnnotation psi;
            if (!(stub instanceof PsiFileStub) || !((psi = stub.getPsi()) instanceof PsiFile)) continue;
            VirtualFile file2 = ((PsiFile)((Object)psi)).getVirtualFile();
            return file2 != null ? file2.getUrl() : ((PsiFile)((Object)psi)).getName();
        }
        return "<unknown file>";
    }

    @Override
    public String toString() {
        return "PsiAnnotationStub[" + this.myText + ']';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "ksp/com/intellij/psi/impl/java/stubs/impl/PsiAnnotationStubImpl", "<init>"));
    }
}

